/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.bounding.OrientedBoundingBox;
import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Objects;

public class BoundingBox
extends BoundingVolume {
    private static final long serialVersionUID = 1L;
    private double _xExtent;
    private double _yExtent;
    private double _zExtent;

    public BoundingBox() {
    }

    public BoundingBox(BoundingBox other) {
        this(other.getCenter(), other.getXExtent(), other.getYExtent(), other.getZExtent());
    }

    public BoundingBox(ReadOnlyVector3 c, double x, double y, double z) {
        this._center.set(c);
        this.setXExtent(x);
        this.setYExtent(y);
        this.setZExtent(z);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getXExtent(), this.getYExtent(), this.getZExtent());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBox other = (BoundingBox)obj;
        if (Double.doubleToLongBits(this._xExtent) != Double.doubleToLongBits(other._xExtent)) {
            return false;
        }
        if (Double.doubleToLongBits(this._yExtent) != Double.doubleToLongBits(other._yExtent)) {
            return false;
        }
        return Double.doubleToLongBits(this._zExtent) == Double.doubleToLongBits(other._zExtent);
    }

    @Override
    public BoundingVolume.Type getType() {
        return BoundingVolume.Type.AABB;
    }

    public void setXExtent(double xExtent) {
        this._xExtent = xExtent;
    }

    public double getXExtent() {
        return this._xExtent;
    }

    public void setYExtent(double yExtent) {
        this._yExtent = yExtent;
    }

    public double getYExtent() {
        return this._yExtent;
    }

    public void setZExtent(double zExtent) {
        this._zExtent = zExtent;
    }

    public double getZExtent() {
        return this._zExtent;
    }

    @Override
    public double getRadius() {
        return MathUtils.sqrt((double)(this._xExtent * this._xExtent + this._yExtent * this._yExtent + this._zExtent * this._zExtent));
    }

    @Override
    public BoundingVolume transform(ReadOnlyTransform transform, BoundingVolume store) {
        int i;
        if (transform.isRotationMatrix()) {
            return this.transformRotational(transform, store);
        }
        BoundingBox box = store == null || store.getType() != BoundingVolume.Type.AABB ? new BoundingBox() : (BoundingBox)store;
        Vector3[] corners = new Vector3[8];
        for (i = 0; i < corners.length; ++i) {
            corners[i] = Vector3.fetchTempInstance();
        }
        this.getCorners(corners);
        for (i = 0; i < corners.length; ++i) {
            transform.applyForward(corners[i]);
        }
        double minX = corners[0].getX();
        double minY = corners[0].getY();
        double minZ = corners[0].getZ();
        double maxX = minX;
        double maxY = minY;
        double maxZ = minZ;
        for (int i2 = 1; i2 < corners.length; ++i2) {
            double curX = corners[i2].getX();
            double curY = corners[i2].getY();
            double curZ = corners[i2].getZ();
            minX = Math.min(minX, curX);
            minY = Math.min(minY, curY);
            minZ = Math.min(minZ, curZ);
            maxX = Math.max(maxX, curX);
            maxY = Math.max(maxY, curY);
            maxZ = Math.max(maxZ, curZ);
        }
        double ctrX = (maxX + minX) * 0.5;
        double ctrY = (maxY + minY) * 0.5;
        double ctrZ = (maxZ + minZ) * 0.5;
        box._center.set(ctrX, ctrY, ctrZ);
        box._xExtent = maxX - ctrX;
        box._yExtent = maxY - ctrY;
        box._zExtent = maxZ - ctrZ;
        for (int i3 = 0; i3 < corners.length; ++i3) {
            Vector3.releaseTempInstance((Vector3)corners[i3]);
        }
        return box;
    }

    public BoundingVolume transformRotational(ReadOnlyTransform transform, BoundingVolume store) {
        ReadOnlyMatrix3 rotate = transform.getMatrix();
        ReadOnlyVector3 scale = transform.getScale();
        ReadOnlyVector3 translate = transform.getTranslation();
        BoundingBox box = store == null || store.getType() != BoundingVolume.Type.AABB ? new BoundingBox() : (BoundingBox)store;
        this._center.multiply(scale, box._center);
        rotate.applyPost((ReadOnlyVector3)box._center, box._center);
        box._center.addLocal(translate);
        Matrix3 transMatrix = Matrix3.fetchTempInstance();
        transMatrix.set(rotate);
        transMatrix.setValue(0, 0, Math.abs(transMatrix.getM00()));
        transMatrix.setValue(0, 1, Math.abs(transMatrix.getM01()));
        transMatrix.setValue(0, 2, Math.abs(transMatrix.getM02()));
        transMatrix.setValue(1, 0, Math.abs(transMatrix.getM10()));
        transMatrix.setValue(1, 1, Math.abs(transMatrix.getM11()));
        transMatrix.setValue(1, 2, Math.abs(transMatrix.getM12()));
        transMatrix.setValue(2, 0, Math.abs(transMatrix.getM20()));
        transMatrix.setValue(2, 1, Math.abs(transMatrix.getM21()));
        transMatrix.setValue(2, 2, Math.abs(transMatrix.getM22()));
        this._compVect1.set(this.getXExtent() * scale.getX(), this.getYExtent() * scale.getY(), this.getZExtent() * scale.getZ());
        transMatrix.applyPost((ReadOnlyVector3)this._compVect1, this._compVect1);
        box.setXExtent(Math.abs(this._compVect1.getX()));
        box.setYExtent(Math.abs(this._compVect1.getY()));
        box.setZExtent(Math.abs(this._compVect1.getZ()));
        Matrix3.releaseTempInstance((Matrix3)transMatrix);
        return box;
    }

    @Override
    public void computeFromPoints(FloatBuffer points) {
        this.containAABB(points);
    }

    @Override
    public void computeFromPrimitives(MeshData data, int section, int[] indices, int start, int end) {
        if (end - start <= 0) {
            return;
        }
        Vector3 min = this._compVect1.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Vector3 max = this._compVect2.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        int vertsPerPrimitive = data.getIndexMode(section).getVertexCount();
        Vector3[] store = new Vector3[vertsPerPrimitive];
        for (int i = start; i < end; ++i) {
            store = data.getPrimitiveVertices(indices[i], section, store);
            for (int j = 0; j < store.length; ++j) {
                this.checkMinMax(min, max, (ReadOnlyVector3)store[j]);
            }
        }
        this._center.set((ReadOnlyVector3)min.addLocal((ReadOnlyVector3)max));
        this._center.multiplyLocal(0.5);
        this.setXExtent(max.getX() - this._center.getX());
        this.setYExtent(max.getY() - this._center.getY());
        this.setZExtent(max.getZ() - this._center.getZ());
    }

    private void checkMinMax(Vector3 min, Vector3 max, ReadOnlyVector3 point) {
        if (point.getX() < min.getX()) {
            min.setX(point.getX());
        }
        if (point.getX() > max.getX()) {
            max.setX(point.getX());
        }
        if (point.getY() < min.getY()) {
            min.setY(point.getY());
        }
        if (point.getY() > max.getY()) {
            max.setY(point.getY());
        }
        if (point.getZ() < min.getZ()) {
            min.setZ(point.getZ());
        }
        if (point.getZ() > max.getZ()) {
            max.setZ(point.getZ());
        }
    }

    public void containAABB(FloatBuffer points) {
        if (points == null) {
            return;
        }
        points.rewind();
        if (points.remaining() <= 2) {
            return;
        }
        BufferUtils.populateFromBuffer(this._compVect1, points, 0);
        double minX = this._compVect1.getX();
        double minY = this._compVect1.getY();
        double minZ = this._compVect1.getZ();
        double maxX = this._compVect1.getX();
        double maxY = this._compVect1.getY();
        double maxZ = this._compVect1.getZ();
        int len = points.remaining() / 3;
        for (int i = 1; i < len; ++i) {
            BufferUtils.populateFromBuffer(this._compVect1, points, i);
            if (this._compVect1.getX() < minX) {
                minX = this._compVect1.getX();
            } else if (this._compVect1.getX() > maxX) {
                maxX = this._compVect1.getX();
            }
            if (this._compVect1.getY() < minY) {
                minY = this._compVect1.getY();
            } else if (this._compVect1.getY() > maxY) {
                maxY = this._compVect1.getY();
            }
            if (this._compVect1.getZ() < minZ) {
                minZ = this._compVect1.getZ();
                continue;
            }
            if (!(this._compVect1.getZ() > maxZ)) continue;
            maxZ = this._compVect1.getZ();
        }
        this._center.set(minX + maxX, minY + maxY, minZ + maxZ);
        this._center.multiplyLocal(0.5);
        this.setXExtent(maxX - this._center.getX());
        this.setYExtent(maxY - this._center.getY());
        this.setZExtent(maxZ - this._center.getZ());
    }

    @Override
    public ReadOnlyPlane.Side whichSide(ReadOnlyPlane plane) {
        ReadOnlyVector3 normal = plane.getNormal();
        double radius = Math.abs(this.getXExtent() * normal.getX()) + Math.abs(this.getYExtent() * normal.getY()) + Math.abs(this.getZExtent() * normal.getZ());
        double distance = plane.pseudoDistance((ReadOnlyVector3)this._center);
        if (distance < -radius) {
            return ReadOnlyPlane.Side.Inside;
        }
        if (distance > radius) {
            return ReadOnlyPlane.Side.Outside;
        }
        return ReadOnlyPlane.Side.Neither;
    }

    @Override
    public BoundingVolume merge(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case AABB: {
                BoundingBox vBox = (BoundingBox)volume;
                return this.merge(vBox._center, vBox.getXExtent(), vBox.getYExtent(), vBox.getZExtent(), new BoundingBox((ReadOnlyVector3)new Vector3(0.0, 0.0, 0.0), 0.0, 0.0, 0.0));
            }
            case Sphere: {
                BoundingSphere vSphere = (BoundingSphere)volume;
                return this.merge(vSphere._center, vSphere.getRadius(), vSphere.getRadius(), vSphere.getRadius(), new BoundingBox((ReadOnlyVector3)new Vector3(0.0, 0.0, 0.0), 0.0, 0.0, 0.0));
            }
            case OBB: {
                OrientedBoundingBox box = (OrientedBoundingBox)volume;
                BoundingBox rVal = (BoundingBox)this.clone(null);
                return rVal.mergeOBB(box);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume mergeLocal(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case AABB: {
                BoundingBox vBox = (BoundingBox)volume;
                return this.merge(vBox._center, vBox.getXExtent(), vBox.getYExtent(), vBox.getZExtent(), this);
            }
            case Sphere: {
                BoundingSphere vSphere = (BoundingSphere)volume;
                return this.merge(vSphere._center, vSphere.getRadius(), vSphere.getRadius(), vSphere.getRadius(), this);
            }
            case OBB: {
                return this.mergeOBB((OrientedBoundingBox)volume);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume asType(BoundingVolume.Type newType) {
        if (newType == null) {
            return null;
        }
        switch (newType) {
            case AABB: {
                return this.clone(null);
            }
            case Sphere: {
                BoundingSphere sphere = new BoundingSphere(0.0, (ReadOnlyVector3)this._center);
                return sphere.merge(this);
            }
            case OBB: {
                OrientedBoundingBox obb = new OrientedBoundingBox();
                obb.setCenter((ReadOnlyVector3)this._center);
                return obb.merge(this);
            }
        }
        return null;
    }

    private BoundingBox mergeOBB(OrientedBoundingBox volume) {
        if (Double.isInfinite(this.getXExtent()) || Double.isInfinite(this.getYExtent()) || Double.isInfinite(this.getZExtent()) || Vector3.isInfinite((ReadOnlyVector3)volume.getExtent())) {
            this.setCenter(Vector3.ZERO);
            this.setXExtent(Double.POSITIVE_INFINITY);
            this.setYExtent(Double.POSITIVE_INFINITY);
            this.setZExtent(Double.POSITIVE_INFINITY);
            return this;
        }
        if (!volume.correctCorners) {
            volume.computeCorners();
        }
        double minX = this._center.getX() - this.getXExtent();
        double minY = this._center.getY() - this.getYExtent();
        double minZ = this._center.getZ() - this.getZExtent();
        double maxX = this._center.getX() + this.getXExtent();
        double maxY = this._center.getY() + this.getYExtent();
        double maxZ = this._center.getZ() + this.getZExtent();
        for (int i = 1; i < volume._vectorStore.length; ++i) {
            Vector3 temp = volume._vectorStore[i];
            if (temp.getX() < minX) {
                minX = temp.getX();
            } else if (temp.getX() > maxX) {
                maxX = temp.getX();
            }
            if (temp.getY() < minY) {
                minY = temp.getY();
            } else if (temp.getY() > maxY) {
                maxY = temp.getY();
            }
            if (temp.getZ() < minZ) {
                minZ = temp.getZ();
                continue;
            }
            if (!(temp.getZ() > maxZ)) continue;
            maxZ = temp.getZ();
        }
        this._center.set(minX + maxX, minY + maxY, minZ + maxZ);
        this._center.multiplyLocal(0.5);
        this.setXExtent(maxX - this._center.getX());
        this.setYExtent(maxY - this._center.getY());
        this.setZExtent(maxZ - this._center.getZ());
        return this;
    }

    private BoundingBox merge(Vector3 boxCenter, double boxX, double boxY, double boxZ, BoundingBox store) {
        if (Double.isInfinite(this.getXExtent()) || Double.isInfinite(this.getYExtent()) || Double.isInfinite(this.getZExtent()) || Double.isInfinite(boxX) || Double.isInfinite(boxY) || Double.isInfinite(boxZ)) {
            store.setCenter(Vector3.ZERO);
            store.setXExtent(Double.POSITIVE_INFINITY);
            store.setYExtent(Double.POSITIVE_INFINITY);
            store.setZExtent(Double.POSITIVE_INFINITY);
            return store;
        }
        this._compVect1.setX(this._center.getX() - this.getXExtent());
        if (this._compVect1.getX() > boxCenter.getX() - boxX) {
            this._compVect1.setX(boxCenter.getX() - boxX);
        }
        this._compVect1.setY(this._center.getY() - this.getYExtent());
        if (this._compVect1.getY() > boxCenter.getY() - boxY) {
            this._compVect1.setY(boxCenter.getY() - boxY);
        }
        this._compVect1.setZ(this._center.getZ() - this.getZExtent());
        if (this._compVect1.getZ() > boxCenter.getZ() - boxZ) {
            this._compVect1.setZ(boxCenter.getZ() - boxZ);
        }
        this._compVect2.setX(this._center.getX() + this.getXExtent());
        if (this._compVect2.getX() < boxCenter.getX() + boxX) {
            this._compVect2.setX(boxCenter.getX() + boxX);
        }
        this._compVect2.setY(this._center.getY() + this.getYExtent());
        if (this._compVect2.getY() < boxCenter.getY() + boxY) {
            this._compVect2.setY(boxCenter.getY() + boxY);
        }
        this._compVect2.setZ(this._center.getZ() + this.getZExtent());
        if (this._compVect2.getZ() < boxCenter.getZ() + boxZ) {
            this._compVect2.setZ(boxCenter.getZ() + boxZ);
        }
        store._center.set((ReadOnlyVector3)this._compVect2).addLocal((ReadOnlyVector3)this._compVect1).multiplyLocal(0.5);
        store.setXExtent(this._compVect2.getX() - store._center.getX());
        store.setYExtent(this._compVect2.getY() - store._center.getY());
        store.setZExtent(this._compVect2.getZ() - store._center.getZ());
        return store;
    }

    @Override
    public BoundingVolume clone(BoundingVolume store) {
        if (store != null && store.getType() == BoundingVolume.Type.AABB) {
            BoundingBox rVal = (BoundingBox)store;
            rVal._center.set((ReadOnlyVector3)this._center);
            rVal.setXExtent(this._xExtent);
            rVal.setYExtent(this._yExtent);
            rVal.setZExtent(this._zExtent);
            rVal._checkPlane = this._checkPlane;
            return rVal;
        }
        BoundingBox rVal = new BoundingBox((ReadOnlyVector3)this._center, this.getXExtent(), this.getYExtent(), this.getZExtent());
        return rVal;
    }

    public String toString() {
        return "com.ardor3d.scene.BoundingBox [Center: " + this._center + "  xExtent: " + this.getXExtent() + "  yExtent: " + this.getYExtent() + "  zExtent: " + this.getZExtent() + "]";
    }

    @Override
    public boolean intersects(BoundingVolume bv) {
        if (bv == null) {
            return false;
        }
        return bv.intersectsBoundingBox(this);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere bs) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bs._center)) {
            return false;
        }
        return Math.abs(this._center.getX() - bs.getCenter().getX()) < bs.getRadius() + this.getXExtent() && Math.abs(this._center.getY() - bs.getCenter().getY()) < bs.getRadius() + this.getYExtent() && Math.abs(this._center.getZ() - bs.getCenter().getZ()) < bs.getRadius() + this.getZExtent();
    }

    @Override
    public boolean intersectsBoundingBox(BoundingBox bb) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bb._center)) {
            return false;
        }
        if (this._center.getX() + this.getXExtent() < bb._center.getX() - bb.getXExtent() || this._center.getX() - this.getXExtent() > bb._center.getX() + bb.getXExtent()) {
            return false;
        }
        if (this._center.getY() + this.getYExtent() < bb._center.getY() - bb.getYExtent() || this._center.getY() - this.getYExtent() > bb._center.getY() + bb.getYExtent()) {
            return false;
        }
        return !(this._center.getZ() + this.getZExtent() < bb._center.getZ() - bb.getZExtent()) && !(this._center.getZ() - this.getZExtent() > bb._center.getZ() + bb.getZExtent());
    }

    @Override
    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox obb) {
        return obb.intersectsBoundingBox(this);
    }

    @Override
    public boolean intersects(ReadOnlyRay3 ray) {
        double z;
        double y;
        if (!Vector3.isValid((ReadOnlyVector3)this._center)) {
            return false;
        }
        Vector3 diff = ray.getOrigin().subtract((ReadOnlyVector3)this._center, this._compVect1);
        ReadOnlyVector3 direction = ray.getDirection();
        double[] t = new double[]{0.0, Double.POSITIVE_INFINITY};
        double x = this.getXExtent();
        if (x < 1.0E-4 && x >= 0.0) {
            x = 1.0E-4;
        }
        if ((y = this.getYExtent()) < 1.0E-4 && y >= 0.0) {
            y = 1.0E-4;
        }
        if ((z = this.getZExtent()) < 1.0E-4 && z >= 0.0) {
            z = 1.0E-4;
        }
        if (Double.isInfinite(x) && Double.isInfinite(y) && Double.isInfinite(z)) {
            return true;
        }
        boolean notEntirelyClipped = this.clip(direction.getX(), -diff.getX() - x, t) && this.clip(-direction.getX(), diff.getX() - x, t) && this.clip(direction.getY(), -diff.getY() - y, t) && this.clip(-direction.getY(), diff.getY() - y, t) && this.clip(direction.getZ(), -diff.getZ() - z, t) && this.clip(-direction.getZ(), diff.getZ() - z, t);
        return notEntirelyClipped && (t[0] != 0.0 || t[1] != Double.POSITIVE_INFINITY);
    }

    @Override
    public IntersectionRecord intersectsWhere(ReadOnlyRay3 ray) {
        boolean notEntirelyClipped;
        double z;
        double y;
        if (!Vector3.isValid((ReadOnlyVector3)this._center)) {
            return null;
        }
        Vector3 diff = ray.getOrigin().subtract((ReadOnlyVector3)this._center, this._compVect1);
        ReadOnlyVector3 direction = ray.getDirection();
        double[] t = new double[]{0.0, Double.POSITIVE_INFINITY};
        double x = this.getXExtent();
        if (x < 1.0E-4 && x >= 0.0) {
            x = 1.0E-4;
        }
        if ((y = this.getYExtent()) < 1.0E-4 && y >= 0.0) {
            y = 1.0E-4;
        }
        if ((z = this.getZExtent()) < 1.0E-4 && z >= 0.0) {
            z = 1.0E-4;
        }
        boolean bl = notEntirelyClipped = this.clip(direction.getX(), -diff.getX() - x, t) && this.clip(-direction.getX(), diff.getX() - x, t) && this.clip(direction.getY(), -diff.getY() - y, t) && this.clip(-direction.getY(), diff.getY() - y, t) && this.clip(direction.getZ(), -diff.getZ() - z, t) && this.clip(-direction.getZ(), diff.getZ() - z, t);
        if (notEntirelyClipped && (t[0] != 0.0 || t[1] != Double.POSITIVE_INFINITY)) {
            if (t[1] > t[0]) {
                double[] distances = t;
                Vector3[] points = new Vector3[]{new Vector3(ray.getDirection()).multiplyLocal(distances[0]).addLocal(ray.getOrigin()), new Vector3(ray.getDirection()).multiplyLocal(distances[1]).addLocal(ray.getOrigin())};
                return new IntersectionRecord(distances, points);
            }
            double[] distances = new double[]{t[0]};
            Vector3[] points = new Vector3[]{new Vector3(ray.getDirection()).multiplyLocal(distances[0]).addLocal(ray.getOrigin())};
            return new IntersectionRecord(distances, points);
        }
        return null;
    }

    @Override
    public boolean contains(ReadOnlyVector3 point) {
        return Math.abs(this._center.getX() - point.getX()) < this.getXExtent() && Math.abs(this._center.getY() - point.getY()) < this.getYExtent() && Math.abs(this._center.getZ() - point.getZ()) < this.getZExtent();
    }

    @Override
    public double distanceToEdge(ReadOnlyVector3 point) {
        double delta;
        Vector3 closest = point.subtract((ReadOnlyVector3)this._center, this._compVect1);
        double sqrDistance = 0.0;
        if (closest.getX() < -this.getXExtent()) {
            delta = closest.getX() + this.getXExtent();
            sqrDistance += delta * delta;
            closest.setX(-this.getXExtent());
        } else if (closest.getX() > this.getXExtent()) {
            delta = closest.getX() - this.getXExtent();
            sqrDistance += delta * delta;
            closest.setX(this.getXExtent());
        }
        if (closest.getY() < -this.getYExtent()) {
            delta = closest.getY() + this.getYExtent();
            sqrDistance += delta * delta;
            closest.setY(-this.getYExtent());
        } else if (closest.getY() > this.getYExtent()) {
            delta = closest.getY() - this.getYExtent();
            sqrDistance += delta * delta;
            closest.setY(this.getYExtent());
        }
        if (closest.getZ() < -this.getZExtent()) {
            delta = closest.getZ() + this.getZExtent();
            sqrDistance += delta * delta;
            closest.setZ(-this.getZExtent());
        } else if (closest.getZ() > this.getZExtent()) {
            delta = closest.getZ() - this.getZExtent();
            sqrDistance += delta * delta;
            closest.setZ(this.getZExtent());
        }
        return Math.sqrt(sqrDistance);
    }

    public Vector3[] getCorners(Vector3[] store) {
        if (store == null) {
            store = new Vector3[8];
            for (int i = 0; i < store.length; ++i) {
                store[i] = new Vector3();
            }
        }
        store[0].set(this._center.getX() + this._xExtent, this._center.getY() + this._yExtent, this._center.getZ() + this._zExtent);
        store[1].set(this._center.getX() + this._xExtent, this._center.getY() + this._yExtent, this._center.getZ() - this._zExtent);
        store[2].set(this._center.getX() + this._xExtent, this._center.getY() - this._yExtent, this._center.getZ() + this._zExtent);
        store[3].set(this._center.getX() + this._xExtent, this._center.getY() - this._yExtent, this._center.getZ() - this._zExtent);
        store[4].set(this._center.getX() - this._xExtent, this._center.getY() + this._yExtent, this._center.getZ() + this._zExtent);
        store[5].set(this._center.getX() - this._xExtent, this._center.getY() + this._yExtent, this._center.getZ() - this._zExtent);
        store[6].set(this._center.getX() - this._xExtent, this._center.getY() - this._yExtent, this._center.getZ() + this._zExtent);
        store[7].set(this._center.getX() - this._xExtent, this._center.getY() - this._yExtent, this._center.getZ() - this._zExtent);
        return store;
    }

    private boolean clip(double denom, double numer, double[] t) {
        if (denom > 0.0) {
            if (numer > denom * t[1]) {
                return false;
            }
            if (numer > denom * t[0]) {
                t[0] = numer / denom;
            }
            return true;
        }
        if (denom < 0.0) {
            if (numer > denom * t[0]) {
                return false;
            }
            if (numer > denom * t[1]) {
                t[1] = numer / denom;
            }
            return true;
        }
        return numer <= 0.0;
    }

    public Vector3 getExtent(Vector3 store) {
        if (store == null) {
            store = new Vector3();
        }
        store.set(this.getXExtent(), this.getYExtent(), this.getZExtent());
        return store;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write(this.getXExtent(), "xExtent", 0.0);
        capsule.write(this.getYExtent(), "yExtent", 0.0);
        capsule.write(this.getZExtent(), "zExtent", 0.0);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this.setXExtent(capsule.readDouble("xExtent", 0.0));
        this.setYExtent(capsule.readDouble("yExtent", 0.0));
        this.setZExtent(capsule.readDouble("zExtent", 0.0));
    }

    @Override
    public double getVolume() {
        return 8.0 * this.getXExtent() * this.getYExtent() * this.getZExtent();
    }
}

