/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.bounding.OrientedBoundingBox;
import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BoundingSphere
extends BoundingVolume {
    private static final Logger logger = Logger.getLogger(BoundingSphere.class.getName());
    private static final long serialVersionUID = 1L;
    private double _radius;
    private static final double radiusEpsilon = 1.00001;
    protected final Vector3 _compVect3 = new Vector3();
    protected final Vector3 _compVect4 = new Vector3();

    public BoundingSphere() {
    }

    public BoundingSphere(double r, ReadOnlyVector3 c) {
        this._center.set(c);
        this.setRadius(r);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRadius());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingSphere other = (BoundingSphere)obj;
        return Double.doubleToLongBits(this._radius) == Double.doubleToLongBits(other._radius);
    }

    @Override
    public BoundingVolume.Type getType() {
        return BoundingVolume.Type.Sphere;
    }

    @Override
    public BoundingVolume transform(ReadOnlyTransform transform, BoundingVolume store) {
        BoundingSphere sphere = store == null || store.getType() != BoundingVolume.Type.Sphere ? new BoundingSphere(1.0, (ReadOnlyVector3)new Vector3(0.0, 0.0, 0.0)) : (BoundingSphere)store;
        transform.applyForward((ReadOnlyVector3)this._center, sphere._center);
        if (!transform.isRotationMatrix()) {
            Vector3 scale = this._compVect3.set(1.0, 1.0, 1.0);
            transform.applyForwardVector(scale);
            sphere.setRadius(Math.abs(this.maxAxis((ReadOnlyVector3)scale) * this.getRadius()) + 1.00001 - 1.0);
        } else {
            ReadOnlyVector3 scale = transform.getScale();
            sphere.setRadius(Math.abs(this.maxAxis(scale) * this.getRadius()) + 1.00001 - 1.0);
        }
        return sphere;
    }

    private double maxAxis(ReadOnlyVector3 scale) {
        return Math.max(Math.abs(scale.getX()), Math.max(Math.abs(scale.getY()), Math.abs(scale.getZ())));
    }

    @Override
    public double getRadius() {
        return this._radius;
    }

    public void setRadius(double radius) {
        this._radius = radius;
    }

    @Override
    public void computeFromPoints(FloatBuffer points) {
        this.calcWelzl(points);
    }

    @Override
    public void computeFromPrimitives(MeshData data, int section, int[] indices, int start, int end) {
        int i;
        if (end - start <= 0) {
            return;
        }
        int vertsPerPrimitive = data.getIndexMode(section).getVertexCount();
        Vector3[] vertList = new Vector3[(end - start) * vertsPerPrimitive];
        Vector3[] store = new Vector3[vertsPerPrimitive];
        int count = 0;
        for (i = start; i < end; ++i) {
            store = data.getPrimitiveVertices(indices[i], section, store);
            for (int j = 0; j < vertsPerPrimitive; ++j) {
                vertList[count++] = Vector3.fetchTempInstance().set((ReadOnlyVector3)store[j]);
            }
        }
        this.averagePoints(vertList);
        for (i = 0; i < vertList.length; ++i) {
            Vector3.releaseTempInstance((Vector3)vertList[i]);
        }
    }

    public void calcWelzl(FloatBuffer points) {
        float[] buf = new float[points.limit()];
        points.rewind();
        points.get(buf);
        this.recurseMini(buf, buf.length / 3, 0, 0);
    }

    private void recurseMini(float[] points, int p, int pnts, int ap) {
        switch (pnts) {
            case 0: {
                this.setRadius(0.0);
                this._center.set(0.0, 0.0, 0.0);
                break;
            }
            case 1: {
                this.setRadius(-1.0000000000065512E-5);
                BoundingSphere.populateFromBuffer(this._center, points, ap - 1);
                break;
            }
            case 2: {
                BoundingSphere.populateFromBuffer(this._compVect1, points, ap - 1);
                BoundingSphere.populateFromBuffer(this._compVect2, points, ap - 2);
                this.setSphere(this._compVect1, this._compVect2);
                break;
            }
            case 3: {
                BoundingSphere.populateFromBuffer(this._compVect1, points, ap - 1);
                BoundingSphere.populateFromBuffer(this._compVect2, points, ap - 2);
                BoundingSphere.populateFromBuffer(this._compVect3, points, ap - 3);
                this.setSphere(this._compVect1, this._compVect2, this._compVect3);
                break;
            }
            case 4: {
                BoundingSphere.populateFromBuffer(this._compVect1, points, ap - 1);
                BoundingSphere.populateFromBuffer(this._compVect2, points, ap - 2);
                BoundingSphere.populateFromBuffer(this._compVect3, points, ap - 3);
                BoundingSphere.populateFromBuffer(this._compVect4, points, ap - 4);
                this.setSphere(this._compVect1, this._compVect2, this._compVect3, this._compVect4);
                return;
            }
        }
        for (int i = 0; i < p; ++i) {
            BoundingSphere.populateFromBuffer(this._compVect1, points, i + ap);
            if (!(this._compVect1.distanceSquared((ReadOnlyVector3)this._center) - this.getRadius() * this.getRadius() > 1.0000000000065512E-5)) continue;
            for (int j = i; j > 0; --j) {
                BoundingSphere.populateFromBuffer(this._compVect2, points, j + ap);
                BoundingSphere.populateFromBuffer(this._compVect3, points, j - 1 + ap);
                BoundingSphere.setInBuffer((ReadOnlyVector3)this._compVect3, points, j + ap);
                BoundingSphere.setInBuffer((ReadOnlyVector3)this._compVect2, points, j - 1 + ap);
            }
            this.recurseMini(points, i, pnts + 1, ap + 1);
        }
    }

    public static void populateFromBuffer(Vector3 vector, float[] buf, int index) {
        vector.setX((double)buf[index * 3]);
        vector.setY((double)buf[index * 3 + 1]);
        vector.setZ((double)buf[index * 3 + 2]);
    }

    public static void setInBuffer(ReadOnlyVector3 vector, float[] buf, int index) {
        if (buf == null) {
            return;
        }
        if (vector == null) {
            buf[index * 3] = 0.0f;
            buf[index * 3 + 1] = 0.0f;
            buf[index * 3 + 2] = 0.0f;
        } else {
            buf[index * 3] = vector.getXf();
            buf[index * 3 + 1] = vector.getYf();
            buf[index * 3 + 2] = vector.getZf();
        }
    }

    private void setSphere(Vector3 O, Vector3 A, Vector3 B, Vector3 C) {
        Vector3 a = A.subtract((ReadOnlyVector3)O, null);
        Vector3 b = B.subtract((ReadOnlyVector3)O, null);
        Vector3 c = C.subtract((ReadOnlyVector3)O, null);
        double Denominator = 2.0 * (a.getX() * (b.getY() * c.getZ() - c.getY() * b.getZ()) - b.getX() * (a.getY() * c.getZ() - c.getY() * a.getZ()) + c.getX() * (a.getY() * b.getZ() - b.getY() * a.getZ()));
        if (Denominator == 0.0) {
            this._center.set(0.0, 0.0, 0.0);
            this.setRadius(0.0);
        } else {
            Vector3 o = a.cross((ReadOnlyVector3)b, null).multiplyLocal(c.lengthSquared()).addLocal((ReadOnlyVector3)c.cross((ReadOnlyVector3)a, null).multiplyLocal(b.lengthSquared())).addLocal((ReadOnlyVector3)b.cross((ReadOnlyVector3)c, null).multiplyLocal(a.lengthSquared())).divideLocal(Denominator);
            this.setRadius(o.length() * 1.00001);
            O.add((ReadOnlyVector3)o, this._center);
        }
    }

    private void setSphere(Vector3 O, Vector3 A, Vector3 B) {
        Vector3 b;
        Vector3 a = A.subtract((ReadOnlyVector3)O, null);
        Vector3 acrossB = a.cross((ReadOnlyVector3)(b = B.subtract((ReadOnlyVector3)O, null)), null);
        double Denominator = 2.0 * acrossB.dot((ReadOnlyVector3)acrossB);
        if (Denominator == 0.0) {
            this._center.set(0.0, 0.0, 0.0);
            this.setRadius(0.0);
        } else {
            Vector3 o = acrossB.cross((ReadOnlyVector3)a, null).multiplyLocal(b.lengthSquared()).addLocal((ReadOnlyVector3)b.cross((ReadOnlyVector3)acrossB, null).multiplyLocal(a.lengthSquared())).divideLocal(Denominator);
            this.setRadius(o.length() * 1.00001);
            O.add((ReadOnlyVector3)o, this._center);
        }
    }

    private void setSphere(Vector3 O, Vector3 A) {
        this.setRadius(Math.sqrt(((A.getX() - O.getX()) * (A.getX() - O.getX()) + (A.getY() - O.getY()) * (A.getY() - O.getY()) + (A.getZ() - O.getZ()) * (A.getZ() - O.getZ())) / 4.0) + 1.00001 - 1.0);
        Vector3.lerp((ReadOnlyVector3)O, (ReadOnlyVector3)A, (double)0.5, (Vector3)this._center);
    }

    public void averagePoints(Vector3[] points) {
        this._center.set((ReadOnlyVector3)points[0]);
        for (int i = 1; i < points.length; ++i) {
            this._center.addLocal((ReadOnlyVector3)points[i]);
        }
        double quantity = 1.0 / (double)points.length;
        this._center.multiplyLocal(quantity);
        double maxRadiusSqr = 0.0;
        for (int i = 0; i < points.length; ++i) {
            Vector3 diff = points[i].subtract((ReadOnlyVector3)this._center, this._compVect1);
            double radiusSqr = diff.lengthSquared();
            if (!(radiusSqr > maxRadiusSqr)) continue;
            maxRadiusSqr = radiusSqr;
        }
        this.setRadius(Math.sqrt(maxRadiusSqr) + 1.00001 - 1.0);
    }

    @Override
    public ReadOnlyPlane.Side whichSide(ReadOnlyPlane plane) {
        double distance = plane.pseudoDistance((ReadOnlyVector3)this._center);
        if (distance <= -this.getRadius()) {
            return ReadOnlyPlane.Side.Inside;
        }
        if (distance >= this.getRadius()) {
            return ReadOnlyPlane.Side.Outside;
        }
        return ReadOnlyPlane.Side.Neither;
    }

    @Override
    public BoundingVolume merge(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case Sphere: {
                BoundingSphere sphere = (BoundingSphere)volume;
                double temp_radius = sphere.getRadius();
                ReadOnlyVector3 tempCenter = sphere.getCenter();
                BoundingSphere rVal = new BoundingSphere();
                return this.merge(temp_radius, tempCenter, rVal);
            }
            case AABB: {
                BoundingBox box = (BoundingBox)volume;
                Vector3 radVect = new Vector3(box.getXExtent(), box.getYExtent(), box.getZExtent());
                Vector3 tempCenter = box._center;
                BoundingSphere rVal = new BoundingSphere();
                return this.merge(radVect.length(), (ReadOnlyVector3)tempCenter, rVal);
            }
            case OBB: {
                OrientedBoundingBox box = (OrientedBoundingBox)volume;
                BoundingSphere rVal = (BoundingSphere)this.clone(null);
                return rVal.mergeLocalOBB(box);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume mergeLocal(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case Sphere: {
                BoundingSphere sphere = (BoundingSphere)volume;
                double temp_radius = sphere.getRadius();
                ReadOnlyVector3 temp_center = sphere.getCenter();
                return this.merge(temp_radius, temp_center, this);
            }
            case AABB: {
                BoundingBox box = (BoundingBox)volume;
                Vector3 temp_center = box._center;
                this._compVect1.set(box.getXExtent(), box.getYExtent(), box.getZExtent());
                double radius = this._compVect1.length();
                return this.merge(radius, (ReadOnlyVector3)temp_center, this);
            }
            case OBB: {
                return this.mergeLocalOBB((OrientedBoundingBox)volume);
            }
        }
        return null;
    }

    private BoundingSphere mergeLocalOBB(OrientedBoundingBox volume) {
        if (Double.isInfinite(this.getRadius()) || Vector3.isInfinite((ReadOnlyVector3)volume.getExtent())) {
            this.setCenter(Vector3.ZERO);
            this.setRadius(Double.POSITIVE_INFINITY);
            return this;
        }
        if (!volume.correctCorners) {
            volume.computeCorners();
        }
        FloatBuffer mergeBuf = BufferUtils.createFloatBufferOnHeap(24);
        for (int i = 0; i < 8; ++i) {
            mergeBuf.put((float)volume._vectorStore[i].getX());
            mergeBuf.put((float)volume._vectorStore[i].getY());
            mergeBuf.put((float)volume._vectorStore[i].getZ());
        }
        double oldRadius = this.getRadius();
        double oldCenterX = this._center.getX();
        double oldCenterY = this._center.getY();
        double oldCenterZ = this._center.getZ();
        this.computeFromPoints(mergeBuf);
        double newCenterX = this._center.getX();
        double newCenterY = this._center.getY();
        double newCenterZ = this._center.getZ();
        double newRadius = this.getRadius();
        this._center.set(oldCenterX, oldCenterY, oldCenterZ);
        this.setRadius(oldRadius);
        this.merge(newRadius, (ReadOnlyVector3)this._compVect4.set(newCenterX, newCenterY, newCenterZ), this);
        return this;
    }

    private BoundingVolume merge(double otherRadius, ReadOnlyVector3 otherCenter, BoundingSphere store) {
        if (Double.isInfinite(otherRadius) || Double.isInfinite(this.getRadius())) {
            store.setCenter(Vector3.ZERO);
            store.setRadius(Double.POSITIVE_INFINITY);
            return store;
        }
        Vector3 diff = otherCenter.subtract((ReadOnlyVector3)this._center, this._compVect1);
        double lengthSquared = diff.lengthSquared();
        double radiusDiff = otherRadius - this.getRadius();
        double radiusDiffSqr = radiusDiff * radiusDiff;
        if (radiusDiffSqr >= lengthSquared) {
            if (radiusDiff <= 0.0) {
                store.setCenter((ReadOnlyVector3)this._center);
                store.setRadius(this._radius);
                return store;
            }
            store.setCenter(otherCenter);
            store.setRadius(otherRadius);
            return store;
        }
        double length = Math.sqrt(lengthSquared);
        Vector3 rCenter = this._compVect2;
        rCenter.set((ReadOnlyVector3)this._center);
        if (length > 2.220446049250313E-16) {
            double coeff = (length + radiusDiff) / (2.0 * length);
            rCenter.addLocal((ReadOnlyVector3)diff.multiplyLocal(coeff));
        }
        store.setCenter((ReadOnlyVector3)rCenter);
        store.setRadius(0.5 * (length + this.getRadius() + otherRadius));
        return store;
    }

    @Override
    public BoundingVolume asType(BoundingVolume.Type newType) {
        if (newType == null) {
            return null;
        }
        switch (newType) {
            case AABB: {
                BoundingBox box = new BoundingBox((ReadOnlyVector3)this._center, 0.0, 0.0, 0.0);
                return box.merge(this);
            }
            case Sphere: {
                return this.clone(null);
            }
            case OBB: {
                OrientedBoundingBox obb = new OrientedBoundingBox();
                obb.setCenter((ReadOnlyVector3)this._center);
                return obb.merge(this);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume clone(BoundingVolume store) {
        if (store != null && store.getType() == BoundingVolume.Type.Sphere) {
            BoundingSphere rVal = (BoundingSphere)store;
            rVal._center.set((ReadOnlyVector3)this._center);
            rVal.setRadius(this._radius);
            rVal._checkPlane = this._checkPlane;
            return rVal;
        }
        return new BoundingSphere(this.getRadius(), (ReadOnlyVector3)this._center);
    }

    public String toString() {
        return "com.ardor3d.scene.BoundingSphere [Radius: " + this.getRadius() + " Center: " + this._center + "]";
    }

    @Override
    public boolean intersects(BoundingVolume bv) {
        if (bv == null) {
            return false;
        }
        return bv.intersectsSphere(this);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere bs) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bs._center)) {
            return false;
        }
        Vector3 diff = this._compVect1.set(this.getCenter()).subtractLocal(bs.getCenter());
        double rsum = this.getRadius() + bs.getRadius();
        return diff.dot((ReadOnlyVector3)diff) <= rsum * rsum;
    }

    @Override
    public boolean intersectsBoundingBox(BoundingBox bb) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bb._center)) {
            return false;
        }
        return Math.abs(bb._center.getX() - this.getCenter().getX()) < this.getRadius() + bb.getXExtent() && Math.abs(bb._center.getY() - this.getCenter().getY()) < this.getRadius() + bb.getYExtent() && Math.abs(bb._center.getZ() - this.getCenter().getZ()) < this.getRadius() + bb.getZExtent();
    }

    @Override
    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox obb) {
        return obb.intersectsSphere(this);
    }

    @Override
    public boolean intersects(ReadOnlyRay3 ray) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center)) {
            return false;
        }
        Vector3 diff = ray.getOrigin().subtract(this.getCenter(), this._compVect1);
        double radiusSquared = this.getRadius() * this.getRadius();
        double a = diff.dot((ReadOnlyVector3)diff) - radiusSquared;
        if (a <= 0.0) {
            return true;
        }
        Vector3 dir = this._compVect2.set(ray.getDirection());
        double b = dir.dot((ReadOnlyVector3)diff);
        if (b >= 0.0) {
            return false;
        }
        return b * b >= a;
    }

    @Override
    public IntersectionRecord intersectsWhere(ReadOnlyRay3 ray) {
        Vector3 diff = ray.getOrigin().subtract(this.getCenter(), this._compVect1);
        double a = diff.dot((ReadOnlyVector3)diff) - this.getRadius() * this.getRadius();
        if (a <= 0.0) {
            double a1 = ray.getDirection().dot((ReadOnlyVector3)diff);
            double discr = a1 * a1 - a;
            double root = Math.sqrt(discr);
            double[] distances = new double[]{root - a1};
            Vector3[] points = new Vector3[]{ray.getDirection().multiply(distances[0], new Vector3()).addLocal(ray.getOrigin())};
            return new IntersectionRecord(distances, points);
        }
        double a1 = ray.getDirection().dot((ReadOnlyVector3)diff);
        if (a1 >= 0.0) {
            return null;
        }
        double discr = a1 * a1 - a;
        if (discr < 0.0) {
            return null;
        }
        if (discr >= 1.0E-4) {
            double root = Math.sqrt(discr);
            double[] distances = new double[]{-a1 - root, -a1 + root};
            Vector3[] points = new Vector3[]{ray.getDirection().multiply(distances[0], new Vector3()).addLocal(ray.getOrigin()), ray.getDirection().multiply(distances[1], new Vector3()).addLocal(ray.getOrigin())};
            IntersectionRecord record = new IntersectionRecord(distances, points);
            return record;
        }
        double[] distances = new double[]{-a1};
        Vector3[] points = new Vector3[]{ray.getDirection().multiply(distances[0], new Vector3()).addLocal(ray.getOrigin())};
        return new IntersectionRecord(distances, points);
    }

    @Override
    public boolean contains(ReadOnlyVector3 point) {
        return this.getCenter().distanceSquared(point) < this.getRadius() * this.getRadius();
    }

    @Override
    public double distanceToEdge(ReadOnlyVector3 point) {
        return this._center.distance(point) - this.getRadius();
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        try {
            capsule.write(this.getRadius(), "radius", 0.0);
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "write(Ardor3DExporter)", "Exception", ex);
        }
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        try {
            this.setRadius(capsule.readDouble("radius", 0.0));
        }
        catch (IOException ex) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "read(Ardor3DImporter)", "Exception", ex);
        }
    }

    @Override
    public double getVolume() {
        return 4.1887902047863905 * this.getRadius() * this.getRadius() * this.getRadius();
    }
}

