/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.OrientedBoundingBox;
import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.Objects;

public abstract class BoundingVolume
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    protected int _checkPlane = 0;
    protected final Vector3 _center = new Vector3();
    protected final Vector3 _compVect1 = new Vector3();
    protected final Vector3 _compVect2 = new Vector3();

    public BoundingVolume() {
    }

    public BoundingVolume(Vector3 center) {
        this._center.set((ReadOnlyVector3)center);
    }

    public int hashCode() {
        return Objects.hashCode(this.getCenter());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingVolume other = (BoundingVolume)obj;
        return Objects.equals(this._center, other._center);
    }

    public int getCheckPlane() {
        return this._checkPlane;
    }

    public final void setCheckPlane(int value) {
        this._checkPlane = value;
    }

    public abstract Type getType();

    public abstract BoundingVolume transform(ReadOnlyTransform var1, BoundingVolume var2);

    public abstract ReadOnlyPlane.Side whichSide(ReadOnlyPlane var1);

    public abstract void computeFromPoints(FloatBuffer var1);

    public abstract BoundingVolume merge(BoundingVolume var1);

    public abstract BoundingVolume mergeLocal(BoundingVolume var1);

    public abstract BoundingVolume clone(BoundingVolume var1);

    public abstract double getRadius();

    public final ReadOnlyVector3 getCenter() {
        return this._center;
    }

    public final void setCenter(ReadOnlyVector3 newCenter) {
        this._center.set(newCenter);
    }

    public void setCenter(double x, double y, double z) {
        this._center.set(x, y, z);
    }

    public final double distanceTo(ReadOnlyVector3 point) {
        return this._center.distance(point);
    }

    public final double distanceSquaredTo(ReadOnlyVector3 point) {
        return this._center.distanceSquared(point);
    }

    public abstract double distanceToEdge(ReadOnlyVector3 var1);

    public abstract boolean intersects(BoundingVolume var1);

    public abstract boolean intersects(ReadOnlyRay3 var1);

    public abstract IntersectionRecord intersectsWhere(ReadOnlyRay3 var1);

    public abstract boolean intersectsSphere(BoundingSphere var1);

    public abstract boolean intersectsBoundingBox(BoundingBox var1);

    public abstract boolean intersectsOrientedBoundingBox(OrientedBoundingBox var1);

    public abstract boolean contains(ReadOnlyVector3 var1);

    public abstract BoundingVolume asType(Type var1);

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Savable)this._center, "center", (Savable)new Vector3(Vector3.ZERO));
    }

    public void read(InputCapsule capsule) throws IOException {
        this._center.set((ReadOnlyVector3)((Vector3)capsule.readSavable("center", (Savable)new Vector3(Vector3.ZERO))));
    }

    public Class<? extends BoundingVolume> getClassTag() {
        return this.getClass();
    }

    public abstract void computeFromPrimitives(MeshData var1, int var2, int[] var3, int var4, int var5);

    public abstract double getVolume();

    public static enum Type {
        Sphere,
        AABB,
        OBB;

    }
}

