/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.bounding.CollisionTreeManager;
import com.ardor3d.bounding.OrientedBoundingBox;
import com.ardor3d.bounding.TreeComparator;
import com.ardor3d.intersection.Intersection;
import com.ardor3d.intersection.PrimitiveKey;
import com.ardor3d.math.Ray3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class CollisionTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Type _type = Type.AABB;
    protected CollisionTree _left;
    protected CollisionTree _right;
    protected BoundingVolume _bounds;
    protected BoundingVolume _worldBounds;
    protected int[] _primitiveIndices;
    protected int _start;
    protected int _end;
    protected transient WeakReference<Mesh> _mesh;
    protected int _section;
    protected final transient TreeComparator _comparator = new TreeComparator();

    public CollisionTree(Type type) {
        this._type = type;
    }

    public void construct(int childIndex, int section, Node parent, boolean doSort) {
        Spatial spat = parent.getChild(childIndex);
        if (spat instanceof Mesh) {
            this._mesh = this.makeRef((Mesh)spat);
            this._primitiveIndices = new int[((Mesh)spat).getMeshData().getPrimitiveCount(section)];
            for (int i = 0; i < this._primitiveIndices.length; ++i) {
                this._primitiveIndices[i] = i;
            }
            this.createTree(section, 0, this._primitiveIndices.length, doSort);
        }
    }

    public void construct(Mesh mesh, boolean doSort) {
        this._mesh = this.makeRef(mesh);
        if (mesh.getMeshData().getSectionCount() == 1) {
            this._primitiveIndices = new int[mesh.getMeshData().getPrimitiveCount(0)];
            for (int i = 0; i < this._primitiveIndices.length; ++i) {
                this._primitiveIndices[i] = i;
            }
            this.createTree(0, 0, this._primitiveIndices.length, doSort);
        } else {
            this.splitMesh(mesh, 0, mesh.getMeshData().getSectionCount(), doSort);
        }
    }

    protected void splitMesh(Mesh mesh, int sectionStart, int sectionEnd, boolean doSort) {
        int i;
        int section;
        this._mesh = this.makeRef(mesh);
        int rangeSize = sectionEnd - sectionStart;
        int halfRange = rangeSize / 2;
        if (halfRange == 1) {
            section = sectionStart;
            this._left = new CollisionTree(this._type);
            this._left._primitiveIndices = new int[mesh.getMeshData().getPrimitiveCount(section)];
            for (i = 0; i < this._left._primitiveIndices.length; ++i) {
                this._left._primitiveIndices[i] = i;
            }
            this._left._mesh = this._mesh;
            this._left.createTree(section, 0, this._left._primitiveIndices.length, doSort);
        } else {
            this._left = new CollisionTree(this._type);
            this._left.splitMesh(mesh, sectionStart, sectionStart + halfRange, doSort);
        }
        if (rangeSize - halfRange == 1) {
            section = sectionStart + 1;
            this._right = new CollisionTree(this._type);
            this._right._primitiveIndices = new int[mesh.getMeshData().getPrimitiveCount(section)];
            for (i = 0; i < this._right._primitiveIndices.length; ++i) {
                this._right._primitiveIndices[i] = i;
            }
            this._right._mesh = this._mesh;
            this._right.createTree(section, 0, this._right._primitiveIndices.length, doSort);
        } else {
            this._right = new CollisionTree(this._type);
            this._right.splitMesh(mesh, sectionStart + halfRange, sectionEnd, doSort);
        }
        this._bounds = this._left._bounds.clone(this._bounds);
        this._bounds.mergeLocal(this._right._bounds);
        this._worldBounds = this._bounds.clone(this._worldBounds);
    }

    public void createTree(int section, int start, int end, boolean doSort) {
        this._section = section;
        this._start = start;
        this._end = end;
        if (this._primitiveIndices == null) {
            return;
        }
        this.createBounds();
        this._bounds.computeFromPrimitives(this.getMesh().getMeshData(), this._section, this._primitiveIndices, this._start, this._end);
        if (this._end - this._start + 1 <= CollisionTreeManager.getInstance().getMaxPrimitivesPerLeaf()) {
            this._left = null;
            this._right = null;
            return;
        }
        if (doSort) {
            this.sortPrimitives();
        }
        if (this._left == null) {
            this._left = new CollisionTree(this._type);
        }
        this._left._primitiveIndices = this._primitiveIndices;
        this._left._mesh = this._mesh;
        this._left.createTree(this._section, this._start, (this._start + this._end) / 2, doSort);
        if (this._right == null) {
            this._right = new CollisionTree(this._type);
        }
        this._right._primitiveIndices = this._primitiveIndices;
        this._right._mesh = this._mesh;
        this._right.createTree(this._section, (this._start + this._end) / 2, this._end, doSort);
    }

    public boolean intersectsBounding(BoundingVolume volume) {
        switch (volume.getType()) {
            case AABB: {
                return this._worldBounds.intersectsBoundingBox((BoundingBox)volume);
            }
            case OBB: {
                return this._worldBounds.intersectsOrientedBoundingBox((OrientedBoundingBox)volume);
            }
            case Sphere: {
                return this._worldBounds.intersectsSphere((BoundingSphere)volume);
            }
        }
        return false;
    }

    public boolean intersect(CollisionTree collisionTree) {
        if (collisionTree == null) {
            return false;
        }
        collisionTree._worldBounds = collisionTree._bounds.transform(collisionTree.getMesh().getWorldTransform(), collisionTree._worldBounds);
        if (!this.intersectsBounding(collisionTree._worldBounds)) {
            return false;
        }
        if (this._left != null) {
            if (collisionTree.intersect(this._left)) {
                return true;
            }
            return collisionTree.intersect(this._right);
        }
        if (collisionTree._left != null) {
            if (this.intersect(collisionTree._left)) {
                return true;
            }
            return this.intersect(collisionTree._right);
        }
        ReadOnlyTransform transformA = this.getMesh().getWorldTransform();
        ReadOnlyTransform transformB = collisionTree.getMesh().getWorldTransform();
        MeshData dataA = this.getMesh().getMeshData();
        MeshData dataB = collisionTree.getMesh().getMeshData();
        Vector3[] storeA = null;
        Vector3[] storeB = null;
        for (int i = this._start; i < this._end; ++i) {
            storeA = dataA.getPrimitiveVertices(this._primitiveIndices[i], this._section, storeA);
            for (int t = 0; t < storeA.length; ++t) {
                transformA.applyForward(storeA[t]);
            }
            for (int j = collisionTree._start; j < collisionTree._end; ++j) {
                storeB = dataB.getPrimitiveVertices(collisionTree._primitiveIndices[j], collisionTree._section, storeB);
                for (int t = 0; t < storeB.length; ++t) {
                    transformB.applyForward(storeB[t]);
                }
                if (!Intersection.intersection(storeA, storeB)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersect(CollisionTree collisionTree, List<PrimitiveKey> aList, List<PrimitiveKey> bList) {
        if (collisionTree == null) {
            return false;
        }
        collisionTree._worldBounds = collisionTree._bounds.transform(collisionTree.getMesh().getWorldTransform(), collisionTree._worldBounds);
        if (!this.intersectsBounding(collisionTree._worldBounds)) {
            return false;
        }
        if (this._left != null) {
            boolean test = collisionTree.intersect(this._left, bList, aList);
            test = collisionTree.intersect(this._right, bList, aList) || test;
            return test;
        }
        if (collisionTree._left != null) {
            boolean test = this.intersect(collisionTree._left, aList, bList);
            test = this.intersect(collisionTree._right, aList, bList) || test;
            return test;
        }
        ReadOnlyTransform transformA = this.getMesh().getWorldTransform();
        ReadOnlyTransform transformB = collisionTree.getMesh().getWorldTransform();
        MeshData dataA = this.getMesh().getMeshData();
        MeshData dataB = collisionTree.getMesh().getMeshData();
        Vector3[] storeA = null;
        Vector3[] storeB = null;
        boolean test = false;
        for (int i = this._start; i < this._end; ++i) {
            storeA = dataA.getPrimitiveVertices(this._primitiveIndices[i], this._section, storeA);
            for (int t = 0; t < storeA.length; ++t) {
                transformA.applyForward(storeA[t]);
            }
            for (int j = collisionTree._start; j < collisionTree._end; ++j) {
                storeB = dataB.getPrimitiveVertices(collisionTree._primitiveIndices[j], collisionTree._section, storeB);
                for (int t = 0; t < storeB.length; ++t) {
                    transformB.applyForward(storeB[t]);
                }
                if (!Intersection.intersection(storeA, storeB)) continue;
                test = true;
                aList.add(new PrimitiveKey(this._primitiveIndices[i], this._section));
                bList.add(new PrimitiveKey(collisionTree._primitiveIndices[j], collisionTree._section));
            }
        }
        return test;
    }

    public List<PrimitiveKey> intersect(Ray3 ray, List<PrimitiveKey> store) {
        List<PrimitiveKey> result = store;
        if (result == null) {
            result = new ArrayList<PrimitiveKey>();
        }
        if (!this._worldBounds.intersects((ReadOnlyRay3)ray)) {
            return result;
        }
        if (this._left != null) {
            this._left._worldBounds = this._left._bounds.transform(this.getMesh().getWorldTransform(), this._left._worldBounds);
            this._left.intersect(ray, result);
        }
        if (this._right != null) {
            this._right._worldBounds = this._right._bounds.transform(this.getMesh().getWorldTransform(), this._right._worldBounds);
            this._right.intersect(ray, result);
        } else if (this._left == null) {
            MeshData data = this.getMesh().getMeshData();
            ReadOnlyTransform transform = this.getMesh().getWorldTransform();
            Vector3[] points = null;
            for (int i = this._start; i < this._end; ++i) {
                points = data.getPrimitiveVertices(this._primitiveIndices[i], this._section, points);
                for (int t = 0; t < points.length; ++t) {
                    transform.applyForward(points[t]);
                }
                if (!ray.intersects(points, null)) continue;
                result.add(new PrimitiveKey(this._primitiveIndices[i], this._section));
            }
        }
        return result;
    }

    public BoundingVolume getBounds() {
        return this._bounds;
    }

    public BoundingVolume getWorldBounds() {
        return this._worldBounds;
    }

    private void createBounds() {
        switch (this._type) {
            case AABB: {
                this._bounds = new BoundingBox();
                this._worldBounds = new BoundingBox();
                break;
            }
            case OBB: {
                this._bounds = new OrientedBoundingBox();
                this._worldBounds = new OrientedBoundingBox();
                break;
            }
            case Sphere: {
                this._bounds = new BoundingSphere();
                this._worldBounds = new BoundingSphere();
                break;
            }
        }
    }

    public void sortPrimitives() {
        switch (this._type) {
            case AABB: {
                if (((BoundingBox)this._bounds).getXExtent() > ((BoundingBox)this._bounds).getYExtent()) {
                    if (((BoundingBox)this._bounds).getXExtent() > ((BoundingBox)this._bounds).getZExtent()) {
                        this._comparator.setAxis(TreeComparator.Axis.X);
                        break;
                    }
                    this._comparator.setAxis(TreeComparator.Axis.Z);
                    break;
                }
                if (((BoundingBox)this._bounds).getYExtent() > ((BoundingBox)this._bounds).getZExtent()) {
                    this._comparator.setAxis(TreeComparator.Axis.Y);
                    break;
                }
                this._comparator.setAxis(TreeComparator.Axis.Z);
                break;
            }
            case OBB: {
                if (((OrientedBoundingBox)this._bounds)._extent.getX() > ((OrientedBoundingBox)this._bounds)._extent.getY()) {
                    if (((OrientedBoundingBox)this._bounds)._extent.getX() > ((OrientedBoundingBox)this._bounds)._extent.getZ()) {
                        this._comparator.setAxis(TreeComparator.Axis.X);
                        break;
                    }
                    this._comparator.setAxis(TreeComparator.Axis.Z);
                    break;
                }
                if (((OrientedBoundingBox)this._bounds)._extent.getY() > ((OrientedBoundingBox)this._bounds)._extent.getZ()) {
                    this._comparator.setAxis(TreeComparator.Axis.Y);
                    break;
                }
                this._comparator.setAxis(TreeComparator.Axis.Z);
                break;
            }
            case Sphere: {
                this._comparator.setAxis(TreeComparator.Axis.X);
                break;
            }
        }
        this._comparator.setMesh(this.getMesh());
    }

    private Mesh getMesh() {
        return (Mesh)this._mesh.get();
    }

    private WeakReference<Mesh> makeRef(Mesh mesh) {
        return new WeakReference<Mesh>(mesh);
    }

    public static enum Type {
        OBB,
        AABB,
        Sphere;

    }
}

