/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.CollisionTree;
import com.ardor3d.bounding.CollisionTreeController;
import com.ardor3d.bounding.UsageTreeController;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public enum CollisionTreeManager {
    INSTANCE;

    public static final int DEFAULT_MAX_ELEMENTS = 25;
    public static final int DEFAULT_MAX_PRIMITIVES_PER_LEAF = 16;
    private final Map<Mesh, CollisionTree> _cache;
    private final List<Mesh> _protectedList;
    private boolean _generateTrees = true;
    private boolean _doSort;
    private CollisionTree.Type _treeType = CollisionTree.Type.AABB;
    private int _maxPrimitivesPerLeaf = 16;
    private int _maxElements = 25;
    private CollisionTreeController _treeRemover;

    private CollisionTreeManager() {
        this._cache = new WeakHashMap<Mesh, CollisionTree>();
        this._protectedList = Collections.synchronizedList(new ArrayList(1));
        this.setCollisionTreeController(new UsageTreeController());
    }

    public static CollisionTreeManager getInstance() {
        return INSTANCE;
    }

    private CollisionTree cacheGet(Mesh mesh) {
        return this._cache.get(mesh);
    }

    private void cacheRemove(Mesh mesh) {
        this._cache.remove(mesh);
    }

    private void cachePut(Mesh mesh, CollisionTree tree) {
        this._cache.put(mesh, tree);
    }

    public void setCollisionTreeController(CollisionTreeController treeRemover) {
        this._treeRemover = treeRemover;
    }

    public synchronized CollisionTree getCollisionTree(Mesh mesh) {
        CollisionTree toReturn = null;
        toReturn = this.cacheGet(mesh);
        if (toReturn == null) {
            if (this._generateTrees) {
                return this.generateCollisionTree(this._treeType, mesh, false);
            }
            return null;
        }
        this.cacheRemove(mesh);
        this.cachePut(mesh, toReturn);
        return toReturn;
    }

    public void generateCollisionTree(CollisionTree.Type type, Spatial object, boolean protect) {
        if (object instanceof Mesh) {
            this.generateCollisionTree(type, (Mesh)object, protect);
        }
        if (object instanceof Node && ((Node)object).getNumberOfChildren() > 0) {
            for (Spatial sp : ((Node)object).getChildren()) {
                this.generateCollisionTree(type, sp, protect);
            }
        }
    }

    public CollisionTree generateCollisionTree(CollisionTree.Type type, Mesh mesh, boolean protect) {
        if (mesh == null) {
            return null;
        }
        CollisionTree tree = new CollisionTree(type);
        this.generateCollisionTree(tree, mesh, protect);
        return tree;
    }

    protected void generateCollisionTree(CollisionTree tree, Mesh mesh, boolean protect) {
        tree.construct(mesh, this._doSort);
        this.cachePut(mesh, tree);
        if (protect) {
            this.setProtected(mesh);
        }
        if (this._cache.size() > this._maxElements && this._treeRemover != null) {
            this._treeRemover.clean(this._cache, this._protectedList, this._maxElements);
        }
    }

    public void removeCollisionTree(Mesh mesh) {
        this.cacheRemove(mesh);
        this.removeProtected(mesh);
    }

    public void removeCollisionTree(Spatial object) {
        if (object instanceof Node) {
            Node n = (Node)object;
            for (int i = n.getNumberOfChildren() - 1; i >= 0; --i) {
                this.removeCollisionTree(n.getChild(i));
            }
        } else if (object instanceof Mesh) {
            this.removeCollisionTree((Mesh)object);
        }
    }

    public void updateCollisionTree(Mesh mesh) {
        CollisionTree ct = this.cacheGet(mesh);
        if (ct != null) {
            this.generateCollisionTree(ct, mesh, this._protectedList != null && this._protectedList.contains(mesh));
        }
    }

    public void updateCollisionTree(Spatial object) {
        if (object instanceof Node) {
            Node n = (Node)object;
            for (int i = n.getNumberOfChildren() - 1; i >= 0; --i) {
                this.updateCollisionTree(n.getChild(i));
            }
        } else if (object instanceof Mesh) {
            this.updateCollisionTree((Mesh)object);
        }
    }

    public boolean isDoSort() {
        return this._doSort;
    }

    public void setDoSort(boolean doSort) {
        this._doSort = doSort;
    }

    public boolean isGenerateTrees() {
        return this._generateTrees;
    }

    public void setGenerateTrees(boolean generateTrees) {
        this._generateTrees = generateTrees;
    }

    public CollisionTree.Type getTreeType() {
        return this._treeType;
    }

    public void setTreeType(CollisionTree.Type treeType) {
        this._treeType = treeType;
    }

    public int getMaxPrimitivesPerLeaf() {
        return this._maxPrimitivesPerLeaf;
    }

    public void setMaxPrimitivesPerLeaf(int maxPrimitivesPerLeaf) {
        this._maxPrimitivesPerLeaf = maxPrimitivesPerLeaf;
    }

    public int getMaxElements() {
        return this._maxElements;
    }

    public void setMaxElements(int maxElements) {
        this._maxElements = maxElements;
    }

    public void setProtected(Mesh meshToProtect) {
        if (!this._protectedList.contains(meshToProtect)) {
            this._protectedList.add(meshToProtect);
        }
    }

    public void removeProtected(Mesh mesh) {
        this._protectedList.remove(mesh);
    }

    public List<Mesh> getProtectedMeshes() {
        return ImmutableList.copyOf(this._protectedList);
    }
}

