/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.bounding.BoundingBox;
import com.ardor3d.bounding.BoundingSphere;
import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Quaternion;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyQuaternion;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.MeshData;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Objects;

public class OrientedBoundingBox
extends BoundingVolume {
    private static final long serialVersionUID = 1L;
    protected final Vector3 _xAxis = new Vector3(1.0, 0.0, 0.0);
    protected final Vector3 _yAxis = new Vector3(0.0, 1.0, 0.0);
    protected final Vector3 _zAxis = new Vector3(0.0, 0.0, 1.0);
    protected final Vector3 _extent = new Vector3(0.0, 0.0, 0.0);
    protected final Vector3[] _vectorStore = new Vector3[8];
    public boolean correctCorners = false;
    protected final Vector3 _compVect3 = new Vector3();

    public OrientedBoundingBox() {
        for (int x = 0; x < 8; ++x) {
            this._vectorStore[x] = new Vector3();
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExtent(), Arrays.hashCode(this._vectorStore), this.getXAxis(), this.getYAxis(), this.getZAxis());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrientedBoundingBox other = (OrientedBoundingBox)obj;
        if (this._extent == null ? other._extent != null : !this._extent.equals((Object)other._extent)) {
            return false;
        }
        if (!Arrays.equals(this._vectorStore, other._vectorStore)) {
            return false;
        }
        if (this._xAxis == null ? other._xAxis != null : !this._xAxis.equals((Object)other._xAxis)) {
            return false;
        }
        if (this._yAxis == null ? other._yAxis != null : !this._yAxis.equals((Object)other._yAxis)) {
            return false;
        }
        if (this._zAxis == null ? other._zAxis != null : !this._zAxis.equals((Object)other._zAxis)) {
            return false;
        }
        return this.correctCorners == other.correctCorners;
    }

    @Override
    public BoundingVolume.Type getType() {
        return BoundingVolume.Type.OBB;
    }

    @Override
    public BoundingVolume transform(ReadOnlyTransform transform, BoundingVolume store) {
        if (store == null || store.getType() != BoundingVolume.Type.OBB) {
            store = new OrientedBoundingBox();
        }
        OrientedBoundingBox toReturn = (OrientedBoundingBox)store;
        Vector3 helper = new Vector3();
        helper.set(1.0, 0.0, 0.0);
        double scaleX = transform.applyForwardVector(helper).length();
        helper.set(0.0, 1.0, 0.0);
        double scaleY = transform.applyForwardVector(helper).length();
        helper.set(0.0, 0.0, 1.0);
        double scaleZ = transform.applyForwardVector(helper).length();
        toReturn._extent.set(Math.abs(this._extent.getX() * scaleX), Math.abs(this._extent.getY() * scaleY), Math.abs(this._extent.getZ() * scaleZ));
        transform.getMatrix().applyPost((ReadOnlyVector3)this._xAxis, toReturn._xAxis);
        transform.getMatrix().applyPost((ReadOnlyVector3)this._yAxis, toReturn._yAxis);
        transform.getMatrix().applyPost((ReadOnlyVector3)this._zAxis, toReturn._zAxis);
        if (!transform.isRotationMatrix()) {
            toReturn._xAxis.normalizeLocal();
            toReturn._yAxis.normalizeLocal();
            toReturn._zAxis.normalizeLocal();
        }
        transform.applyForward((ReadOnlyVector3)this._center, toReturn._center);
        toReturn.correctCorners = false;
        toReturn.computeCorners();
        return toReturn;
    }

    @Override
    public ReadOnlyPlane.Side whichSide(ReadOnlyPlane plane) {
        ReadOnlyVector3 planeNormal = plane.getNormal();
        double fRadius = Math.abs(this._extent.getX() * planeNormal.dot((ReadOnlyVector3)this._xAxis)) + Math.abs(this._extent.getY() * planeNormal.dot((ReadOnlyVector3)this._yAxis)) + Math.abs(this._extent.getZ() * planeNormal.dot((ReadOnlyVector3)this._zAxis));
        double fDistance = plane.pseudoDistance((ReadOnlyVector3)this._center);
        if (fDistance <= -fRadius) {
            return ReadOnlyPlane.Side.Inside;
        }
        if (fDistance >= fRadius) {
            return ReadOnlyPlane.Side.Outside;
        }
        return ReadOnlyPlane.Side.Neither;
    }

    @Override
    public void computeFromPoints(FloatBuffer points) {
        this.containAABB(points);
    }

    private void containAABB(FloatBuffer points) {
        if (points == null || points.limit() <= 2) {
            return;
        }
        BufferUtils.populateFromBuffer(this._compVect1, points, 0);
        double minX = this._compVect1.getX();
        double minY = this._compVect1.getY();
        double minZ = this._compVect1.getZ();
        double maxX = this._compVect1.getX();
        double maxY = this._compVect1.getY();
        double maxZ = this._compVect1.getZ();
        int len = points.limit() / 3;
        for (int i = 1; i < len; ++i) {
            BufferUtils.populateFromBuffer(this._compVect1, points, i);
            minX = Math.min(this._compVect1.getX(), minX);
            maxX = Math.max(this._compVect1.getX(), maxX);
            minY = Math.min(this._compVect1.getY(), minY);
            maxY = Math.max(this._compVect1.getY(), maxY);
            minZ = Math.min(this._compVect1.getZ(), minZ);
            maxZ = Math.max(this._compVect1.getZ(), maxZ);
        }
        this._center.set(minX + maxX, minY + maxY, minZ + maxZ);
        this._center.multiplyLocal(0.5);
        this._extent.set(maxX - this._center.getX(), maxY - this._center.getY(), maxZ - this._center.getZ());
        this._xAxis.set(1.0, 0.0, 0.0);
        this._yAxis.set(0.0, 1.0, 0.0);
        this._zAxis.set(0.0, 0.0, 1.0);
        this.correctCorners = false;
    }

    @Override
    public BoundingVolume merge(BoundingVolume volume) {
        return this.clone(new OrientedBoundingBox()).mergeLocal(volume);
    }

    @Override
    public BoundingVolume mergeLocal(BoundingVolume volume) {
        if (volume == null) {
            return this;
        }
        switch (volume.getType()) {
            case OBB: {
                return this.mergeOBB((OrientedBoundingBox)volume);
            }
            case AABB: {
                return this.mergeAABB((BoundingBox)volume);
            }
            case Sphere: {
                return this.mergeSphere((BoundingSphere)volume);
            }
        }
        return null;
    }

    @Override
    public BoundingVolume asType(BoundingVolume.Type newType) {
        if (newType == null) {
            return null;
        }
        switch (newType) {
            case AABB: {
                BoundingBox box = new BoundingBox((ReadOnlyVector3)this._center, 0.0, 0.0, 0.0);
                return box.merge(this);
            }
            case Sphere: {
                BoundingSphere sphere = new BoundingSphere(0.0, (ReadOnlyVector3)this._center);
                return sphere.merge(this);
            }
            case OBB: {
                return this.clone(null);
            }
        }
        return null;
    }

    private BoundingVolume mergeSphere(BoundingSphere volume) {
        if (Vector3.isInfinite((ReadOnlyVector3)this.getExtent()) || Double.isInfinite(volume.getRadius())) {
            this.setCenter(Vector3.ZERO);
            this._extent.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return this;
        }
        BoundingSphere mergeSphere = volume;
        if (!this.correctCorners) {
            this.computeCorners();
        }
        FloatBuffer mergeBuf = BufferUtils.createFloatBufferOnHeap(48);
        mergeBuf.rewind();
        for (int i = 0; i < 8; ++i) {
            mergeBuf.put((float)this._vectorStore[i].getX());
            mergeBuf.put((float)this._vectorStore[i].getY());
            mergeBuf.put((float)this._vectorStore[i].getZ());
        }
        mergeBuf.put((float)(mergeSphere._center.getX() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() + mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() + mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() + mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() - mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() + mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() - mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() + mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() - mergeSphere.getRadius()));
        mergeBuf.put((float)(mergeSphere._center.getX() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getY() - mergeSphere.getRadius())).put((float)(mergeSphere._center.getZ() - mergeSphere.getRadius()));
        this.containAABB(mergeBuf);
        this.correctCorners = false;
        return this;
    }

    private BoundingVolume mergeAABB(BoundingBox volume) {
        if (Vector3.isInfinite((ReadOnlyVector3)this.getExtent()) || Double.isInfinite(volume.getXExtent()) || Double.isInfinite(volume.getYExtent()) || Double.isInfinite(volume.getZExtent())) {
            this.setCenter(Vector3.ZERO);
            this._extent.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return this;
        }
        BoundingBox mergeBox = volume;
        if (!this.correctCorners) {
            this.computeCorners();
        }
        FloatBuffer mergeBuf = BufferUtils.createFloatBufferOnHeap(48);
        mergeBuf.rewind();
        for (int i = 0; i < 8; ++i) {
            mergeBuf.put((float)this._vectorStore[i].getX());
            mergeBuf.put((float)this._vectorStore[i].getY());
            mergeBuf.put((float)this._vectorStore[i].getZ());
        }
        mergeBuf.put((float)(mergeBox._center.getX() + mergeBox.getXExtent())).put((float)(mergeBox._center.getY() + mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() + mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() - mergeBox.getXExtent())).put((float)(mergeBox._center.getY() + mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() + mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() + mergeBox.getXExtent())).put((float)(mergeBox._center.getY() - mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() + mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() + mergeBox.getXExtent())).put((float)(mergeBox._center.getY() + mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() - mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() - mergeBox.getXExtent())).put((float)(mergeBox._center.getY() - mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() + mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() - mergeBox.getXExtent())).put((float)(mergeBox._center.getY() + mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() - mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() + mergeBox.getXExtent())).put((float)(mergeBox._center.getY() - mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() - mergeBox.getZExtent()));
        mergeBuf.put((float)(mergeBox._center.getX() - mergeBox.getXExtent())).put((float)(mergeBox._center.getY() - mergeBox.getYExtent())).put((float)(mergeBox._center.getZ() - mergeBox.getZExtent()));
        this.containAABB(mergeBuf);
        this.correctCorners = false;
        return this;
    }

    private BoundingVolume mergeOBB(OrientedBoundingBox volume) {
        double fDot;
        int i;
        if (Vector3.isInfinite((ReadOnlyVector3)this.getExtent()) || Vector3.isInfinite((ReadOnlyVector3)volume.getExtent())) {
            this.setCenter(Vector3.ZERO);
            this._extent.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            return this;
        }
        OrientedBoundingBox rkBox0 = this;
        OrientedBoundingBox rkBox1 = volume;
        Vector3 kBoxCenter = rkBox0._center.add((ReadOnlyVector3)rkBox1._center, Vector3.fetchTempInstance()).multiplyLocal(0.5);
        Quaternion kQ0 = Quaternion.fetchTempInstance();
        Quaternion kQ1 = Quaternion.fetchTempInstance();
        kQ0.fromAxes((ReadOnlyVector3)rkBox0._xAxis, (ReadOnlyVector3)rkBox0._yAxis, (ReadOnlyVector3)rkBox0._zAxis);
        kQ1.fromAxes((ReadOnlyVector3)rkBox1._xAxis, (ReadOnlyVector3)rkBox1._yAxis, (ReadOnlyVector3)rkBox1._zAxis);
        if (kQ0.dot((ReadOnlyQuaternion)kQ1) < 0.0) {
            kQ1.multiplyLocal(-1.0);
        }
        Quaternion kQ = kQ0.addLocal((ReadOnlyQuaternion)kQ1);
        kQ.normalizeLocal();
        Matrix3 kBoxaxis = kQ.toRotationMatrix(Matrix3.fetchTempInstance());
        Vector3 newXaxis = kBoxaxis.getColumn(0, Vector3.fetchTempInstance());
        Vector3 newYaxis = kBoxaxis.getColumn(1, Vector3.fetchTempInstance());
        Vector3 newZaxis = kBoxaxis.getColumn(2, Vector3.fetchTempInstance());
        Vector3 kDiff = Vector3.fetchTempInstance();
        Vector3 kMin = Vector3.fetchTempInstance();
        Vector3 kMax = Vector3.fetchTempInstance();
        if (!rkBox0.correctCorners) {
            rkBox0.computeCorners();
        }
        for (i = 0; i < 8; ++i) {
            rkBox0._vectorStore[i].subtract((ReadOnlyVector3)kBoxCenter, kDiff);
            fDot = kDiff.dot((ReadOnlyVector3)newXaxis);
            if (fDot > kMax.getX()) {
                kMax.setX(fDot);
            } else if (fDot < kMin.getX()) {
                kMin.setX(fDot);
            }
            fDot = kDiff.dot((ReadOnlyVector3)newYaxis);
            if (fDot > kMax.getY()) {
                kMax.setY(fDot);
            } else if (fDot < kMin.getY()) {
                kMin.setY(fDot);
            }
            fDot = kDiff.dot((ReadOnlyVector3)newZaxis);
            if (fDot > kMax.getZ()) {
                kMax.setZ(fDot);
                continue;
            }
            if (!(fDot < kMin.getZ())) continue;
            kMin.setZ(fDot);
        }
        if (!rkBox1.correctCorners) {
            rkBox1.computeCorners();
        }
        for (i = 0; i < 8; ++i) {
            rkBox1._vectorStore[i].subtract((ReadOnlyVector3)kBoxCenter, kDiff);
            fDot = kDiff.dot((ReadOnlyVector3)newXaxis);
            if (fDot > kMax.getX()) {
                kMax.setX(fDot);
            } else if (fDot < kMin.getX()) {
                kMin.setX(fDot);
            }
            fDot = kDiff.dot((ReadOnlyVector3)newYaxis);
            if (fDot > kMax.getY()) {
                kMax.setY(fDot);
            } else if (fDot < kMin.getY()) {
                kMin.setY(fDot);
            }
            fDot = kDiff.dot((ReadOnlyVector3)newZaxis);
            if (fDot > kMax.getZ()) {
                kMax.setZ(fDot);
                continue;
            }
            if (!(fDot < kMin.getZ())) continue;
            kMin.setZ(fDot);
        }
        this._xAxis.set((ReadOnlyVector3)newXaxis);
        this._yAxis.set((ReadOnlyVector3)newYaxis);
        this._zAxis.set((ReadOnlyVector3)newZaxis);
        Vector3 tempVec = Vector3.fetchTempInstance();
        this._extent.setX(0.5 * (kMax.getX() - kMin.getX()));
        kBoxCenter.addLocal((ReadOnlyVector3)this._xAxis.multiply(0.5 * (kMax.getX() + kMin.getX()), tempVec));
        this._extent.setY(0.5 * (kMax.getY() - kMin.getY()));
        kBoxCenter.addLocal((ReadOnlyVector3)this._yAxis.multiply(0.5 * (kMax.getY() + kMin.getY()), tempVec));
        this._extent.setZ(0.5 * (kMax.getZ() - kMin.getZ()));
        kBoxCenter.addLocal((ReadOnlyVector3)this._zAxis.multiply(0.5 * (kMax.getZ() + kMin.getZ()), tempVec));
        this._center.set((ReadOnlyVector3)kBoxCenter);
        this.correctCorners = false;
        Quaternion.releaseTempInstance((Quaternion)kQ0);
        Quaternion.releaseTempInstance((Quaternion)kQ1);
        Matrix3.releaseTempInstance((Matrix3)kBoxaxis);
        Vector3.releaseTempInstance((Vector3)kBoxCenter);
        Vector3.releaseTempInstance((Vector3)newXaxis);
        Vector3.releaseTempInstance((Vector3)newYaxis);
        Vector3.releaseTempInstance((Vector3)newZaxis);
        Vector3.releaseTempInstance((Vector3)kDiff);
        Vector3.releaseTempInstance((Vector3)kMin);
        Vector3.releaseTempInstance((Vector3)kMax);
        Vector3.releaseTempInstance((Vector3)tempVec);
        return this;
    }

    @Override
    public BoundingVolume clone(BoundingVolume store) {
        OrientedBoundingBox toReturn = store instanceof OrientedBoundingBox ? (OrientedBoundingBox)store : new OrientedBoundingBox();
        toReturn._extent.set((ReadOnlyVector3)this._extent);
        toReturn._xAxis.set((ReadOnlyVector3)this._xAxis);
        toReturn._yAxis.set((ReadOnlyVector3)this._yAxis);
        toReturn._zAxis.set((ReadOnlyVector3)this._zAxis);
        toReturn._center.set((ReadOnlyVector3)this._center);
        toReturn._checkPlane = this._checkPlane;
        int x = this._vectorStore.length;
        while (--x >= 0) {
            toReturn._vectorStore[x].set((ReadOnlyVector3)this._vectorStore[x]);
        }
        toReturn.correctCorners = this.correctCorners;
        return toReturn;
    }

    @Override
    public double getRadius() {
        double radius = 0.0;
        radius = Math.max(radius, this._xAxis.multiply(this._extent.getX(), this._compVect1).length());
        radius = Math.max(radius, this._yAxis.multiply(this._extent.getY(), this._compVect1).length());
        radius = Math.max(radius, this._zAxis.multiply(this._extent.getZ(), this._compVect1).length());
        return radius;
    }

    public void computeCorners() {
        Vector3 tempAxis0 = this._xAxis.multiply(this._extent.getX(), this._compVect1);
        Vector3 tempAxis1 = this._yAxis.multiply(this._extent.getY(), this._compVect2);
        Vector3 tempAxis2 = this._zAxis.multiply(this._extent.getZ(), this._compVect3);
        this._vectorStore[0].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempAxis0).subtractLocal((ReadOnlyVector3)tempAxis1).subtractLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[1].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempAxis0).subtractLocal((ReadOnlyVector3)tempAxis1).subtractLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[2].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempAxis0).addLocal((ReadOnlyVector3)tempAxis1).subtractLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[3].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempAxis0).addLocal((ReadOnlyVector3)tempAxis1).subtractLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[4].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempAxis0).subtractLocal((ReadOnlyVector3)tempAxis1).addLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[5].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempAxis0).subtractLocal((ReadOnlyVector3)tempAxis1).addLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[6].set((ReadOnlyVector3)this._center).addLocal((ReadOnlyVector3)tempAxis0).addLocal((ReadOnlyVector3)tempAxis1).addLocal((ReadOnlyVector3)tempAxis2);
        this._vectorStore[7].set((ReadOnlyVector3)this._center).subtractLocal((ReadOnlyVector3)tempAxis0).addLocal((ReadOnlyVector3)tempAxis1).addLocal((ReadOnlyVector3)tempAxis2);
        this.correctCorners = true;
    }

    @Override
    public void computeFromPrimitives(MeshData data, int section, int[] indices, int start, int end) {
        if (end - start <= 0) {
            return;
        }
        int vertsPerPrimitive = data.getIndexMode(section).getVertexCount();
        Vector3[] store = new Vector3[vertsPerPrimitive];
        Vector3 min = this._compVect1.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        Vector3 max = this._compVect2.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (int i = start; i < end; ++i) {
            store = data.getPrimitiveVertices(indices[i], section, store);
            for (int j = 0; j < vertsPerPrimitive; ++j) {
                Vector3 point = store[j];
                if (point.getX() < min.getX()) {
                    min.setX(point.getX());
                } else if (point.getX() > max.getX()) {
                    max.setX(point.getX());
                }
                if (point.getY() < min.getY()) {
                    min.setY(point.getY());
                } else if (point.getY() > max.getY()) {
                    max.setY(point.getY());
                }
                if (point.getZ() < min.getZ()) {
                    min.setZ(point.getZ());
                    continue;
                }
                if (!(point.getZ() > max.getZ())) continue;
                max.setZ(point.getZ());
            }
        }
        this._center.set((ReadOnlyVector3)min.addLocal((ReadOnlyVector3)max));
        this._center.multiplyLocal(0.5);
        this._extent.set(max.getX() - this._center.getX(), max.getY() - this._center.getY(), max.getZ() - this._center.getZ());
        this._xAxis.set(1.0, 0.0, 0.0);
        this._yAxis.set(0.0, 1.0, 0.0);
        this._zAxis.set(0.0, 0.0, 1.0);
        this.correctCorners = false;
    }

    public boolean intersection(OrientedBoundingBox box1) {
        double fR0;
        int i;
        OrientedBoundingBox box0 = this;
        double cutoff = 0.999999;
        boolean parallelPairExists = false;
        ReadOnlyVector3[] akA = new ReadOnlyVector3[]{box0.getXAxis(), box0.getYAxis(), box0.getZAxis()};
        ReadOnlyVector3[] akB = new ReadOnlyVector3[]{box1.getXAxis(), box1.getYAxis(), box1.getZAxis()};
        Vector3 afEA = box0._extent;
        Vector3 afEB = box1._extent;
        Vector3 kD = box1._center.subtract((ReadOnlyVector3)box0._center, this._compVect1);
        double[][] aafC = new double[][]{new double[3], new double[3], new double[3]};
        double[][] aafAbsC = new double[][]{new double[3], new double[3], new double[3]};
        double[] afAD = new double[3];
        for (i = 0; i < 3; ++i) {
            aafC[0][i] = akA[0].dot(akB[i]);
            aafAbsC[0][i] = Math.abs(aafC[0][i]);
            if (!(aafAbsC[0][i] > 0.999999)) continue;
            parallelPairExists = true;
        }
        afAD[0] = akA[0].dot((ReadOnlyVector3)kD);
        double fR = Math.abs(afAD[0]);
        double fR1 = afEB.getX() * aafAbsC[0][0] + afEB.getY() * aafAbsC[0][1] + afEB.getZ() * aafAbsC[0][2];
        double fR01 = afEA.getX() + fR1;
        if (fR > fR01) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            aafC[1][i] = akA[1].dot(akB[i]);
            aafAbsC[1][i] = Math.abs(aafC[1][i]);
            if (!(aafAbsC[1][i] > 0.999999)) continue;
            parallelPairExists = true;
        }
        afAD[1] = akA[1].dot((ReadOnlyVector3)kD);
        fR = Math.abs(afAD[1]);
        fR1 = afEB.getX() * aafAbsC[1][0] + afEB.getY() * aafAbsC[1][1] + afEB.getZ() * aafAbsC[1][2];
        fR01 = afEA.getY() + fR1;
        if (fR > fR01) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            aafC[2][i] = akA[2].dot(akB[i]);
            aafAbsC[2][i] = Math.abs(aafC[2][i]);
            if (!(aafAbsC[2][i] > 0.999999)) continue;
            parallelPairExists = true;
        }
        afAD[2] = akA[2].dot((ReadOnlyVector3)kD);
        fR = Math.abs(afAD[2]);
        fR1 = afEB.getX() * aafAbsC[2][0] + afEB.getY() * aafAbsC[2][1] + afEB.getZ() * aafAbsC[2][2];
        fR01 = afEA.getZ() + fR1;
        if (fR > fR01) {
            return false;
        }
        fR = Math.abs(akB[0].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][0] + afEA.getY() * aafAbsC[1][0] + afEA.getZ() * aafAbsC[2][0]) + afEB.getX())) {
            return false;
        }
        fR = Math.abs(akB[1].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][1] + afEA.getY() * aafAbsC[1][1] + afEA.getZ() * aafAbsC[2][1]) + afEB.getY())) {
            return false;
        }
        fR = Math.abs(akB[2].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][2] + afEA.getY() * aafAbsC[1][2] + afEA.getZ() * aafAbsC[2][2]) + afEB.getZ())) {
            return false;
        }
        if (parallelPairExists) {
            return true;
        }
        fR = Math.abs(afAD[2] * aafC[1][0] - afAD[1] * aafC[2][0]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[1][0]) + (fR1 = afEB.getY() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][1]))) {
            return false;
        }
        fR = Math.abs(afAD[2] * aafC[1][1] - afAD[1] * aafC[2][1]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[1][1]) + (fR1 = afEB.getX() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][0]))) {
            return false;
        }
        fR = Math.abs(afAD[2] * aafC[1][2] - afAD[1] * aafC[2][2]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[1][2]) + (fR1 = afEB.getX() * aafAbsC[0][1] + afEB.getY() * aafAbsC[0][0]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][0] - afAD[2] * aafC[0][0]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][1]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][1] - afAD[2] * aafC[0][1]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][0]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][2] - afAD[2] * aafC[0][2]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[1][1] + afEB.getY() * aafAbsC[1][0]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][0] - afAD[0] * aafC[1][0]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][0] + afEA.getY() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][1]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][1] - afAD[0] * aafC[1][1]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][1] + afEA.getY() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][0]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][2] - afAD[0] * aafC[1][2]);
        return !(fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][2] + afEA.getY() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[2][1] + afEB.getY() * aafAbsC[2][0])));
    }

    @Override
    public boolean intersects(BoundingVolume bv) {
        if (bv == null) {
            return false;
        }
        return bv.intersectsOrientedBoundingBox(this);
    }

    @Override
    public boolean intersectsSphere(BoundingSphere bs) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bs._center)) {
            return false;
        }
        this._compVect1.set(bs.getCenter()).subtractLocal((ReadOnlyVector3)this._center);
        Matrix3 tempMa = Matrix3.fetchTempInstance().fromAxes((ReadOnlyVector3)this._xAxis, (ReadOnlyVector3)this._yAxis, (ReadOnlyVector3)this._zAxis);
        tempMa.applyPost((ReadOnlyVector3)this._compVect1, this._compVect1);
        boolean result = false;
        if (Math.abs(this._compVect1.getX()) < bs.getRadius() + this._extent.getX() && Math.abs(this._compVect1.getY()) < bs.getRadius() + this._extent.getY() && Math.abs(this._compVect1.getZ()) < bs.getRadius() + this._extent.getZ()) {
            result = true;
        }
        Matrix3.releaseTempInstance((Matrix3)tempMa);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean intersectsBoundingBox(BoundingBox bb) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)bb._center)) {
            return false;
        }
        double cutoff = 0.999999f;
        boolean parallelPairExists = false;
        Vector3[] akA = new Vector3[]{this._xAxis, this._yAxis, this._zAxis};
        Vector3[] akB = new Vector3[]{Vector3.fetchTempInstance(), Vector3.fetchTempInstance(), Vector3.fetchTempInstance()};
        Vector3 afEA = this._extent;
        Vector3 afEB = Vector3.fetchTempInstance().set(bb.getXExtent(), bb.getYExtent(), bb.getZExtent());
        Vector3 kD = bb.getCenter().subtract((ReadOnlyVector3)this._center, Vector3.fetchTempInstance());
        double[][] aafC = new double[][]{new double[3], new double[3], new double[3]};
        double[][] aafAbsC = new double[][]{new double[3], new double[3], new double[3]};
        double[] afAD = new double[3];
        try {
            double fR0;
            int i;
            for (i = 0; i < 3; ++i) {
                aafC[0][i] = akA[0].dot((ReadOnlyVector3)akB[i]);
                aafAbsC[0][i] = Math.abs(aafC[0][i]);
                if (!(aafAbsC[0][i] > (double)0.999999f)) continue;
                parallelPairExists = true;
            }
            afAD[0] = akA[0].dot((ReadOnlyVector3)kD);
            double fR = Math.abs(afAD[0]);
            double fR1 = afEB.getX() * aafAbsC[0][0] + afEB.getY() * aafAbsC[0][1] + afEB.getZ() * aafAbsC[0][2];
            double fR01 = afEA.getX() + fR1;
            if (fR > fR01) {
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < 3; ++i) {
                aafC[1][i] = akA[1].dot((ReadOnlyVector3)akB[i]);
                aafAbsC[1][i] = Math.abs(aafC[1][i]);
                if (!(aafAbsC[1][i] > (double)0.999999f)) continue;
                parallelPairExists = true;
            }
            afAD[1] = akA[1].dot((ReadOnlyVector3)kD);
            fR = Math.abs(afAD[1]);
            fR1 = afEB.getX() * aafAbsC[1][0] + afEB.getY() * aafAbsC[1][1] + afEB.getZ() * aafAbsC[1][2];
            fR01 = afEA.getY() + fR1;
            if (fR > fR01) {
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < 3; ++i) {
                aafC[2][i] = akA[2].dot((ReadOnlyVector3)akB[i]);
                aafAbsC[2][i] = Math.abs(aafC[2][i]);
                if (!(aafAbsC[2][i] > (double)0.999999f)) continue;
                parallelPairExists = true;
            }
            afAD[2] = akA[2].dot((ReadOnlyVector3)kD);
            fR = Math.abs(afAD[2]);
            fR1 = afEB.getX() * aafAbsC[2][0] + afEB.getY() * aafAbsC[2][1] + afEB.getZ() * aafAbsC[2][2];
            fR01 = afEA.getZ() + fR1;
            if (fR > fR01) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(akB[0].dot((ReadOnlyVector3)kD));
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][0] + afEA.getY() * aafAbsC[1][0] + afEA.getZ() * aafAbsC[2][0]) + afEB.getX())) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(akB[1].dot((ReadOnlyVector3)kD));
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][1] + afEA.getY() * aafAbsC[1][1] + afEA.getZ() * aafAbsC[2][1]) + afEB.getY())) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(akB[2].dot((ReadOnlyVector3)kD));
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][2] + afEA.getY() * aafAbsC[1][2] + afEA.getZ() * aafAbsC[2][2]) + afEB.getZ())) {
                boolean bl = false;
                return bl;
            }
            if (parallelPairExists) {
                boolean bl = true;
                return bl;
            }
            fR = Math.abs(afAD[2] * aafC[1][0] - afAD[1] * aafC[2][0]);
            if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[1][0]) + (fR1 = afEB.getY() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][1]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[2] * aafC[1][1] - afAD[1] * aafC[2][1]);
            if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[1][1]) + (fR1 = afEB.getX() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][0]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[2] * aafC[1][2] - afAD[1] * aafC[2][2]);
            if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[1][2]) + (fR1 = afEB.getX() * aafAbsC[0][1] + afEB.getY() * aafAbsC[0][0]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[0] * aafC[2][0] - afAD[2] * aafC[0][0]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][1]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[0] * aafC[2][1] - afAD[2] * aafC[0][1]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][0]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[0] * aafC[2][2] - afAD[2] * aafC[0][2]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[1][1] + afEB.getY() * aafAbsC[1][0]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[1] * aafC[0][0] - afAD[0] * aafC[1][0]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][0] + afEA.getY() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][1]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[1] * aafC[0][1] - afAD[0] * aafC[1][1]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][1] + afEA.getY() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][0]))) {
                boolean bl = false;
                return bl;
            }
            fR = Math.abs(afAD[1] * aafC[0][2] - afAD[0] * aafC[1][2]);
            if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][2] + afEA.getY() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[2][1] + afEB.getY() * aafAbsC[2][0]))) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Vector3.releaseTempInstance((Vector3)kD);
            Vector3.releaseTempInstance((Vector3)afEB);
            for (Vector3 vec : akB) {
                Vector3.releaseTempInstance((Vector3)vec);
            }
        }
    }

    @Override
    public boolean intersectsOrientedBoundingBox(OrientedBoundingBox obb) {
        double fR0;
        int i;
        if (!Vector3.isValid((ReadOnlyVector3)this._center) || !Vector3.isValid((ReadOnlyVector3)obb._center)) {
            return false;
        }
        double cutoff = 0.999999f;
        boolean parallelPairExists = false;
        Vector3[] akA = new Vector3[]{this._xAxis, this._yAxis, this._zAxis};
        Vector3[] akB = new Vector3[]{obb._xAxis, obb._yAxis, obb._zAxis};
        Vector3 afEA = this._extent;
        Vector3 afEB = obb._extent;
        Vector3 kD = obb._center.subtract((ReadOnlyVector3)this._center, this._compVect1);
        double[][] aafC = new double[][]{new double[3], new double[3], new double[3]};
        double[][] aafAbsC = new double[][]{new double[3], new double[3], new double[3]};
        double[] afAD = new double[3];
        for (i = 0; i < 3; ++i) {
            aafC[0][i] = akA[0].dot((ReadOnlyVector3)akB[i]);
            aafAbsC[0][i] = Math.abs(aafC[0][i]);
            if (!(aafAbsC[0][i] > (double)0.999999f)) continue;
            parallelPairExists = true;
        }
        afAD[0] = akA[0].dot((ReadOnlyVector3)kD);
        double fR = Math.abs(afAD[0]);
        double fR1 = afEB.getX() * aafAbsC[0][0] + afEB.getY() * aafAbsC[0][1] + afEB.getZ() * aafAbsC[0][2];
        double fR01 = afEA.getX() + fR1;
        if (fR > fR01) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            aafC[1][i] = akA[1].dot((ReadOnlyVector3)akB[i]);
            aafAbsC[1][i] = Math.abs(aafC[1][i]);
            if (!(aafAbsC[1][i] > (double)0.999999f)) continue;
            parallelPairExists = true;
        }
        afAD[1] = akA[1].dot((ReadOnlyVector3)kD);
        fR = Math.abs(afAD[1]);
        fR1 = afEB.getX() * aafAbsC[1][0] + afEB.getY() * aafAbsC[1][1] + afEB.getZ() * aafAbsC[1][2];
        fR01 = afEA.getY() + fR1;
        if (fR > fR01) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            aafC[2][i] = akA[2].dot((ReadOnlyVector3)akB[i]);
            aafAbsC[2][i] = Math.abs(aafC[2][i]);
            if (!(aafAbsC[2][i] > (double)0.999999f)) continue;
            parallelPairExists = true;
        }
        afAD[2] = akA[2].dot((ReadOnlyVector3)kD);
        fR = Math.abs(afAD[2]);
        fR1 = afEB.getX() * aafAbsC[2][0] + afEB.getY() * aafAbsC[2][1] + afEB.getZ() * aafAbsC[2][2];
        fR01 = afEA.getZ() + fR1;
        if (fR > fR01) {
            return false;
        }
        fR = Math.abs(akB[0].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][0] + afEA.getY() * aafAbsC[1][0] + afEA.getZ() * aafAbsC[2][0]) + afEB.getX())) {
            return false;
        }
        fR = Math.abs(akB[1].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][1] + afEA.getY() * aafAbsC[1][1] + afEA.getZ() * aafAbsC[2][1]) + afEB.getY())) {
            return false;
        }
        fR = Math.abs(akB[2].dot((ReadOnlyVector3)kD));
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[0][2] + afEA.getY() * aafAbsC[1][2] + afEA.getZ() * aafAbsC[2][2]) + afEB.getZ())) {
            return false;
        }
        if (parallelPairExists) {
            return true;
        }
        fR = Math.abs(afAD[2] * aafC[1][0] - afAD[1] * aafC[2][0]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[1][0]) + (fR1 = afEB.getY() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][1]))) {
            return false;
        }
        fR = Math.abs(afAD[2] * aafC[1][1] - afAD[1] * aafC[2][1]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[1][1]) + (fR1 = afEB.getX() * aafAbsC[0][2] + afEB.getZ() * aafAbsC[0][0]))) {
            return false;
        }
        fR = Math.abs(afAD[2] * aafC[1][2] - afAD[1] * aafC[2][2]);
        if (fR > (fR01 = (fR0 = afEA.getY() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[1][2]) + (fR1 = afEB.getX() * aafAbsC[0][1] + afEB.getY() * aafAbsC[0][0]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][0] - afAD[2] * aafC[0][0]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][0] + afEA.getZ() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][1]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][1] - afAD[2] * aafC[0][1]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][1] + afEA.getZ() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[1][2] + afEB.getZ() * aafAbsC[1][0]))) {
            return false;
        }
        fR = Math.abs(afAD[0] * aafC[2][2] - afAD[2] * aafC[0][2]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[2][2] + afEA.getZ() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[1][1] + afEB.getY() * aafAbsC[1][0]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][0] - afAD[0] * aafC[1][0]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][0] + afEA.getY() * aafAbsC[0][0]) + (fR1 = afEB.getY() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][1]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][1] - afAD[0] * aafC[1][1]);
        if (fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][1] + afEA.getY() * aafAbsC[0][1]) + (fR1 = afEB.getX() * aafAbsC[2][2] + afEB.getZ() * aafAbsC[2][0]))) {
            return false;
        }
        fR = Math.abs(afAD[1] * aafC[0][2] - afAD[0] * aafC[1][2]);
        return !(fR > (fR01 = (fR0 = afEA.getX() * aafAbsC[1][2] + afEA.getY() * aafAbsC[0][2]) + (fR1 = afEB.getX() * aafAbsC[2][1] + afEB.getY() * aafAbsC[2][0])));
    }

    @Override
    public boolean intersects(ReadOnlyRay3 ray) {
        if (!Vector3.isValid((ReadOnlyVector3)this._center)) {
            return false;
        }
        ReadOnlyVector3 rayDir = ray.getDirection();
        Vector3 diff = this._compVect1.set(ray.getOrigin()).subtractLocal((ReadOnlyVector3)this._center);
        Vector3 wCrossD = this._compVect2;
        double[] fWdU = new double[3];
        double[] fAWdU = new double[3];
        double[] fDdU = new double[3];
        double[] fADdU = new double[3];
        double[] fAWxDdU = new double[3];
        fWdU[0] = rayDir.dot((ReadOnlyVector3)this._xAxis);
        fAWdU[0] = Math.abs(fWdU[0]);
        fDdU[0] = diff.dot((ReadOnlyVector3)this._xAxis);
        fADdU[0] = Math.abs(fDdU[0]);
        if (fADdU[0] > this._extent.getX() && fDdU[0] * fWdU[0] >= 0.0) {
            return false;
        }
        fWdU[1] = rayDir.dot((ReadOnlyVector3)this._yAxis);
        fAWdU[1] = Math.abs(fWdU[1]);
        fDdU[1] = diff.dot((ReadOnlyVector3)this._yAxis);
        fADdU[1] = Math.abs(fDdU[1]);
        if (fADdU[1] > this._extent.getY() && fDdU[1] * fWdU[1] >= 0.0) {
            return false;
        }
        fWdU[2] = rayDir.dot((ReadOnlyVector3)this._zAxis);
        fAWdU[2] = Math.abs(fWdU[2]);
        fDdU[2] = diff.dot((ReadOnlyVector3)this._zAxis);
        fADdU[2] = Math.abs(fDdU[2]);
        if (fADdU[2] > this._extent.getZ() && fDdU[2] * fWdU[2] >= 0.0) {
            return false;
        }
        rayDir.cross((ReadOnlyVector3)diff, wCrossD);
        fAWxDdU[0] = Math.abs(wCrossD.dot((ReadOnlyVector3)this._xAxis));
        double rhs = this._extent.getY() * fAWdU[2] + this._extent.getZ() * fAWdU[1];
        if (fAWxDdU[0] > rhs) {
            return false;
        }
        fAWxDdU[1] = Math.abs(wCrossD.dot((ReadOnlyVector3)this._yAxis));
        rhs = this._extent.getX() * fAWdU[2] + this._extent.getZ() * fAWdU[0];
        if (fAWxDdU[1] > rhs) {
            return false;
        }
        fAWxDdU[2] = Math.abs(wCrossD.dot((ReadOnlyVector3)this._zAxis));
        rhs = this._extent.getX() * fAWdU[1] + this._extent.getY() * fAWdU[0];
        return !(fAWxDdU[2] > rhs);
    }

    @Override
    public IntersectionRecord intersectsWhere(ReadOnlyRay3 ray) {
        boolean notEntirelyClipped;
        ReadOnlyVector3 rayDir = ray.getDirection();
        ReadOnlyVector3 rayOrigin = ray.getOrigin();
        Vector3 diff = rayOrigin.subtract(this.getCenter(), this._compVect1);
        diff.set(this._xAxis.dot((ReadOnlyVector3)diff), this._yAxis.dot((ReadOnlyVector3)diff), this._zAxis.dot((ReadOnlyVector3)diff));
        Vector3 direction = this._compVect2.set(this._xAxis.dot(rayDir), this._yAxis.dot(rayDir), this._zAxis.dot(rayDir));
        double[] t = new double[]{0.0, Double.POSITIVE_INFINITY};
        double saveT0 = t[0];
        double saveT1 = t[1];
        boolean bl = notEntirelyClipped = this.clip(direction.getX(), -diff.getX() - this._extent.getX(), t) && this.clip(-direction.getX(), diff.getX() - this._extent.getX(), t) && this.clip(direction.getY(), -diff.getY() - this._extent.getY(), t) && this.clip(-direction.getY(), diff.getY() - this._extent.getY(), t) && this.clip(direction.getZ(), -diff.getZ() - this._extent.getZ(), t) && this.clip(-direction.getZ(), diff.getZ() - this._extent.getZ(), t);
        if (notEntirelyClipped && (t[0] != saveT0 || t[1] != saveT1)) {
            if (t[1] > t[0]) {
                double[] distances = t;
                Vector3[] points = new Vector3[]{rayDir.multiply(distances[0], new Vector3()).addLocal(rayOrigin), rayDir.multiply(distances[1], new Vector3()).addLocal(rayOrigin)};
                IntersectionRecord record = new IntersectionRecord(distances, points);
                return record;
            }
            double[] distances = new double[]{t[0]};
            Vector3[] points = new Vector3[]{rayDir.multiply(distances[0], new Vector3()).addLocal(rayOrigin)};
            IntersectionRecord record = new IntersectionRecord(distances, points);
            return record;
        }
        return null;
    }

    private boolean clip(double denom, double numer, double[] t) {
        if (denom > 0.0) {
            if (numer > denom * t[1]) {
                return false;
            }
            if (numer > denom * t[0]) {
                t[0] = numer / denom;
            }
            return true;
        }
        if (denom < 0.0) {
            if (numer > denom * t[0]) {
                return false;
            }
            if (numer > denom * t[1]) {
                t[1] = numer / denom;
            }
            return true;
        }
        return numer <= 0.0;
    }

    public void setXAxis(ReadOnlyVector3 axis) {
        this._xAxis.set(axis);
        this.correctCorners = false;
    }

    public void setYAxis(ReadOnlyVector3 axis) {
        this._yAxis.set(axis);
        this.correctCorners = false;
    }

    public void setZAxis(ReadOnlyVector3 axis) {
        this._zAxis.set(axis);
        this.correctCorners = false;
    }

    public void setExtent(ReadOnlyVector3 ext) {
        this._extent.set(ext);
        this.correctCorners = false;
    }

    public ReadOnlyVector3 getXAxis() {
        return this._xAxis;
    }

    public ReadOnlyVector3 getYAxis() {
        return this._yAxis;
    }

    public ReadOnlyVector3 getZAxis() {
        return this._zAxis;
    }

    public ReadOnlyVector3 getExtent() {
        return this._extent;
    }

    @Override
    public boolean contains(ReadOnlyVector3 point) {
        this._compVect1.set(point).subtractLocal((ReadOnlyVector3)this._center);
        double coeff = this._compVect1.dot((ReadOnlyVector3)this._xAxis);
        if (Math.abs(coeff) > this._extent.getX()) {
            return false;
        }
        coeff = this._compVect1.dot((ReadOnlyVector3)this._yAxis);
        if (Math.abs(coeff) > this._extent.getY()) {
            return false;
        }
        coeff = this._compVect1.dot((ReadOnlyVector3)this._zAxis);
        return !(Math.abs(coeff) > this._extent.getZ());
    }

    @Override
    public double distanceToEdge(ReadOnlyVector3 point) {
        double delta;
        Vector3 diff = point.subtract((ReadOnlyVector3)this._center, this._compVect1);
        Vector3 closest = this._compVect2.set(diff.dot((ReadOnlyVector3)this._xAxis), diff.dot((ReadOnlyVector3)this._yAxis), diff.dot((ReadOnlyVector3)this._zAxis));
        double sqrDistance = 0.0;
        if (closest.getX() < -this._extent.getX()) {
            delta = closest.getX() + this._extent.getX();
            sqrDistance += delta * delta;
            closest.setX(-this._extent.getX());
        } else if (closest.getX() > this._extent.getX()) {
            delta = closest.getX() - this._extent.getX();
            sqrDistance += delta * delta;
            closest.setX(this._extent.getX());
        }
        if (closest.getY() < -this._extent.getY()) {
            delta = closest.getY() + this._extent.getY();
            sqrDistance += delta * delta;
            closest.setY(-this._extent.getY());
        } else if (closest.getY() > this._extent.getY()) {
            delta = closest.getY() - this._extent.getY();
            sqrDistance += delta * delta;
            closest.setY(this._extent.getY());
        }
        if (closest.getZ() < -this._extent.getZ()) {
            delta = closest.getZ() + this._extent.getZ();
            sqrDistance += delta * delta;
            closest.setZ(-this._extent.getZ());
        } else if (closest.getZ() > this._extent.getZ()) {
            delta = closest.getZ() - this._extent.getZ();
            sqrDistance += delta * delta;
            closest.setZ(this._extent.getZ());
        }
        return Math.sqrt(sqrDistance);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._xAxis, "_xAxis", (Savable)new Vector3(Vector3.UNIT_X));
        capsule.write((Savable)this._yAxis, "yAxis", (Savable)new Vector3(Vector3.UNIT_Y));
        capsule.write((Savable)this._zAxis, "zAxis", (Savable)new Vector3(Vector3.UNIT_Z));
        capsule.write((Savable)this._extent, "extent", (Savable)new Vector3(Vector3.ZERO));
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._xAxis.set((ReadOnlyVector3)((Vector3)capsule.readSavable("xAxis", (Savable)new Vector3(Vector3.UNIT_X))));
        this._yAxis.set((ReadOnlyVector3)((Vector3)capsule.readSavable("yAxis", (Savable)new Vector3(Vector3.UNIT_Y))));
        this._zAxis.set((ReadOnlyVector3)((Vector3)capsule.readSavable("zAxis", (Savable)new Vector3(Vector3.UNIT_Z))));
        this._extent.set((ReadOnlyVector3)((Vector3)capsule.readSavable("extent", (Savable)new Vector3(Vector3.ZERO))));
        this.correctCorners = false;
    }

    @Override
    public double getVolume() {
        return 8.0 * this._extent.getX() * this._extent.getY() * this._extent.getZ();
    }
}

