/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.bounding;

import com.ardor3d.intersection.PrimitiveKey;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.scenegraph.Mesh;
import java.util.Comparator;

public class TreeComparator
implements Comparator<PrimitiveKey> {
    private Axis _axis;
    private Mesh _mesh;
    private Vector3[] _aCompare = null;
    private Vector3[] _bCompare = null;

    public void setAxis(Axis axis) {
        this._axis = axis;
    }

    public void setMesh(Mesh mesh) {
        this._mesh = mesh;
    }

    @Override
    public int compare(PrimitiveKey o1, PrimitiveKey o2) {
        int i;
        if (o1.equals(o2)) {
            return 0;
        }
        Vector3 centerA = null;
        Vector3 centerB = null;
        this._aCompare = this._mesh.getMeshData().getPrimitiveVertices(o1.getPrimitiveIndex(), o1.getSection(), this._aCompare);
        this._bCompare = this._mesh.getMeshData().getPrimitiveVertices(o2.getPrimitiveIndex(), o2.getSection(), this._bCompare);
        for (i = 1; i < this._aCompare.length; ++i) {
            this._aCompare[0].addLocal((ReadOnlyVector3)this._aCompare[i]);
        }
        for (i = 1; i < this._bCompare.length; ++i) {
            this._bCompare[0].addLocal((ReadOnlyVector3)this._bCompare[i]);
        }
        if (this._aCompare.length == this._bCompare.length) {
            centerA = this._aCompare[0];
            centerB = this._bCompare[0];
        } else {
            centerA = this._aCompare[0].divideLocal((double)this._aCompare.length);
            centerB = this._bCompare[0].divideLocal((double)this._bCompare.length);
        }
        switch (this._axis) {
            case X: {
                if (centerA.getX() < centerB.getX()) {
                    return -1;
                }
                if (centerA.getX() > centerB.getX()) {
                    return 1;
                }
                return 0;
            }
            case Y: {
                if (centerA.getY() < centerB.getY()) {
                    return -1;
                }
                if (centerA.getY() > centerB.getY()) {
                    return 1;
                }
                return 0;
            }
            case Z: {
                if (centerA.getZ() < centerB.getZ()) {
                    return -1;
                }
                if (centerA.getZ() > centerB.getZ()) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    static enum Axis {
        X,
        Y,
        Z;

    }
}

