/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.framework;

import com.ardor3d.framework.CanvasRenderer;

public class DisplaySettings {
    private final int _width;
    private final int _height;
    private final int _colorDepth;
    private final int _frequency;
    private final int _alphaBits;
    private final int _depthBits;
    private final int _stencilBits;
    private final int _samples;
    private final boolean _fullScreen;
    private final boolean _stereo;
    private final CanvasRenderer _shareContext;
    private final int _rotation;

    public DisplaySettings(int width, int height, int colorDepth, int frequency, int alphaBits, int depthBits, int stencilBits, int samples, boolean fullScreen, boolean stereo, CanvasRenderer shareContext, int rotation) {
        this._width = width;
        this._height = height;
        this._colorDepth = colorDepth;
        this._frequency = frequency;
        this._alphaBits = alphaBits;
        this._depthBits = depthBits;
        this._stencilBits = stencilBits;
        this._samples = samples;
        this._fullScreen = fullScreen;
        this._stereo = stereo;
        this._shareContext = shareContext;
        this._rotation = rotation;
    }

    public DisplaySettings(int width, int height, int depthBits, int samples) {
        this(width, height, 0, 0, 0, depthBits, 0, samples, false, false, null, 0);
    }

    public DisplaySettings(int width, int height, int colorDepth, int frequency, boolean fullScreen) {
        this(width, height, colorDepth, frequency, 0, 8, 0, 0, fullScreen, false, null, 0);
    }

    public DisplaySettings(int width, int height, int colorDepth, int frequency, int alphaBits, int depthBits, int stencilBits, int samples, boolean fullScreen, boolean stereo) {
        this(width, height, colorDepth, frequency, alphaBits, depthBits, stencilBits, samples, fullScreen, stereo, null, 0);
    }

    public DisplaySettings(int width, int height, int colorDepth, int frequency, int alphaBits, int depthBits, int stencilBits, int samples, boolean fullScreen, boolean stereo, CanvasRenderer shareContext) {
        this(width, height, colorDepth, frequency, alphaBits, depthBits, stencilBits, samples, fullScreen, stereo, shareContext, 0);
    }

    public CanvasRenderer getShareContext() {
        return this._shareContext;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getColorDepth() {
        return this._colorDepth;
    }

    public int getFrequency() {
        return this._frequency;
    }

    public int getAlphaBits() {
        return this._alphaBits;
    }

    public int getDepthBits() {
        return this._depthBits;
    }

    public int getStencilBits() {
        return this._stencilBits;
    }

    public int getSamples() {
        return this._samples;
    }

    public boolean isFullScreen() {
        return this._fullScreen;
    }

    public boolean isStereo() {
        return this._stereo;
    }

    public int getRotation() {
        return this._rotation;
    }

    public int getRotatedWidth() {
        switch (this._rotation) {
            case 0: 
            case 180: {
                return this.getWidth();
            }
            case 90: 
            case 270: {
                return this.getHeight();
            }
        }
        throw new IllegalStateException("The rotation is invalid: " + this._rotation + " There is no valid rotated width");
    }

    public int getRotatedHeight() {
        switch (this._rotation) {
            case 0: 
            case 180: {
                return this.getHeight();
            }
            case 90: 
            case 270: {
                return this.getWidth();
            }
        }
        throw new IllegalStateException("The rotation is invalid: " + this._rotation + " There is no valid rotated height");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DisplaySettings that = (DisplaySettings)o;
        return this._colorDepth == that._colorDepth && this._frequency == that._frequency && this._fullScreen == that._fullScreen && this._height == that._height && this._width == that._width && this._alphaBits == that._alphaBits && this._depthBits == that._depthBits && this._stencilBits == that._stencilBits && this._samples == that._samples && this._stereo == that._stereo && (this._shareContext == that._shareContext || this._shareContext != null && this._shareContext.equals(that._shareContext)) && this._rotation == that._rotation;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this._height;
        result = 31 * result + this._width;
        result = 31 * result + this._colorDepth;
        result = 31 * result + this._frequency;
        result = 31 * result + this._alphaBits;
        result = 31 * result + this._depthBits;
        result = 31 * result + this._stencilBits;
        result = 31 * result + this._samples;
        result = 31 * result + (this._fullScreen ? 1 : 0);
        result = 31 * result + (this._stereo ? 1 : 0);
        result = 31 * result + (this._shareContext == null ? 0 : this._shareContext.hashCode());
        result = 31 * result + this._rotation;
        return result;
    }
}

