/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.framework;

import com.ardor3d.annotation.MainThread;
import com.ardor3d.framework.Canvas;
import com.ardor3d.framework.Updater;
import com.ardor3d.util.Timer;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FrameHandler {
    private static final Logger logger = Logger.getLogger(FrameHandler.class.toString());
    private final CopyOnWriteArrayList<Updater> _updaters;
    private final CopyOnWriteArrayList<Canvas> _canvases;
    private final Timer _timer;
    private long _timeoutSeconds = 5L;

    public FrameHandler(Timer timer) {
        this._timer = timer;
        this._updaters = new CopyOnWriteArrayList();
        this._canvases = new CopyOnWriteArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void updateFrame() {
        Iterator<Canvas> iterator;
        int numCanvases;
        this._timer.update();
        for (Updater updater : this._updaters) {
            updater.update(this._timer);
        }
        FrameHandler frameHandler = this;
        synchronized (frameHandler) {
            numCanvases = this._canvases.size();
            iterator = this._canvases.iterator();
        }
        CountDownLatch latch = new CountDownLatch(numCanvases);
        while (iterator.hasNext()) {
            iterator.next().draw(latch);
        }
        try {
            boolean success = latch.await(this._timeoutSeconds, TimeUnit.SECONDS);
            if (!success) {
                logger.logp(Level.SEVERE, FrameHandler.class.toString(), "updateFrame", "Timeout while waiting for renderers");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void addUpdater(Updater updater) {
        this._updaters.addIfAbsent(updater);
    }

    public boolean removeUpdater(Updater updater) {
        return this._updaters.remove(updater);
    }

    public synchronized void addCanvas(Canvas canvas) {
        this._canvases.addIfAbsent(canvas);
    }

    public synchronized boolean removeCanvas(Canvas canvas) {
        return this._canvases.remove(canvas);
    }

    public void init() {
        for (Canvas canvas : this._canvases) {
            canvas.init();
        }
        for (Updater updater : this._updaters) {
            updater.init();
        }
    }

    public long getTimeoutSeconds() {
        return this._timeoutSeconds;
    }

    public void setTimeoutSeconds(long timeoutSeconds) {
        this._timeoutSeconds = timeoutSeconds;
    }

    public Timer getTimer() {
        return this._timer;
    }
}

