/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image;

import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Image
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    protected ImageDataFormat _format = ImageDataFormat.RGBA;
    protected PixelDataType _type = PixelDataType.UnsignedByte;
    protected int _width;
    protected int _height;
    protected int _depth;
    protected int[] _mipMapSizes;
    protected List<ByteBuffer> _data;

    public Image() {
        this._data = new ArrayList<ByteBuffer>(1);
    }

    public Image(ImageDataFormat format, PixelDataType type, int width, int height, List<ByteBuffer> data, int[] mipMapSizes) {
        if (mipMapSizes != null && mipMapSizes.length <= 1) {
            mipMapSizes = null;
        }
        this.setDataFormat(format);
        this.setDataType(type);
        this.setData(data);
        this._width = width;
        this._height = height;
        this._depth = data.size();
        this._mipMapSizes = mipMapSizes;
    }

    public Image(ImageDataFormat format, PixelDataType type, int width, int height, ByteBuffer data, int[] mipMapSizes) {
        this(format, type, width, height, new ArrayList<ByteBuffer>(Arrays.asList(data)), mipMapSizes);
    }

    public void setData(List<ByteBuffer> data) {
        if (data == null) {
            throw new NullPointerException("data may not be null.");
        }
        this._data = data;
    }

    public void setData(ByteBuffer data) {
        this._data = new ArrayList<ByteBuffer>(Arrays.asList(data));
    }

    public void addData(ByteBuffer data) {
        if (this._data == null) {
            this._data = new ArrayList<ByteBuffer>(1);
        }
        this._data.add(data);
    }

    public void setData(int index, ByteBuffer data) {
        if (index >= 0) {
            while (this._data.size() <= index) {
                this._data.add(null);
            }
        } else {
            throw new IllegalArgumentException("index must be greater than or equal to 0.");
        }
        this._data.set(index, data);
    }

    public void setMipMapByteSizes(int[] mipMapSizes) {
        if (mipMapSizes != null && mipMapSizes.length <= 1) {
            mipMapSizes = null;
        }
        this._mipMapSizes = mipMapSizes;
    }

    public void setHeight(int height) {
        this._height = height;
    }

    public void setDepth(int depth) {
        this._depth = depth;
    }

    public void setWidth(int width) {
        this._width = width;
    }

    public void setDataFormat(ImageDataFormat format) {
        if (format == null) {
            throw new NullPointerException("format may not be null.");
        }
        this._format = format;
    }

    public ImageDataFormat getDataFormat() {
        return this._format;
    }

    public void setDataType(PixelDataType type) {
        if (type == null) {
            throw new NullPointerException("type may not be null.");
        }
        this._type = type;
    }

    public PixelDataType getDataType() {
        return this._type;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getDepth() {
        return this._depth;
    }

    public List<ByteBuffer> getData() {
        return this._data;
    }

    public int getDataSize() {
        if (this._data == null) {
            return 0;
        }
        return this._data.size();
    }

    public ByteBuffer getData(int index) {
        if (this._data.size() > index) {
            return this._data.get(index);
        }
        return null;
    }

    public boolean hasMipmaps() {
        return this._mipMapSizes != null;
    }

    public int[] getMipMapByteSizes() {
        return this._mipMapSizes;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Image)) {
            return false;
        }
        Image that = (Image)other;
        if (this.getDataFormat() != that.getDataFormat()) {
            return false;
        }
        if (this.getDataType() != that.getDataType()) {
            return false;
        }
        if (this.getWidth() != that.getWidth()) {
            return false;
        }
        if (this.getHeight() != that.getHeight()) {
            return false;
        }
        if (!this.getData().equals(that.getData())) {
            return false;
        }
        if (this.getMipMapByteSizes() != null && !Arrays.equals(this.getMipMapByteSizes(), that.getMipMapByteSizes())) {
            return false;
        }
        return this.getMipMapByteSizes() != null || that.getMipMapByteSizes() == null;
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Enum)this._format, "dataformat", (Enum)ImageDataFormat.RGBA);
        capsule.write((Enum)this._type, "datatype", (Enum)PixelDataType.UnsignedByte);
        capsule.write(this._width, "width", 0);
        capsule.write(this._height, "height", 0);
        capsule.write(this._depth, "depth", 0);
        capsule.write(this._mipMapSizes, "mipMapSizes", null);
        capsule.writeByteBufferList(this._data, "data", null);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._format = (ImageDataFormat)capsule.readEnum("dataformat", ImageDataFormat.class, (Enum)ImageDataFormat.RGBA);
        this._type = (PixelDataType)capsule.readEnum("datatype", PixelDataType.class, (Enum)PixelDataType.UnsignedByte);
        this._width = capsule.readInt("width", 0);
        this._height = capsule.readInt("height", 0);
        this._depth = capsule.readInt("depth", 0);
        this._mipMapSizes = capsule.readIntArray("mipMapSizes", null);
        this._data = capsule.readByteBufferList("data", null);
    }

    public Class<? extends Image> getClassTag() {
        return this.getClass();
    }
}

