/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image;

import com.ardor3d.image.Image;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.image.TextureStoreFormat;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Matrix4;
import com.ardor3d.math.Vector4;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyMatrix4;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.util.Constants;
import com.ardor3d.util.TextureKey;
import com.ardor3d.util.TextureManager;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public abstract class Texture
implements Savable {
    public static boolean DEFAULT_STORE_IMAGE = Constants.storeSavableImages;
    private Image _image = null;
    private final ColorRGBA _constantColor = new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA);
    private final ColorRGBA _borderColor = new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA);
    private final Matrix4 _texMatrix = new Matrix4();
    private float _anisotropicFilterPercent = 0.0f;
    private float _lodBias = 0.0f;
    private ApplyMode _apply = ApplyMode.Modulate;
    private MinificationFilter _minificationFilter = MinificationFilter.NearestNeighborNoMipMaps;
    private MagnificationFilter _magnificationFilter = MagnificationFilter.Bilinear;
    private EnvironmentalMapMode _envMapMode = EnvironmentalMapMode.None;
    private Vector4 _envPlaneS = null;
    private Vector4 _envPlaneT = null;
    private Vector4 _envPlaneR = null;
    private Vector4 _envPlaneQ = null;
    private boolean _hasBorder = false;
    private CombinerFunctionRGB _combineFuncRGB = CombinerFunctionRGB.Modulate;
    private CombinerSource _combineSrc0RGB = CombinerSource.CurrentTexture;
    private CombinerSource _combineSrc1RGB = CombinerSource.Previous;
    private CombinerSource _combineSrc2RGB = CombinerSource.Constant;
    private CombinerOperandRGB _combineOp0RGB = CombinerOperandRGB.SourceColor;
    private CombinerOperandRGB _combineOp1RGB = CombinerOperandRGB.SourceColor;
    private CombinerOperandRGB _combineOp2RGB = CombinerOperandRGB.SourceAlpha;
    private CombinerScale _combineScaleRGB = CombinerScale.One;
    private CombinerFunctionAlpha _combineFuncAlpha = CombinerFunctionAlpha.Modulate;
    private CombinerSource _combineSrc0Alpha = CombinerSource.CurrentTexture;
    private CombinerSource _combineSrc1Alpha = CombinerSource.Previous;
    private CombinerSource _combineSrc2Alpha = CombinerSource.Constant;
    private CombinerOperandAlpha _combineOp0Alpha = CombinerOperandAlpha.SourceAlpha;
    private CombinerOperandAlpha _combineOp1Alpha = CombinerOperandAlpha.SourceAlpha;
    private CombinerOperandAlpha _combineOp2Alpha = CombinerOperandAlpha.SourceAlpha;
    private CombinerScale _combineScaleAlpha = CombinerScale.One;
    private TextureKey _key = null;
    private TextureStoreFormat _storeFormat = TextureStoreFormat.RGBA8;
    private PixelDataType _rttPixelDataType = PixelDataType.UnsignedByte;
    private transient boolean _storeImage = DEFAULT_STORE_IMAGE;
    private DepthTextureCompareMode _depthCompareMode = DepthTextureCompareMode.None;
    private DepthTextureCompareFunc _depthCompareFunc = DepthTextureCompareFunc.GreaterThanEqual;
    private DepthTextureMode _depthMode = DepthTextureMode.Intensity;
    private int _textureBaseLevel = 0;
    private int _textureMaxLevel = -1;

    public void setConstantColor(ReadOnlyColorRGBA color) {
        this._constantColor.set(color);
    }

    public void setConstantColor(float red, float green, float blue, float alpha) {
        this._constantColor.set(red, green, blue, alpha);
    }

    public void setBorderColor(ReadOnlyColorRGBA color) {
        this._borderColor.set(color);
    }

    public void setBorderColor(float red, float green, float blue, float alpha) {
        this._borderColor.set(red, green, blue, alpha);
    }

    public MinificationFilter getMinificationFilter() {
        return this._minificationFilter;
    }

    public void setMinificationFilter(MinificationFilter minificationFilter) {
        if (minificationFilter == null) {
            throw new IllegalArgumentException("minificationFilter can not be null.");
        }
        this._minificationFilter = minificationFilter;
    }

    public MagnificationFilter getMagnificationFilter() {
        return this._magnificationFilter;
    }

    public void setMagnificationFilter(MagnificationFilter magnificationFilter) {
        if (magnificationFilter == null) {
            throw new IllegalArgumentException("magnificationFilter can not be null.");
        }
        this._magnificationFilter = magnificationFilter;
    }

    public void setApply(ApplyMode apply) {
        if (apply == null) {
            throw new IllegalArgumentException("apply can not be null.");
        }
        this._apply = apply;
    }

    public void setImage(Image image) {
        this._image = image;
        this.setDirty();
    }

    public int getTextureIdForContext(Object glContext) {
        return this._key.getTextureIdForContext(glContext);
    }

    public Integer getTextureIdForContextAsInteger(Object glContext) {
        return this._key.getTextureIdForContext(glContext);
    }

    public void setTextureIdForContext(Object glContext, int textureId) {
        this._key.setTextureIdForContext(glContext, textureId);
    }

    public void removeFromIdCache(Object glContext) {
        this._key.removeFromIdCache(glContext);
    }

    public Image getImage() {
        return this._image;
    }

    public ApplyMode getApply() {
        return this._apply;
    }

    public ReadOnlyColorRGBA getConstantColor() {
        return this._constantColor;
    }

    public ReadOnlyColorRGBA getBorderColor() {
        return this._borderColor;
    }

    public abstract void setWrap(WrapAxis var1, WrapMode var2);

    public abstract void setWrap(WrapMode var1);

    public abstract WrapMode getWrap(WrapAxis var1);

    public abstract Type getType();

    public CombinerFunctionRGB getCombineFuncRGB() {
        return this._combineFuncRGB;
    }

    public void setCombineFuncRGB(CombinerFunctionRGB combineFuncRGB) {
        if (combineFuncRGB == null) {
            throw new IllegalArgumentException("invalid CombinerFunctionRGB: null");
        }
        this._combineFuncRGB = combineFuncRGB;
    }

    public CombinerOperandAlpha getCombineOp0Alpha() {
        return this._combineOp0Alpha;
    }

    public void setCombineOp0Alpha(CombinerOperandAlpha combineOp0Alpha) {
        if (combineOp0Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerOperandAlpha: null");
        }
        this._combineOp0Alpha = combineOp0Alpha;
    }

    public CombinerOperandRGB getCombineOp0RGB() {
        return this._combineOp0RGB;
    }

    public void setCombineOp0RGB(CombinerOperandRGB combineOp0RGB) {
        if (combineOp0RGB == null) {
            throw new IllegalArgumentException("invalid CombinerOperandRGB: null");
        }
        this._combineOp0RGB = combineOp0RGB;
    }

    public CombinerOperandAlpha getCombineOp1Alpha() {
        return this._combineOp1Alpha;
    }

    public void setCombineOp1Alpha(CombinerOperandAlpha combineOp1Alpha) {
        if (combineOp1Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerOperandAlpha: null");
        }
        this._combineOp1Alpha = combineOp1Alpha;
    }

    public CombinerOperandRGB getCombineOp1RGB() {
        return this._combineOp1RGB;
    }

    public void setCombineOp1RGB(CombinerOperandRGB combineOp1RGB) {
        if (combineOp1RGB == null) {
            throw new IllegalArgumentException("invalid CombinerOperandRGB: null");
        }
        this._combineOp1RGB = combineOp1RGB;
    }

    public CombinerOperandAlpha getCombineOp2Alpha() {
        return this._combineOp2Alpha;
    }

    public void setCombineOp2Alpha(CombinerOperandAlpha combineOp2Alpha) {
        if (combineOp2Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerOperandAlpha: null");
        }
        this._combineOp2Alpha = combineOp2Alpha;
    }

    public CombinerOperandRGB getCombineOp2RGB() {
        return this._combineOp2RGB;
    }

    public void setCombineOp2RGB(CombinerOperandRGB combineOp2RGB) {
        if (combineOp2RGB == null) {
            throw new IllegalArgumentException("invalid CombinerOperandRGB: null");
        }
        this._combineOp2RGB = combineOp2RGB;
    }

    public CombinerScale getCombineScaleAlpha() {
        return this._combineScaleAlpha;
    }

    public void setCombineScaleAlpha(CombinerScale combineScaleAlpha) {
        if (combineScaleAlpha == null) {
            throw new IllegalArgumentException("invalid CombinerScale: null");
        }
        this._combineScaleAlpha = combineScaleAlpha;
    }

    public CombinerScale getCombineScaleRGB() {
        return this._combineScaleRGB;
    }

    public void setCombineScaleRGB(CombinerScale combineScaleRGB) {
        if (combineScaleRGB == null) {
            throw new IllegalArgumentException("invalid CombinerScale: null");
        }
        this._combineScaleRGB = combineScaleRGB;
    }

    public CombinerSource getCombineSrc0Alpha() {
        return this._combineSrc0Alpha;
    }

    public void setCombineSrc0Alpha(CombinerSource combineSrc0Alpha) {
        if (combineSrc0Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc0Alpha = combineSrc0Alpha;
    }

    public CombinerSource getCombineSrc0RGB() {
        return this._combineSrc0RGB;
    }

    public void setCombineSrc0RGB(CombinerSource combineSrc0RGB) {
        if (combineSrc0RGB == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc0RGB = combineSrc0RGB;
    }

    public CombinerSource getCombineSrc1Alpha() {
        return this._combineSrc1Alpha;
    }

    public void setCombineSrc1Alpha(CombinerSource combineSrc1Alpha) {
        if (combineSrc1Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc1Alpha = combineSrc1Alpha;
    }

    public CombinerSource getCombineSrc1RGB() {
        return this._combineSrc1RGB;
    }

    public void setCombineSrc1RGB(CombinerSource combineSrc1RGB) {
        if (combineSrc1RGB == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc1RGB = combineSrc1RGB;
    }

    public CombinerSource getCombineSrc2Alpha() {
        return this._combineSrc2Alpha;
    }

    public void setCombineSrc2Alpha(CombinerSource combineSrc2Alpha) {
        if (combineSrc2Alpha == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc2Alpha = combineSrc2Alpha;
    }

    public CombinerSource getCombineSrc2RGB() {
        return this._combineSrc2RGB;
    }

    public void setCombineSrc2RGB(CombinerSource combineSrc2RGB) {
        if (combineSrc2RGB == null) {
            throw new IllegalArgumentException("invalid CombinerSource: null");
        }
        this._combineSrc2RGB = combineSrc2RGB;
    }

    public CombinerFunctionAlpha getCombineFuncAlpha() {
        return this._combineFuncAlpha;
    }

    public void setCombineFuncAlpha(CombinerFunctionAlpha combineFuncAlpha) {
        if (combineFuncAlpha == null) {
            throw new IllegalArgumentException("invalid CombinerFunctionAlpha: null");
        }
        this._combineFuncAlpha = combineFuncAlpha;
    }

    public void setEnvironmentalMapMode(EnvironmentalMapMode envMapMode) {
        if (envMapMode == null) {
            throw new IllegalArgumentException("invalid EnvironmentalMapMode: null");
        }
        this._envMapMode = envMapMode;
    }

    public EnvironmentalMapMode getEnvironmentalMapMode() {
        return this._envMapMode;
    }

    public ReadOnlyVector4 getEnvPlaneS() {
        return this._envPlaneS;
    }

    public void setEnvPlaneS(ReadOnlyVector4 plane) {
        if (plane == null) {
            this._envPlaneS = null;
            return;
        }
        if (this._envPlaneS == null) {
            this._envPlaneS = new Vector4(plane);
        } else {
            this._envPlaneS.set(plane);
        }
    }

    public ReadOnlyVector4 getEnvPlaneT() {
        return this._envPlaneT;
    }

    public void setEnvPlaneT(ReadOnlyVector4 plane) {
        if (plane == null) {
            this._envPlaneT = null;
            return;
        }
        if (this._envPlaneT == null) {
            this._envPlaneT = new Vector4(plane);
        } else {
            this._envPlaneT.set(plane);
        }
    }

    public ReadOnlyVector4 getEnvPlaneR() {
        return this._envPlaneR;
    }

    public void setEnvPlaneR(ReadOnlyVector4 plane) {
        if (plane == null) {
            this._envPlaneR = null;
            return;
        }
        if (this._envPlaneR == null) {
            this._envPlaneR = new Vector4(plane);
        } else {
            this._envPlaneR.set(plane);
        }
    }

    public ReadOnlyVector4 getEnvPlaneQ() {
        return this._envPlaneQ;
    }

    public void setEnvPlaneQ(ReadOnlyVector4 plane) {
        if (plane == null) {
            this._envPlaneQ = null;
            return;
        }
        if (this._envPlaneQ == null) {
            this._envPlaneQ = new Vector4(plane);
        } else {
            this._envPlaneQ.set(plane);
        }
    }

    public float getAnisotropicFilterPercent() {
        return this._anisotropicFilterPercent;
    }

    public void setAnisotropicFilterPercent(float percent) {
        if (percent > 1.0f) {
            percent = 1.0f;
        } else if (percent < 0.0f) {
            percent = 0.0f;
        }
        this._anisotropicFilterPercent = percent;
    }

    public float getLodBias() {
        return this._lodBias;
    }

    public void setLodBias(float bias) {
        this._lodBias = bias;
    }

    public void setTextureKey(TextureKey tkey) {
        this._key = tkey;
    }

    public TextureKey getTextureKey() {
        return this._key;
    }

    public void setTextureStoreFormat(TextureStoreFormat storeFormat) {
        this._storeFormat = storeFormat;
    }

    public void setRenderedTexturePixelDataType(PixelDataType type) {
        this._rttPixelDataType = type;
    }

    public PixelDataType getRenderedTexturePixelDataType() {
        return this._rttPixelDataType;
    }

    public TextureStoreFormat getTextureStoreFormat() {
        return this._storeFormat;
    }

    public boolean isStoreImage() {
        return this._storeImage;
    }

    public void setStoreImage(boolean store) {
        this._storeImage = store;
    }

    public boolean hasBorder() {
        return this._hasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this._hasBorder = hasBorder;
    }

    public DepthTextureCompareFunc getDepthCompareFunc() {
        return this._depthCompareFunc;
    }

    public void setDepthCompareFunc(DepthTextureCompareFunc depthCompareFunc) {
        this._depthCompareFunc = depthCompareFunc;
    }

    public DepthTextureMode getDepthMode() {
        return this._depthMode;
    }

    public void setDepthMode(DepthTextureMode depthMode) {
        this._depthMode = depthMode;
    }

    public DepthTextureCompareMode getDepthCompareMode() {
        return this._depthCompareMode;
    }

    public void setDepthCompareMode(DepthTextureCompareMode depthCompareMode) {
        this._depthCompareMode = depthCompareMode;
    }

    public void setDirty() {
        if (this._key != null) {
            this._key.setDirty();
        }
    }

    public boolean isDirty(Object glContext) {
        return this._key.isDirty(glContext);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Texture)) {
            return false;
        }
        Texture that = (Texture)other;
        if (this.getImage() != null && !this.getImage().equals(that.getImage())) {
            return false;
        }
        if (this.getImage() == null && that.getImage() != null) {
            return false;
        }
        if (this.getAnisotropicFilterPercent() != that.getAnisotropicFilterPercent()) {
            return false;
        }
        if (this.getApply() != that.getApply()) {
            return false;
        }
        if (this.getCombineFuncAlpha() != that.getCombineFuncAlpha()) {
            return false;
        }
        if (this.getCombineFuncRGB() != that.getCombineFuncRGB()) {
            return false;
        }
        if (this.getCombineOp0Alpha() != that.getCombineOp0Alpha()) {
            return false;
        }
        if (this.getCombineOp1RGB() != that.getCombineOp1RGB()) {
            return false;
        }
        if (this.getCombineOp2Alpha() != that.getCombineOp2Alpha()) {
            return false;
        }
        if (this.getCombineOp2RGB() != that.getCombineOp2RGB()) {
            return false;
        }
        if (this.getCombineScaleAlpha() != that.getCombineScaleAlpha()) {
            return false;
        }
        if (this.getCombineScaleRGB() != that.getCombineScaleRGB()) {
            return false;
        }
        if (this.getCombineSrc0Alpha() != that.getCombineSrc0Alpha()) {
            return false;
        }
        if (this.getCombineSrc0RGB() != that.getCombineSrc0RGB()) {
            return false;
        }
        if (this.getCombineSrc1Alpha() != that.getCombineSrc1Alpha()) {
            return false;
        }
        if (this.getCombineSrc1RGB() != that.getCombineSrc1RGB()) {
            return false;
        }
        if (this.getCombineSrc2Alpha() != that.getCombineSrc2Alpha()) {
            return false;
        }
        if (this.getCombineSrc2RGB() != that.getCombineSrc2RGB()) {
            return false;
        }
        if (this.getEnvironmentalMapMode() != that.getEnvironmentalMapMode()) {
            return false;
        }
        if (this.getMagnificationFilter() != that.getMagnificationFilter()) {
            return false;
        }
        if (this.getMinificationFilter() != that.getMinificationFilter()) {
            return false;
        }
        if (!this._constantColor.equals((Object)that._constantColor)) {
            return false;
        }
        return this._borderColor.equals((Object)that._borderColor);
    }

    public abstract Texture createSimpleClone();

    public Texture createSimpleClone(Texture rVal) {
        rVal.setAnisotropicFilterPercent(this._anisotropicFilterPercent);
        rVal.setApply(this._apply);
        rVal.setConstantColor((ReadOnlyColorRGBA)this._constantColor);
        rVal.setBorderColor((ReadOnlyColorRGBA)this._borderColor);
        rVal.setCombineFuncAlpha(this._combineFuncAlpha);
        rVal.setCombineFuncRGB(this._combineFuncRGB);
        rVal.setCombineOp0Alpha(this._combineOp0Alpha);
        rVal.setCombineOp0RGB(this._combineOp0RGB);
        rVal.setCombineOp1Alpha(this._combineOp1Alpha);
        rVal.setCombineOp1RGB(this._combineOp1RGB);
        rVal.setCombineOp2Alpha(this._combineOp2Alpha);
        rVal.setCombineOp2RGB(this._combineOp2RGB);
        rVal.setCombineScaleAlpha(this._combineScaleAlpha);
        rVal.setCombineScaleRGB(this._combineScaleRGB);
        rVal.setCombineSrc0Alpha(this._combineSrc0Alpha);
        rVal.setCombineSrc0RGB(this._combineSrc0RGB);
        rVal.setCombineSrc1Alpha(this._combineSrc1Alpha);
        rVal.setCombineSrc1RGB(this._combineSrc1RGB);
        rVal.setCombineSrc2Alpha(this._combineSrc2Alpha);
        rVal.setCombineSrc2RGB(this._combineSrc2RGB);
        rVal.setDepthCompareFunc(this._depthCompareFunc);
        rVal.setDepthCompareMode(this._depthCompareMode);
        rVal.setDepthMode(this._depthMode);
        rVal.setEnvironmentalMapMode(this._envMapMode);
        rVal.setEnvPlaneS((ReadOnlyVector4)this._envPlaneS);
        rVal.setEnvPlaneT((ReadOnlyVector4)this._envPlaneT);
        rVal.setEnvPlaneR((ReadOnlyVector4)this._envPlaneR);
        rVal.setEnvPlaneQ((ReadOnlyVector4)this._envPlaneQ);
        rVal.setHasBorder(this._hasBorder);
        rVal.setTextureStoreFormat(this._storeFormat);
        rVal.setRenderedTexturePixelDataType(this._rttPixelDataType);
        rVal.setImage(this._image);
        rVal.setLodBias(this._lodBias);
        rVal.setMinificationFilter(this._minificationFilter);
        rVal.setMagnificationFilter(this._magnificationFilter);
        rVal.setStoreImage(this._storeImage);
        rVal.setTextureMatrix((ReadOnlyMatrix4)this._texMatrix);
        if (this.getTextureKey() != null) {
            rVal.setTextureKey(this.getTextureKey());
        }
        return rVal;
    }

    public ReadOnlyMatrix4 getTextureMatrix() {
        return this._texMatrix;
    }

    public void setTextureMatrix(ReadOnlyMatrix4 matrix) {
        this._texMatrix.set(matrix);
    }

    public void write(OutputCapsule capsule) throws IOException {
        if (this._storeImage) {
            capsule.write((Savable)this._image, "image", null);
        }
        capsule.write((Savable)this._constantColor, "constantColor", (Savable)new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA));
        capsule.write((Savable)this._borderColor, "borderColor", (Savable)new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA));
        capsule.write((Savable)this._texMatrix, "texMatrix", (Savable)new Matrix4(Matrix4.IDENTITY));
        capsule.write(this._hasBorder, "hasBorder", false);
        capsule.write(this._anisotropicFilterPercent, "anisotropicFilterPercent", 0.0f);
        capsule.write(this._lodBias, "lodBias", 0.0f);
        capsule.write((Enum)this._minificationFilter, "minificationFilter", (Enum)MinificationFilter.NearestNeighborNoMipMaps);
        capsule.write((Enum)this._magnificationFilter, "magnificationFilter", (Enum)MagnificationFilter.Bilinear);
        capsule.write((Enum)this._apply, "apply", (Enum)ApplyMode.Modulate);
        capsule.write((Enum)this._envMapMode, "envMapMode", (Enum)EnvironmentalMapMode.None);
        capsule.write((Savable)this._envPlaneS, "envPlaneS", null);
        capsule.write((Savable)this._envPlaneT, "envPlaneT", null);
        capsule.write((Savable)this._envPlaneR, "envPlaneR", null);
        capsule.write((Savable)this._envPlaneQ, "envPlaneQ", null);
        capsule.write((Enum)this._combineFuncRGB, "combineFuncRGB", (Enum)CombinerFunctionRGB.Replace);
        capsule.write((Enum)this._combineFuncAlpha, "combineFuncAlpha", (Enum)CombinerFunctionAlpha.Replace);
        capsule.write((Enum)this._combineSrc0RGB, "combineSrc0RGB", (Enum)CombinerSource.CurrentTexture);
        capsule.write((Enum)this._combineSrc1RGB, "combineSrc1RGB", (Enum)CombinerSource.Previous);
        capsule.write((Enum)this._combineSrc2RGB, "combineSrc2RGB", (Enum)CombinerSource.Constant);
        capsule.write((Enum)this._combineSrc0Alpha, "combineSrc0Alpha", (Enum)CombinerSource.CurrentTexture);
        capsule.write((Enum)this._combineSrc1Alpha, "combineSrc1Alpha", (Enum)CombinerSource.Previous);
        capsule.write((Enum)this._combineSrc2Alpha, "combineSrc2Alpha", (Enum)CombinerSource.Constant);
        capsule.write((Enum)this._combineOp0RGB, "combineOp0RGB", (Enum)CombinerOperandRGB.SourceColor);
        capsule.write((Enum)this._combineOp1RGB, "combineOp1RGB", (Enum)CombinerOperandRGB.SourceColor);
        capsule.write((Enum)this._combineOp2RGB, "combineOp2RGB", (Enum)CombinerOperandRGB.SourceAlpha);
        capsule.write((Enum)this._combineOp0Alpha, "combineOp0Alpha", (Enum)CombinerOperandAlpha.SourceAlpha);
        capsule.write((Enum)this._combineOp1Alpha, "combineOp1Alpha", (Enum)CombinerOperandAlpha.SourceAlpha);
        capsule.write((Enum)this._combineOp2Alpha, "combineOp2Alpha", (Enum)CombinerOperandAlpha.SourceAlpha);
        capsule.write((Enum)this._combineScaleRGB, "combineScaleRGB", (Enum)CombinerScale.One);
        capsule.write((Enum)this._combineScaleAlpha, "combineScaleAlpha", (Enum)CombinerScale.One);
        capsule.write((Enum)this._storeFormat, "storeFormat", (Enum)TextureStoreFormat.RGBA8);
        capsule.write((Enum)this._rttPixelDataType, "rttPixelDataType", (Enum)PixelDataType.UnsignedByte);
        capsule.write((Savable)this._key, "textureKey", null);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._minificationFilter = (MinificationFilter)capsule.readEnum("minificationFilter", MinificationFilter.class, (Enum)MinificationFilter.NearestNeighborNoMipMaps);
        this._image = (Image)capsule.readSavable("image", null);
        TextureKey key = (TextureKey)capsule.readSavable("textureKey", null);
        this._key = key != null ? TextureKey.getKey(key.getSource(), key.isFlipped(), key.getFormat(), key.getId(), key.getMinificationFilter()) : TextureKey.getRTTKey(this._minificationFilter);
        if (this._image == null && this._key != null && this._key.getSource() != null) {
            TextureManager.loadFromKey(this._key, null, this);
        }
        this._constantColor.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("constantColor", (Savable)new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA))));
        this._borderColor.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("borderColor", (Savable)new ColorRGBA(ColorRGBA.BLACK_NO_ALPHA))));
        this._texMatrix.set((ReadOnlyMatrix4)((Matrix4)capsule.readSavable("texMatrix", (Savable)new Matrix4(Matrix4.IDENTITY))));
        this._hasBorder = capsule.readBoolean("hasBorder", false);
        this._anisotropicFilterPercent = capsule.readFloat("anisotropicFilterPercent", 0.0f);
        this._lodBias = capsule.readFloat("lodBias", 0.0f);
        this._magnificationFilter = (MagnificationFilter)capsule.readEnum("magnificationFilter", MagnificationFilter.class, (Enum)MagnificationFilter.Bilinear);
        this._apply = (ApplyMode)capsule.readEnum("apply", ApplyMode.class, (Enum)ApplyMode.Modulate);
        this._envMapMode = (EnvironmentalMapMode)capsule.readEnum("envMapMode", EnvironmentalMapMode.class, (Enum)EnvironmentalMapMode.None);
        this._envPlaneS = (Vector4)capsule.readSavable("envPlaneS", null);
        this._envPlaneT = (Vector4)capsule.readSavable("envPlaneT", null);
        this._envPlaneR = (Vector4)capsule.readSavable("envPlaneR", null);
        this._envPlaneQ = (Vector4)capsule.readSavable("envPlaneQ", null);
        this._combineFuncRGB = (CombinerFunctionRGB)capsule.readEnum("combineFuncRGB", CombinerFunctionRGB.class, (Enum)CombinerFunctionRGB.Replace);
        this._combineFuncAlpha = (CombinerFunctionAlpha)capsule.readEnum("combineFuncAlpha", CombinerFunctionAlpha.class, (Enum)CombinerFunctionAlpha.Replace);
        this._combineSrc0RGB = (CombinerSource)capsule.readEnum("combineSrc0RGB", CombinerSource.class, (Enum)CombinerSource.CurrentTexture);
        this._combineSrc1RGB = (CombinerSource)capsule.readEnum("combineSrc1RGB", CombinerSource.class, (Enum)CombinerSource.Previous);
        this._combineSrc2RGB = (CombinerSource)capsule.readEnum("combineSrc2RGB", CombinerSource.class, (Enum)CombinerSource.Constant);
        this._combineSrc0Alpha = (CombinerSource)capsule.readEnum("combineSrc0Alpha", CombinerSource.class, (Enum)CombinerSource.CurrentTexture);
        this._combineSrc1Alpha = (CombinerSource)capsule.readEnum("combineSrc1Alpha", CombinerSource.class, (Enum)CombinerSource.Previous);
        this._combineSrc2Alpha = (CombinerSource)capsule.readEnum("combineSrc2Alpha", CombinerSource.class, (Enum)CombinerSource.Constant);
        this._combineOp0RGB = (CombinerOperandRGB)capsule.readEnum("combineOp0RGB", CombinerOperandRGB.class, (Enum)CombinerOperandRGB.SourceColor);
        this._combineOp1RGB = (CombinerOperandRGB)capsule.readEnum("combineOp1RGB", CombinerOperandRGB.class, (Enum)CombinerOperandRGB.SourceColor);
        this._combineOp2RGB = (CombinerOperandRGB)capsule.readEnum("combineOp2RGB", CombinerOperandRGB.class, (Enum)CombinerOperandRGB.SourceAlpha);
        this._combineOp0Alpha = (CombinerOperandAlpha)capsule.readEnum("combineOp0Alpha", CombinerOperandAlpha.class, (Enum)CombinerOperandAlpha.SourceAlpha);
        this._combineOp1Alpha = (CombinerOperandAlpha)capsule.readEnum("combineOp1Alpha", CombinerOperandAlpha.class, (Enum)CombinerOperandAlpha.SourceAlpha);
        this._combineOp2Alpha = (CombinerOperandAlpha)capsule.readEnum("combineOp2Alpha", CombinerOperandAlpha.class, (Enum)CombinerOperandAlpha.SourceAlpha);
        this._combineScaleRGB = (CombinerScale)capsule.readEnum("combineScaleRGB", CombinerScale.class, (Enum)CombinerScale.One);
        this._combineScaleAlpha = (CombinerScale)capsule.readEnum("combineScaleAlpha", CombinerScale.class, (Enum)CombinerScale.One);
        this._storeFormat = (TextureStoreFormat)capsule.readEnum("storeFormat", TextureStoreFormat.class, (Enum)TextureStoreFormat.RGBA8);
        this._rttPixelDataType = (PixelDataType)capsule.readEnum("rttPixelDataType", PixelDataType.class, (Enum)PixelDataType.UnsignedByte);
    }

    public Class<? extends Texture> getClassTag() {
        return this.getClass();
    }

    public int getTextureBaseLevel() {
        return this._textureBaseLevel;
    }

    public void setTextureBaseLevel(int textureBaseLevel) {
        this._textureBaseLevel = textureBaseLevel;
    }

    public int getTextureMaxLevel() {
        return this._textureMaxLevel;
    }

    public void setTextureMaxLevel(int textureMaxLevel) {
        this._textureMaxLevel = textureMaxLevel;
    }

    public static enum DepthTextureMode {
        Luminance,
        Alpha,
        Intensity;

    }

    public static enum DepthTextureCompareFunc {
        LessThanEqual,
        GreaterThanEqual;

    }

    public static enum DepthTextureCompareMode {
        None,
        RtoTexture;

    }

    public static enum CombinerScale {
        One(1.0f),
        Two(2.0f),
        Four(4.0f);

        private float scale;

        private CombinerScale(float scale) {
            this.scale = scale;
        }

        public float floatValue() {
            return this.scale;
        }
    }

    public static enum CombinerOperandAlpha {
        SourceAlpha,
        OneMinusSourceAlpha;

    }

    public static enum CombinerOperandRGB {
        SourceColor,
        OneMinusSourceColor,
        SourceAlpha,
        OneMinusSourceAlpha;

    }

    public static enum CombinerSource {
        Previous,
        Constant,
        PrimaryColor,
        CurrentTexture,
        TextureUnit0,
        TextureUnit1,
        TextureUnit2,
        TextureUnit3,
        TextureUnit4,
        TextureUnit5,
        TextureUnit6,
        TextureUnit7,
        TextureUnit8,
        TextureUnit9,
        TextureUnit10,
        TextureUnit11,
        TextureUnit12,
        TextureUnit13,
        TextureUnit14,
        TextureUnit15,
        TextureUnit16,
        TextureUnit17,
        TextureUnit18,
        TextureUnit19,
        TextureUnit20,
        TextureUnit21,
        TextureUnit22,
        TextureUnit23,
        TextureUnit24,
        TextureUnit25,
        TextureUnit26,
        TextureUnit27,
        TextureUnit28,
        TextureUnit29,
        TextureUnit30,
        TextureUnit31;

    }

    public static enum CombinerFunctionAlpha {
        Replace,
        Modulate,
        Add,
        AddSigned,
        Interpolate,
        Subtract;

    }

    public static enum CombinerFunctionRGB {
        Replace,
        Modulate,
        Add,
        AddSigned,
        Interpolate,
        Subtract,
        Dot3RGB,
        Dot3RGBA;

    }

    public static enum EnvironmentalMapMode {
        None,
        EyeLinear,
        ObjectLinear,
        SphereMap,
        NormalMap,
        ReflectionMap;

    }

    public static enum ApplyMode {
        Replace,
        Decal,
        Modulate,
        Blend,
        Combine,
        Add;

    }

    public static enum WrapAxis {
        S,
        T,
        R;

    }

    public static enum WrapMode {
        Repeat,
        MirroredRepeat,
        Clamp,
        MirrorClamp,
        BorderClamp,
        MirrorBorderClamp,
        EdgeClamp,
        MirrorEdgeClamp;

    }

    public static enum MagnificationFilter {
        NearestNeighbor,
        Bilinear;

    }

    public static enum MinificationFilter {
        NearestNeighborNoMipMaps(false),
        BilinearNoMipMaps(false),
        NearestNeighborNearestMipMap(true),
        BilinearNearestMipMap(true),
        NearestNeighborLinearMipMap(true),
        Trilinear(true);

        private boolean _usesMipMapLevels;

        private MinificationFilter(boolean usesMipMapLevels) {
            this._usesMipMapLevels = usesMipMapLevels;
        }

        public boolean usesMipMapLevels() {
            return this._usesMipMapLevels;
        }
    }

    public static enum Type {
        OneDimensional,
        TwoDimensional,
        ThreeDimensional,
        CubeMap,
        Rectangle;

    }
}

