/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image;

import com.ardor3d.image.Texture;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import java.io.IOException;

public class Texture3D
extends Texture {
    private Texture.WrapMode _wrapS = Texture.WrapMode.Repeat;
    private Texture.WrapMode _wrapT = Texture.WrapMode.Repeat;
    private Texture.WrapMode _wrapR = Texture.WrapMode.Repeat;

    @Override
    public Texture createSimpleClone() {
        return this.createSimpleClone(new Texture3D());
    }

    @Override
    public Texture createSimpleClone(Texture rVal) {
        rVal.setWrap(Texture.WrapAxis.S, this._wrapS);
        rVal.setWrap(Texture.WrapAxis.T, this._wrapT);
        rVal.setWrap(Texture.WrapAxis.R, this._wrapR);
        return super.createSimpleClone(rVal);
    }

    @Override
    public void setWrap(Texture.WrapAxis axis, Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        if (axis == null) {
            throw new IllegalArgumentException("axis can not be null.");
        }
        switch (axis) {
            case S: {
                this._wrapS = mode;
                break;
            }
            case T: {
                this._wrapT = mode;
                break;
            }
            case R: {
                this._wrapR = mode;
            }
        }
    }

    @Override
    public void setWrap(Texture.WrapMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode can not be null.");
        }
        this._wrapS = mode;
        this._wrapT = mode;
        this._wrapR = mode;
    }

    @Override
    public Texture.WrapMode getWrap(Texture.WrapAxis axis) {
        switch (axis) {
            case S: {
                return this._wrapS;
            }
            case T: {
                return this._wrapT;
            }
            case R: {
                return this._wrapR;
            }
        }
        throw new IllegalArgumentException("invalid WrapAxis: " + (Object)((Object)axis));
    }

    @Override
    public Texture.Type getType() {
        return Texture.Type.ThreeDimensional;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Texture3D)) {
            return false;
        }
        Texture3D that = (Texture3D)other;
        if (this.getWrap(Texture.WrapAxis.S) != that.getWrap(Texture.WrapAxis.S)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.T) != that.getWrap(Texture.WrapAxis.T)) {
            return false;
        }
        if (this.getWrap(Texture.WrapAxis.R) != that.getWrap(Texture.WrapAxis.R)) {
            return false;
        }
        return super.equals(other);
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Enum)this._wrapS, "wrapS", (Enum)Texture.WrapMode.EdgeClamp);
        capsule.write((Enum)this._wrapT, "wrapT", (Enum)Texture.WrapMode.EdgeClamp);
        capsule.write((Enum)this._wrapR, "wrapR", (Enum)Texture.WrapMode.EdgeClamp);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._wrapS = (Texture.WrapMode)capsule.readEnum("wrapS", Texture.WrapMode.class, (Enum)Texture.WrapMode.EdgeClamp);
        this._wrapT = (Texture.WrapMode)capsule.readEnum("wrapT", Texture.WrapMode.class, (Enum)Texture.WrapMode.EdgeClamp);
        this._wrapR = (Texture.WrapMode)capsule.readEnum("wrapR", Texture.WrapMode.class, (Enum)Texture.WrapMode.EdgeClamp);
    }
}

