/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util;

import com.ardor3d.image.Image;
import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.ByteBuffer;

public abstract class ColorMipMapGenerator {
    public static Image generateColorMipMap(int size, ColorRGBA[] topColors, ColorRGBA defaultColor) {
        if (!MathUtils.isPowerOfTwo((int)size)) {
            throw new Ardor3dException("size must be power of two!");
        }
        int mips = (int)MathUtils.log((double)size, (double)2.0) + 1;
        int bufLength = size * size * 4;
        int[] mipLengths = new int[mips];
        mipLengths[0] = bufLength;
        for (int x = 1; x < mips; ++x) {
            mipLengths[x] = mipLengths[x - 1] >> 1;
            bufLength += mipLengths[x];
        }
        ByteBuffer bb = BufferUtils.createByteBuffer(bufLength);
        int[] base = new int[]{(int)(defaultColor.getRed() * 255.0f), (int)(defaultColor.getGreen() * 255.0f), (int)(defaultColor.getBlue() * 255.0f)};
        for (int x = 0; x < mips; ++x) {
            int length = mipLengths[x] >> 2;
            float div = (float)(mips - x + topColors.length) / (float)mips;
            for (int i = 0; i < length; ++i) {
                if (x >= topColors.length) {
                    bb.put((byte)((float)base[0] * div));
                    bb.put((byte)((float)base[1] * div));
                    bb.put((byte)((float)base[2] * div));
                } else {
                    bb.put((byte)(topColors[x].getRed() * 255.0f));
                    bb.put((byte)(topColors[x].getGreen() * 255.0f));
                    bb.put((byte)(topColors[x].getBlue() * 255.0f));
                }
                bb.put((byte)-1);
            }
        }
        bb.rewind();
        return new Image(ImageDataFormat.RGBA, PixelDataType.UnsignedByte, size, size, bb, mipLengths);
    }
}

