/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util;

import com.ardor3d.image.Image;
import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.functions.Function3D;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.util.geom.BufferUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public abstract class GeneratedImageFactory {
    public static Image createSolidColorImage(ReadOnlyColorRGBA color, boolean useAlpha, int side) {
        ByteBuffer data = BufferUtils.createByteBuffer(side * side * (useAlpha ? 4 : 3));
        byte[] b = new byte[useAlpha ? 4 : 3];
        b[0] = (byte)(color.getRed() * 255.0f);
        b[1] = (byte)(color.getGreen() * 255.0f);
        b[2] = (byte)(color.getBlue() * 255.0f);
        if (useAlpha) {
            b[3] = (byte)(color.getAlpha() * 255.0f);
        }
        int max = side * side;
        for (int i = 0; i < max; ++i) {
            data.put(b);
        }
        data.rewind();
        ImageDataFormat fmt = useAlpha ? ImageDataFormat.RGBA : ImageDataFormat.RGB;
        return new Image(fmt, PixelDataType.UnsignedByte, side, side, data, null);
    }

    public static Image create1DColorImage(boolean useAlpha, ReadOnlyColorRGBA ... colors) {
        ByteBuffer data = BufferUtils.createByteBuffer(colors.length * (useAlpha ? 4 : 3));
        for (int i = 0; i < colors.length; ++i) {
            ReadOnlyColorRGBA color = colors[i];
            data.put((byte)(color.getRed() * 255.0f));
            data.put((byte)(color.getGreen() * 255.0f));
            data.put((byte)(color.getBlue() * 255.0f));
            if (!useAlpha) continue;
            data.put((byte)(color.getAlpha() * 255.0f));
        }
        data.rewind();
        ImageDataFormat fmt = useAlpha ? ImageDataFormat.RGBA : ImageDataFormat.RGB;
        return new Image(fmt, PixelDataType.UnsignedByte, colors.length, 1, data, null);
    }

    public static Image createLuminance8Image(Function3D source, int width, int height, int depth) {
        return GeneratedImageFactory.createLuminance8Image(source, width, height, depth, width == 1 ? 0.0 : -1.0, width == 1 ? 0.0 : 1.0, height == 1 ? 0.0 : -1.0, height == 1 ? 0.0 : 1.0, depth == 1 ? 0.0 : -1.0, depth == 1 ? 0.0 : 1.0, -1.0, 1.0);
    }

    public static Image createLuminance8Image(Function3D source, int width, int height, int depth, double startX, double endX, double startY, double endY, double startZ, double endZ, double rangeStart, double rangeEnd) {
        double rangeDiv = 1.0 / (rangeEnd - rangeStart);
        ArrayList<ByteBuffer> dataList = new ArrayList<ByteBuffer>(depth);
        byte[] data = new byte[width * height];
        for (double z = 0.0; z < (double)depth; z += 1.0) {
            double dz = z / (double)depth * (endZ - startZ) + startZ;
            int i = 0;
            for (double y = 0.0; y < (double)height; y += 1.0) {
                double dy = y / (double)height * (endY - startY) + startY;
                for (double x = 0.0; x < (double)width; x += 1.0) {
                    double dx = x / (double)width * (endX - startX) + startX;
                    double val = source.eval(dx, dy, dz);
                    val = MathUtils.clamp((double)val, (double)rangeStart, (double)rangeEnd);
                    val = (val - rangeStart) * rangeDiv * 255.0;
                    data[i++] = (byte)val;
                }
            }
            ByteBuffer dataBuf = BufferUtils.createByteBuffer(data.length);
            dataBuf.put(data);
            dataBuf.rewind();
            dataList.add(dataBuf);
        }
        return new Image(ImageDataFormat.Luminance, PixelDataType.UnsignedByte, width, height, dataList, null);
    }

    public static Image createColorImageFromLuminance8(Image lumImage, boolean useAlpha, ReadOnlyColorRGBA ... colorTable) {
        assert (colorTable.length == 256) : "color table must be size 256.";
        ArrayList<ByteBuffer> dataList = new ArrayList<ByteBuffer>(lumImage.getDepth());
        for (int i = 0; i < lumImage.getDepth(); ++i) {
            ByteBuffer src = lumImage.getData(i);
            int size = src.capacity();
            ByteBuffer out = BufferUtils.createByteBuffer(size * (useAlpha ? 4 : 3));
            byte[] data = new byte[out.capacity()];
            int j = 0;
            for (int x = 0; x < size; ++x) {
                ReadOnlyColorRGBA c = colorTable[src.get(x) & 0xFF];
                data[j++] = (byte)(c.getRed() * 255.0f);
                data[j++] = (byte)(c.getGreen() * 255.0f);
                data[j++] = (byte)(c.getBlue() * 255.0f);
                if (!useAlpha) continue;
                data[j++] = (byte)(c.getAlpha() * 255.0f);
            }
            out.put(data);
            out.rewind();
            dataList.add(out);
        }
        return new Image(useAlpha ? ImageDataFormat.RGBA : ImageDataFormat.RGB, PixelDataType.UnsignedByte, lumImage.getWidth(), lumImage.getHeight(), dataList, null);
    }

    public static void fillInColorTable(ReadOnlyColorRGBA[] colors) {
        assert (colors.length == 256) : "colors must be length 256";
        if (colors[0] == null) {
            colors[0] = ColorRGBA.BLACK;
        }
        if (colors[255] == null) {
            colors[255] = ColorRGBA.WHITE;
        }
        int begin = 0;
        int end = GeneratedImageFactory.findNonNull(1, colors);
        for (int i = 1; i < 255; ++i) {
            if (colors[i] != null) {
                begin = i;
                end = GeneratedImageFactory.findNonNull(begin + 1, colors);
                if (end != -1) continue;
                break;
            }
            float scalar = (float)(i - begin) / (float)(end - begin);
            colors[i] = ColorRGBA.lerp((ReadOnlyColorRGBA)colors[begin], (ReadOnlyColorRGBA)colors[end], (float)scalar, null);
        }
    }

    private static int findNonNull(int start, ReadOnlyColorRGBA[] colors) {
        for (int i = start; i < colors.length; ++i) {
            if (colors[i] == null) continue;
            return i;
        }
        return -1;
    }
}

