/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util;

import com.ardor3d.image.Image;
import com.ardor3d.image.util.AbiLoader;
import com.ardor3d.image.util.ImageLoader;
import com.ardor3d.image.util.TgaLoader;
import com.ardor3d.image.util.dds.DdsLoader;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.util.resource.ResourceSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ImageLoaderUtil {
    private static final Logger logger = Logger.getLogger(ImageLoaderUtil.class.getName());
    private static ImageLoader defaultLoader;
    private static Map<String, ImageLoader> loaders;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image loadImage(ResourceSource src, boolean flipped) {
        if (src == null) {
            logger.warning("loadImage(ResourceSource, boolean): file is null, defaultTexture used.");
            return TextureState.getDefaultTextureImage();
        }
        String type = src.getType();
        if (type == null) {
            logger.warning("loadImage(ResourceSource, boolean): type is null, defaultTexture used.");
            return TextureState.getDefaultTextureImage();
        }
        try (InputStream is = src.openStream();){
            logger.log(Level.FINER, "loadImage(ResourceSource, boolean) opened stream: {0}", src);
            Image image = ImageLoaderUtil.loadImage(type, is, flipped);
            return image;
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "loadImage(ResourceSource, boolean): defaultTexture used", e);
            return TextureState.getDefaultTextureImage();
        }
    }

    public static Image loadImage(String type, InputStream stream, boolean flipped) {
        Image imageData = null;
        try {
            ImageLoader loader;
            ImageLoader imageLoader = loader = type == null ? null : loaders.get(type.toLowerCase());
            if (loader == null) {
                loader = defaultLoader;
            }
            if (loader != null) {
                imageData = loader.load(stream, flipped);
            } else {
                logger.log(Level.WARNING, "Unable to read image of type: {0}", type);
            }
            if (imageData == null) {
                logger.warning("loadImage(String, InputStream, boolean): no imageData found.  defaultTexture used.");
                imageData = TextureState.getDefaultTextureImage();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Could not load Image.", e);
            imageData = TextureState.getDefaultTextureImage();
        }
        return imageData;
    }

    public static void registerHandler(ImageLoader handler, String ... types) {
        for (String type : types) {
            loaders.put(type.toLowerCase(), handler);
        }
    }

    public static void unregisterHandler(String ... types) {
        for (String type : types) {
            loaders.remove(type.toLowerCase());
        }
    }

    public static void registerDefaultHandler(ImageLoader handler) {
        defaultLoader = handler;
    }

    static {
        loaders = Collections.synchronizedMap(new HashMap());
        ImageLoaderUtil.registerHandler(new DdsLoader(), ".DDS");
        ImageLoaderUtil.registerHandler(new TgaLoader(), ".TGA");
        ImageLoaderUtil.registerHandler(new AbiLoader(), ".ABI");
    }
}

