/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util;

import com.ardor3d.image.Texture;
import com.ardor3d.math.Matrix4;
import com.ardor3d.math.type.ReadOnlyMatrix4;
import com.ardor3d.renderer.Camera;

public class TextureProjector
extends Camera {
    private static final ReadOnlyMatrix4 BIAS = new Matrix4(0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.5, 0.5, 0.5, 1.0);

    public TextureProjector() {
        super(1, 1);
    }

    public void updateTextureMatrix(Texture texture) {
        Matrix4 texMat = Matrix4.fetchTempInstance();
        this.updateTextureMatrix(texMat);
        texture.setTextureMatrix((ReadOnlyMatrix4)texMat);
        Matrix4.releaseTempInstance((Matrix4)texMat);
    }

    public void updateTextureMatrix(Matrix4 matrixStore) {
        this.update();
        ReadOnlyMatrix4 projectorView = this.getModelViewMatrix();
        ReadOnlyMatrix4 projectorProjection = this.getProjectionMatrix();
        matrixStore.set(projectorView).multiplyLocal(projectorProjection).multiplyLocal(BIAS);
    }
}

