/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util;

import com.ardor3d.image.Image;
import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.image.util.ImageLoader;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.geom.BufferUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class TgaLoader
implements ImageLoader {
    public static final int TYPE_NO_IMAGE = 0;
    public static final int TYPE_COLORMAPPED = 1;
    public static final int TYPE_TRUECOLOR = 2;
    public static final int TYPE_BLACKANDWHITE = 3;
    public static final int TYPE_COLORMAPPED_RLE = 9;
    public static final int TYPE_TRUECOLOR_RLE = 10;
    public static final int TYPE_BLACKANDWHITE_RLE = 11;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Image load(InputStream is, boolean flip) throws IOException {
        int j;
        byte[] data;
        int alpha;
        byte red;
        int dl;
        ColorMapEntry entry;
        boolean flipH = false;
        BufferedInputStream bis = new BufferedInputStream(is, 8192);
        DataInputStream dis = new DataInputStream(bis);
        boolean createAlpha = false;
        int idLength = dis.readUnsignedByte();
        int colorMapType = dis.readUnsignedByte();
        int imageType = dis.readUnsignedByte();
        dis.readShort();
        int cMapLength = TgaLoader.flipEndian(dis.readShort());
        int cMapDepth = dis.readUnsignedByte();
        dis.readShort();
        dis.readShort();
        int width = TgaLoader.flipEndian(dis.readShort());
        short height = TgaLoader.flipEndian(dis.readShort());
        int pixelDepth = dis.readUnsignedByte();
        int imageDescriptor = dis.readUnsignedByte();
        if ((imageDescriptor & 0x20) != 0) {
            boolean bl = flip = !flip;
        }
        if ((imageDescriptor & 0x10) != 0) {
            boolean bl = flipH = !flipH;
        }
        if (idLength > 0 && (long)idLength != bis.skip(idLength)) {
            throw new IOException("Unexpected number of bytes in file - too few.");
        }
        ColorMapEntry[] cMapEntries = null;
        if (colorMapType != 0) {
            int bytesInColorMap = cMapDepth * cMapLength >> 3;
            int bitsPerColor = Math.min(cMapDepth / 3, 8);
            byte[] cMapData = new byte[bytesInColorMap];
            if (-1 == bis.read(cMapData)) {
                throw new EOFException();
            }
            if (imageType == 1 || imageType == 9) {
                cMapEntries = new ColorMapEntry[cMapLength];
                int alphaSize = cMapDepth - 3 * bitsPerColor;
                float scalar = 255.0f / (float)((int)(Math.pow(2.0, bitsPerColor) - 1.0));
                float alphaScalar = 255.0f / (float)((int)(Math.pow(2.0, alphaSize) - 1.0));
                for (int i = 0; i < cMapLength; ++i) {
                    entry = new ColorMapEntry();
                    int offset = cMapDepth * i;
                    entry.red = (byte)((float)TgaLoader.getBitsAsByte(cMapData, offset, bitsPerColor) * scalar);
                    entry.green = (byte)((float)TgaLoader.getBitsAsByte(cMapData, offset + bitsPerColor, bitsPerColor) * scalar);
                    entry.blue = (byte)((float)TgaLoader.getBitsAsByte(cMapData, offset + 2 * bitsPerColor, bitsPerColor) * scalar);
                    entry.alpha = alphaSize <= 0 ? (byte)-1 : (byte)((float)TgaLoader.getBitsAsByte(cMapData, offset + 3 * bitsPerColor, alphaSize) * alphaScalar);
                    cMapEntries[i] = entry;
                }
            }
        }
        byte[] rawData = null;
        if (pixelDepth == 32) {
            rawData = new byte[width * height * 4];
            dl = 4;
            createAlpha = true;
        } else {
            rawData = new byte[width * height * 3];
            dl = 3;
        }
        int rawDataIndex = 0;
        if (imageType == 2) {
            red = 0;
            byte green = 0;
            byte blue = 0;
            alpha = 0;
            if (pixelDepth == 16) {
                data = new byte[2];
                float scalar = 8.225806f;
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j2 = 0; j2 < width; ++j2) {
                        data[1] = dis.readByte();
                        data[0] = dis.readByte();
                        rawData[rawDataIndex++] = (byte)((float)TgaLoader.getBitsAsByte(data, 1, 5) * 8.225806f);
                        rawData[rawDataIndex++] = (byte)((float)TgaLoader.getBitsAsByte(data, 6, 5) * 8.225806f);
                        rawData[rawDataIndex++] = (byte)((float)TgaLoader.getBitsAsByte(data, 11, 5) * 8.225806f);
                        if (!createAlpha) continue;
                        alpha = TgaLoader.getBitsAsByte(data, 0, 1);
                        if (alpha == 1) {
                            alpha = -1;
                        }
                        rawData[rawDataIndex++] = alpha;
                    }
                }
            } else if (pixelDepth == 24) {
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        if (!createAlpha) continue;
                        rawData[rawDataIndex++] = -1;
                    }
                }
            } else {
                if (pixelDepth != 32) throw new Ardor3dException("Unsupported TGA true color depth: " + pixelDepth);
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        blue = dis.readByte();
                        green = dis.readByte();
                        red = dis.readByte();
                        alpha = dis.readByte();
                        rawData[rawDataIndex++] = red;
                        rawData[rawDataIndex++] = green;
                        rawData[rawDataIndex++] = blue;
                        rawData[rawDataIndex++] = alpha;
                    }
                }
            }
        } else if (imageType == 10) {
            red = 0;
            byte green = 0;
            byte blue = 0;
            alpha = 0;
            if (pixelDepth == 32) {
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                rawData[rawDataIndex++] = alpha;
                            }
                            continue;
                        }
                        j += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            alpha = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            rawData[rawDataIndex++] = alpha;
                        }
                    }
                }
            } else if (pixelDepth == 24) {
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (j = 0; j < width; ++j) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j += (count &= 0x7F);
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                if (!createAlpha) continue;
                                rawData[rawDataIndex++] = -1;
                            }
                            continue;
                        }
                        j += count;
                        while (count-- >= 0) {
                            blue = dis.readByte();
                            green = dis.readByte();
                            red = dis.readByte();
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            if (!createAlpha) continue;
                            rawData[rawDataIndex++] = -1;
                        }
                    }
                }
            } else {
                if (pixelDepth != 16) throw new Ardor3dException("Unsupported TGA true color depth: " + pixelDepth);
                data = new byte[2];
                float scalar = 8.225806f;
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j3 = 0; j3 < width; ++j3) {
                        int count = dis.readByte();
                        if ((count & 0x80) != 0) {
                            j3 += (count &= 0x7F);
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)TgaLoader.getBitsAsByte(data, 1, 5) * 8.225806f);
                            green = (byte)((float)TgaLoader.getBitsAsByte(data, 6, 5) * 8.225806f);
                            red = (byte)((float)TgaLoader.getBitsAsByte(data, 11, 5) * 8.225806f);
                            while (count-- >= 0) {
                                rawData[rawDataIndex++] = red;
                                rawData[rawDataIndex++] = green;
                                rawData[rawDataIndex++] = blue;
                                if (!createAlpha) continue;
                                rawData[rawDataIndex++] = -1;
                            }
                            continue;
                        }
                        j3 += count;
                        while (count-- >= 0) {
                            data[1] = dis.readByte();
                            data[0] = dis.readByte();
                            blue = (byte)((float)TgaLoader.getBitsAsByte(data, 1, 5) * 8.225806f);
                            green = (byte)((float)TgaLoader.getBitsAsByte(data, 6, 5) * 8.225806f);
                            red = (byte)((float)TgaLoader.getBitsAsByte(data, 11, 5) * 8.225806f);
                            rawData[rawDataIndex++] = red;
                            rawData[rawDataIndex++] = green;
                            rawData[rawDataIndex++] = blue;
                            if (!createAlpha) continue;
                            rawData[rawDataIndex++] = -1;
                        }
                    }
                }
            }
        } else if (imageType == 1 && cMapEntries != null) {
            int index;
            int bytesPerIndex = pixelDepth / 8;
            if (bytesPerIndex == 1) {
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j4 = 0; j4 < width; ++j4) {
                        index = dis.readUnsignedByte();
                        if (index >= cMapEntries.length || index < 0) {
                            throw new Ardor3dException("TGA: Invalid color map entry referenced: " + index);
                        }
                        entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.red;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.blue;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            } else {
                if (bytesPerIndex != 2) throw new Ardor3dException("TGA: unknown colormap indexing size used: " + bytesPerIndex);
                for (int i = 0; i <= height - 1; ++i) {
                    if (!flip) {
                        rawDataIndex = (height - 1 - i) * width * dl;
                    }
                    for (int j5 = 0; j5 < width; ++j5) {
                        index = TgaLoader.flipEndian(dis.readShort());
                        if (index >= cMapEntries.length || index < 0) {
                            throw new Ardor3dException("TGA: Invalid color map entry referenced: " + index);
                        }
                        entry = cMapEntries[index];
                        rawData[rawDataIndex++] = entry.red;
                        rawData[rawDataIndex++] = entry.green;
                        rawData[rawDataIndex++] = entry.blue;
                        if (dl != 4) continue;
                        rawData[rawDataIndex++] = entry.alpha;
                    }
                }
            }
        }
        ByteBuffer scratch = BufferUtils.createByteBuffer(rawData.length);
        scratch.clear();
        scratch.put(rawData);
        scratch.rewind();
        Image textureImage = new Image();
        if (dl == 4) {
            textureImage.setDataFormat(ImageDataFormat.RGBA);
        } else {
            textureImage.setDataFormat(ImageDataFormat.RGB);
        }
        textureImage.setDataType(PixelDataType.UnsignedByte);
        textureImage.setWidth(width);
        textureImage.setHeight(height);
        textureImage.setData(scratch);
        return textureImage;
    }

    private static byte getBitsAsByte(byte[] data, int offset, int length) {
        int offsetBytes = offset / 8;
        int indexBits = offset % 8;
        int rVal = 0;
        int i = length;
        while (--i >= 0) {
            int test;
            byte b = data[offsetBytes];
            int n = test = indexBits == 7 ? 1 : 2 << 6 - indexBits;
            if ((b & test) != 0) {
                rVal = i == 0 ? ++rVal : (rVal += 2 << i - 1);
            }
            if (++indexBits != 8) continue;
            indexBits = 0;
            ++offsetBytes;
        }
        return (byte)rVal;
    }

    private static short flipEndian(short signedShort) {
        int input = signedShort & 0xFFFF;
        return (short)(input << 8 | (input & 0xFF00) >>> 8);
    }

    private static class ColorMapEntry {
        byte red;
        byte green;
        byte blue;
        byte alpha;

        private ColorMapEntry() {
        }

        public String toString() {
            return "entry: " + this.red + "," + this.green + "," + this.blue + "," + this.alpha;
        }
    }
}

