/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util.dds;

import com.ardor3d.image.util.dds.DdsPixelFormat;
import com.ardor3d.image.util.dds.DdsUtils;
import com.ardor3d.util.LittleEndianDataInput;
import java.io.IOException;
import java.util.logging.Logger;

class DdsHeader {
    private static final Logger logger = Logger.getLogger(DdsHeader.class.getName());
    static final int DDSD_CAPS = 1;
    static final int DDSD_HEIGHT = 2;
    static final int DDSD_WIDTH = 4;
    static final int DDSD_PITCH = 8;
    static final int DDSD_PIXELFORMAT = 4096;
    static final int DDSD_MIPMAPCOUNT = 131072;
    static final int DDSD_LINEARSIZE = 524288;
    static final int DDSD_DEPTH = 0x800000;
    static final int DDSCAPS_COMPLEX = 8;
    static final int DDSCAPS_MIPMAP = 0x400000;
    static final int DDSCAPS_TEXTURE = 4096;
    static final int DDSCAPS2_CUBEMAP = 512;
    static final int DDSCAPS2_CUBEMAP_POSITIVEX = 1024;
    static final int DDSCAPS2_CUBEMAP_NEGATIVEX = 2048;
    static final int DDSCAPS2_CUBEMAP_POSITIVEY = 4096;
    static final int DDSCAPS2_CUBEMAP_NEGATIVEY = 8192;
    static final int DDSCAPS2_CUBEMAP_POSITIVEZ = 16384;
    static final int DDSCAPS2_CUBEMAP_NEGATIVEZ = 32768;
    static final int DDSCAPS2_VOLUME = 0x200000;
    int dwSize;
    int dwFlags;
    int dwHeight;
    int dwWidth;
    int dwLinearSize;
    int dwDepth;
    int dwMipMapCount;
    int dwAlphaBitDepth;
    int[] dwReserved1 = new int[10];
    DdsPixelFormat ddpf;
    int dwCaps;
    int dwCaps2;
    int dwCaps3;
    int dwCaps4;
    int dwTextureStage;

    DdsHeader() {
    }

    static DdsHeader read(LittleEndianDataInput in) throws IOException {
        DdsHeader header = new DdsHeader();
        header.dwSize = in.readInt();
        if (header.dwSize != 124) {
            throw new Error("invalid dds header size: " + header.dwSize);
        }
        header.dwFlags = in.readInt();
        header.dwHeight = in.readInt();
        header.dwWidth = in.readInt();
        header.dwLinearSize = in.readInt();
        header.dwDepth = in.readInt();
        header.dwMipMapCount = in.readInt();
        header.dwAlphaBitDepth = in.readInt();
        for (int i = 0; i < header.dwReserved1.length; ++i) {
            header.dwReserved1[i] = in.readInt();
        }
        header.ddpf = DdsPixelFormat.read(in);
        header.dwCaps = in.readInt();
        header.dwCaps2 = in.readInt();
        header.dwCaps3 = in.readInt();
        header.dwCaps4 = in.readInt();
        header.dwTextureStage = in.readInt();
        int expectedMipmaps = 1 + (int)Math.ceil(Math.log(Math.max(header.dwHeight, header.dwWidth)) / Math.log(2.0));
        if (DdsUtils.isSet(header.dwCaps, 0x400000)) {
            if (!DdsUtils.isSet(header.dwFlags, 131072)) {
                header.dwMipMapCount = expectedMipmaps;
            } else if (header.dwMipMapCount != expectedMipmaps) {
                logger.fine("Got " + header.dwMipMapCount + " mipmaps, expected " + expectedMipmaps);
            }
        } else {
            header.dwMipMapCount = 1;
        }
        return header;
    }
}

