/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util.dds;

import com.ardor3d.util.LittleEndianDataInput;
import java.io.IOException;

class DdsPixelFormat {
    static final int DDPF_ALPHAPIXELS = 1;
    static final int DDPF_ALPHA = 2;
    static final int DDPF_FOURCC = 4;
    static final int DDPF_RGB = 64;
    static final int DDPF_YUV = 512;
    static final int DDPF_LUMINANCE = 131072;
    int dwSize;
    int dwFlags;
    int dwFourCC;
    int dwRGBBitCount;
    int dwRBitMask;
    int dwGBitMask;
    int dwBBitMask;
    int dwABitMask;

    DdsPixelFormat() {
    }

    static DdsPixelFormat read(LittleEndianDataInput in) throws IOException {
        DdsPixelFormat format = new DdsPixelFormat();
        format.dwSize = in.readInt();
        if (format.dwSize != 32) {
            throw new Error("invalid pixel format size: " + format.dwSize);
        }
        format.dwFlags = in.readInt();
        format.dwFourCC = in.readInt();
        format.dwRGBBitCount = in.readInt();
        format.dwRBitMask = in.readInt();
        format.dwGBitMask = in.readInt();
        format.dwBBitMask = in.readInt();
        format.dwABitMask = in.readInt();
        return format;
    }
}

