/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.image.util.dds;

import com.ardor3d.image.ImageDataFormat;

public class DdsUtils {
    private static final int ThreeBitMask = 7;

    static final int shiftCount(int mask) {
        if (mask == 0) {
            return 0;
        }
        int i = 0;
        while ((mask & 1) == 0) {
            mask >>= 1;
            if (++i <= 32) continue;
            throw new Error(Integer.toHexString(mask));
        }
        return i;
    }

    static final boolean isSet(int value, int bitMask) {
        return (value & bitMask) == bitMask;
    }

    static final int getInt(String string) {
        return DdsUtils.getInt(string.getBytes());
    }

    static final int getInt(byte[] bytes) {
        int rVal = 0;
        rVal |= (bytes[0] & 0xFF) << 0;
        if (bytes.length > 1) {
            rVal |= (bytes[1] & 0xFF) << 8;
        }
        if (bytes.length > 2) {
            rVal |= (bytes[2] & 0xFF) << 16;
        }
        if (bytes.length > 3) {
            rVal |= (bytes[3] & 0xFF) << 24;
        }
        return rVal;
    }

    public static byte[] flipDXT(byte[] rawData, int width, int height, ImageDataFormat format) {
        byte[] returnData = new byte[rawData.length];
        int blocksPerColumn = width + 3 >> 2;
        int blocksPerRow = height + 3 >> 2;
        int bytesPerBlock = format.getComponents() * 8;
        for (int sourceRow = 0; sourceRow < blocksPerRow; ++sourceRow) {
            int targetRow = blocksPerRow - sourceRow - 1;
            block7: for (int column = 0; column < blocksPerColumn; ++column) {
                int target = (targetRow * blocksPerColumn + column) * bytesPerBlock;
                int source = (sourceRow * blocksPerColumn + column) * bytesPerBlock;
                switch (format) {
                    case PrecompressedDXT1: 
                    case PrecompressedDXT1A: 
                    case PrecompressedLATC_L: {
                        System.arraycopy(rawData, source, returnData, target, 4);
                        returnData[target + 4] = rawData[source + 7];
                        returnData[target + 5] = rawData[source + 6];
                        returnData[target + 6] = rawData[source + 5];
                        returnData[target + 7] = rawData[source + 4];
                        continue block7;
                    }
                    case PrecompressedDXT3: {
                        returnData[target + 0] = rawData[source + 6];
                        returnData[target + 1] = rawData[source + 7];
                        returnData[target + 2] = rawData[source + 4];
                        returnData[target + 3] = rawData[source + 5];
                        returnData[target + 4] = rawData[source + 2];
                        returnData[target + 5] = rawData[source + 3];
                        returnData[target + 6] = rawData[source + 0];
                        returnData[target + 7] = rawData[source + 1];
                        System.arraycopy(rawData, source + 8, returnData, target + 8, 4);
                        returnData[target + 12] = rawData[source + 15];
                        returnData[target + 13] = rawData[source + 14];
                        returnData[target + 14] = rawData[source + 13];
                        returnData[target + 15] = rawData[source + 12];
                        continue block7;
                    }
                    case PrecompressedDXT5: {
                        returnData[target + 0] = rawData[source + 0];
                        returnData[target + 1] = rawData[source + 1];
                        DdsUtils.getBytesFromUInt24(returnData, target + 5, DdsUtils.flipUInt24(DdsUtils.getUInt24(rawData, source + 2)));
                        DdsUtils.getBytesFromUInt24(returnData, target + 2, DdsUtils.flipUInt24(DdsUtils.getUInt24(rawData, source + 5)));
                        System.arraycopy(rawData, source + 8, returnData, target + 8, 4);
                        returnData[target + 12] = rawData[source + 15];
                        returnData[target + 13] = rawData[source + 14];
                        returnData[target + 14] = rawData[source + 13];
                        returnData[target + 15] = rawData[source + 12];
                        continue block7;
                    }
                    case PrecompressedLATC_LA: {
                        System.arraycopy(rawData, source, returnData, target, 4);
                        returnData[target + 4] = rawData[source + 7];
                        returnData[target + 5] = rawData[source + 6];
                        returnData[target + 6] = rawData[source + 5];
                        returnData[target + 7] = rawData[source + 4];
                        System.arraycopy(rawData, source + 8, returnData, target + 8, 4);
                        returnData[target + 12] = rawData[source + 15];
                        returnData[target + 13] = rawData[source + 14];
                        returnData[target + 14] = rawData[source + 13];
                        returnData[target + 15] = rawData[source + 12];
                    }
                }
            }
        }
        return returnData;
    }

    private static int getUInt24(byte[] input, int offset) {
        int result = 0;
        result |= (input[offset + 0] & 0xFF) << 0;
        result |= (input[offset + 1] & 0xFF) << 8;
        return result |= (input[offset + 2] & 0xFF) << 16;
    }

    private static void getBytesFromUInt24(byte[] input, int offset, int uint24) {
        input[offset + 0] = (byte)(uint24 & 0xFF);
        input[offset + 1] = (byte)((uint24 & 0xFF00) >> 8);
        input[offset + 2] = (byte)((uint24 & 0xFF0000) >> 16);
    }

    private static int flipUInt24(int uint24) {
        byte[][] threeBits = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            threeBits[i] = new byte[4];
        }
        threeBits[0][0] = (byte)(uint24 & 7);
        threeBits[0][1] = (byte)((uint24 >>= 3) & 7);
        threeBits[0][2] = (byte)((uint24 >>= 3) & 7);
        threeBits[0][3] = (byte)((uint24 >>= 3) & 7);
        threeBits[1][0] = (byte)((uint24 >>= 3) & 7);
        threeBits[1][1] = (byte)((uint24 >>= 3) & 7);
        threeBits[1][2] = (byte)((uint24 >>= 3) & 7);
        threeBits[1][3] = (byte)((uint24 >>= 3) & 7);
        int result = 0;
        result |= threeBits[1][0] << 0;
        result |= threeBits[1][1] << 3;
        result |= threeBits[1][2] << 6;
        result |= threeBits[1][3] << 9;
        result |= threeBits[0][0] << 12;
        result |= threeBits[0][1] << 15;
        result |= threeBits[0][2] << 18;
        return result |= threeBits[0][3] << 21;
    }
}

