/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.input.ControllerEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ControllerState {
    public static final ControllerState NOTHING = new ControllerState(0);
    protected final Map<String, Map<String, Float>> _controllerStates = new LinkedHashMap<String, Map<String, Float>>();
    protected final List<ControllerEvent> _eventsSinceLastState = new ArrayList<ControllerEvent>();

    protected ControllerState(int ignore) {
    }

    public ControllerState() {
        NOTHING.duplicateStates(this._controllerStates);
    }

    public ControllerState(ControllerState previous) {
        if (previous != null) {
            previous.duplicateStates(this._controllerStates);
        } else {
            NOTHING.duplicateStates(this._controllerStates);
        }
    }

    public void set(String controllerName, String componentName, float value) {
        Map<Object, Object> controllerState = null;
        if (this._controllerStates.containsKey(controllerName)) {
            controllerState = this._controllerStates.get(controllerName);
        } else {
            controllerState = new LinkedHashMap();
            this._controllerStates.put(controllerName, controllerState);
        }
        controllerState.put(componentName, Float.valueOf(value));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ControllerState) {
            ControllerState other = (ControllerState)obj;
            return other._controllerStates.equals(this._controllerStates);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this._controllerStates);
    }

    public String toString() {
        StringBuilder stateString = new StringBuilder("ControllerState: ");
        for (String controllerStateKey : this._controllerStates.keySet()) {
            Map<String, Float> state = this._controllerStates.get(controllerStateKey);
            stateString.append('[').append(controllerStateKey);
            for (String stateKey : state.keySet()) {
                stateString.append('[').append(stateKey).append(':').append(state.get(stateKey)).append(']');
            }
            stateString.append(']');
        }
        return stateString.toString();
    }

    public ControllerState snapshot() {
        ControllerState snapshot = new ControllerState();
        this.duplicateStates(snapshot._controllerStates);
        snapshot._eventsSinceLastState.addAll(this._eventsSinceLastState);
        return snapshot;
    }

    private void duplicateStates(Map<String, Map<String, Float>> store) {
        store.clear();
        for (Map.Entry<String, Map<String, Float>> entry : this._controllerStates.entrySet()) {
            store.put(entry.getKey(), new LinkedHashMap<String, Float>(entry.getValue()));
        }
    }

    public void addEvent(ControllerEvent event) {
        this._eventsSinceLastState.add(event);
        this.set(event.getControllerName(), event.getComponentName(), event.getValue());
    }

    public List<ControllerEvent> getEvents() {
        Collections.sort(this._eventsSinceLastState, new Comparator<ControllerEvent>(){

            @Override
            public int compare(ControllerEvent o1, ControllerEvent o2) {
                return (int)(o2.getNanos() - o1.getNanos());
            }
        });
        return Collections.unmodifiableList(this._eventsSinceLastState);
    }

    public void clearEvents() {
        this._eventsSinceLastState.clear();
    }

    public List<String> getControllerNames() {
        return new ArrayList<String>(this._controllerStates.keySet());
    }

    public List<String> getControllerComponentNames(String controller) {
        return new ArrayList<String>(this._controllerStates.get(controller).keySet());
    }

    public Map<String, Float> getControllerComponentValues(String controller) {
        return this._controllerStates.get(controller);
    }

    public float getComponentValue(String controller, String component) {
        if (!this._controllerStates.containsKey(controller) || !this._controllerStates.get(controller).containsKey(component)) {
            return 0.0f;
        }
        return this._controllerStates.get(controller).get(component).floatValue();
    }
}

