/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.input.ControllerState;
import com.ardor3d.input.KeyboardState;
import com.ardor3d.input.MouseState;

public class InputState {
    public static final InputState LOST_FOCUS = new InputState(KeyboardState.NOTHING, MouseState.NOTHING, ControllerState.NOTHING);
    public static final InputState EMPTY = new InputState(KeyboardState.NOTHING, MouseState.NOTHING, ControllerState.NOTHING);
    private final KeyboardState keyboardState;
    private final MouseState mouseState;
    private final ControllerState controllerState;

    public InputState(KeyboardState keyboardState, MouseState mouseState, ControllerState controllerState) {
        if (keyboardState == null) {
            throw new NullPointerException("Keyboard state");
        }
        if (mouseState == null) {
            throw new NullPointerException("Mouse state");
        }
        if (controllerState == null) {
            throw new NullPointerException("Controller state");
        }
        this.keyboardState = keyboardState;
        this.mouseState = mouseState;
        this.controllerState = controllerState;
    }

    public KeyboardState getKeyboardState() {
        return this.keyboardState;
    }

    public MouseState getMouseState() {
        return this.mouseState;
    }

    public ControllerState getControllerState() {
        return this.controllerState;
    }

    public String toString() {
        return "InputState{keyboardState=" + this.keyboardState + ", mouseState=" + this.mouseState + ", controllerState=" + this.controllerState + '}';
    }
}

