/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.input.Key;
import com.ardor3d.input.KeyEvent;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class KeyboardState {
    public static final KeyboardState NOTHING = new KeyboardState(EnumSet.noneOf(Key.class), KeyEvent.NOTHING);
    private final EnumSet<Key> _keysDown;
    private final Set<Key> _keysDownView;
    private final KeyEvent _keyEvent;

    public KeyboardState(EnumSet<Key> keysDown, KeyEvent keyEvent) {
        this._keysDown = keysDown;
        this._keyEvent = keyEvent;
        this._keysDownView = Collections.unmodifiableSet(keysDown);
    }

    public boolean isDown(Key key) {
        return this._keysDown.contains((Object)key);
    }

    public boolean isAllDown(Key ... keys) {
        for (Key key : keys) {
            if (this._keysDown.contains((Object)key)) continue;
            return false;
        }
        return true;
    }

    public boolean isAtLeastOneDown(Key ... keys) {
        for (Key key : keys) {
            if (!this._keysDown.contains((Object)key)) continue;
            return true;
        }
        return false;
    }

    public Set<Key> getKeysDown() {
        return this._keysDownView;
    }

    public KeyEvent getKeyEvent() {
        return this._keyEvent;
    }

    public EnumSet<Key> getKeysReleasedSince(KeyboardState previous) {
        EnumSet<Key> result = EnumSet.copyOf(previous._keysDown);
        result.removeAll(this._keysDown);
        return result;
    }

    public EnumSet<Key> getKeysPressedSince(KeyboardState previous) {
        EnumSet<Key> result = EnumSet.copyOf(this._keysDown);
        result.removeAll(previous._keysDown);
        return result;
    }

    public EnumSet<Key> getKeysHeldSince(KeyboardState previous) {
        EnumSet<Key> result = EnumSet.copyOf(this._keysDown);
        result.retainAll(previous._keysDown);
        return result;
    }

    public String toString() {
        return "KeyboardState{_keysDown=" + this._keysDown + ", _keyEvent=" + this._keyEvent + '}';
    }
}

