/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.image.Image;
import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.util.geom.BufferUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class MouseCursor {
    public static final MouseCursor SYSTEM_DEFAULT = new MouseCursor("system default", new Image(ImageDataFormat.RGBA, PixelDataType.UnsignedByte, 1, 1, BufferUtils.createByteBuffer(4), null), 0, 0);
    private final String _name;
    private final Image _image;
    private final int _hotspotX;
    private final int _hotspotY;

    public MouseCursor(String name, Image image, int hotspotX, int hotspotY) {
        this._name = name;
        this._image = image;
        this._hotspotX = hotspotX;
        this._hotspotY = hotspotY;
        Preconditions.checkArgument((hotspotX >= 0 && hotspotX < image.getWidth() ? 1 : 0) != 0, (String)("hotspot X is out of bounds: 0 <= %s  < " + image.getWidth()), (Object[])new Object[]{hotspotX});
        Preconditions.checkArgument((hotspotY >= 0 && hotspotY < image.getHeight() ? 1 : 0) != 0, (String)("hotspot Y is out of bounds: 0 <= %s  < " + image.getHeight()), (Object[])new Object[]{hotspotY});
    }

    public String getName() {
        return this._name;
    }

    public Image getImage() {
        return this._image;
    }

    public int getWidth() {
        return this._image.getWidth();
    }

    public int getHeight() {
        return this._image.getHeight();
    }

    public int getHotspotX() {
        return this._hotspotX;
    }

    public int getHotspotY() {
        return this._hotspotY;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MouseCursor that = (MouseCursor)o;
        if (this._hotspotX != that._hotspotX) {
            return false;
        }
        if (this._hotspotY != that._hotspotY) {
            return false;
        }
        if (!Objects.equals(this._image, that._image)) {
            return false;
        }
        return Objects.equals(this._name, that._name);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getImage(), this.getHotspotX(), this.getHotspotY());
    }
}

