/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.input.ButtonState;
import com.ardor3d.input.MouseButton;
import com.google.common.collect.EnumMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public class MouseState {
    public static final MouseState NOTHING = new MouseState(0, 0, 0, 0, 0, null, null);
    public static long CLICK_TIME_MS = 500L;
    private final int _x;
    private final int _y;
    private final int _dx;
    private final int _dy;
    private final int _dwheel;
    private final ImmutableMap<MouseButton, ButtonState> _buttonStates;
    private final ImmutableMultiset<MouseButton> _clickCounts;

    public MouseState(int x, int y, int dx, int dy, int dwheel, EnumMap<MouseButton, ButtonState> buttonStates, Multiset<MouseButton> clicks) {
        ImmutableMap.Builder builder;
        this._x = x;
        this._y = y;
        this._dx = dx;
        this._dy = dy;
        this._dwheel = dwheel;
        if (buttonStates != null) {
            builder = ImmutableMap.builder();
            this._buttonStates = builder.putAll(buttonStates).build();
        } else {
            this._buttonStates = ImmutableMap.of();
        }
        if (clicks != null) {
            builder = ImmutableMultiset.builder();
            this._clickCounts = builder.addAll(clicks).build();
        } else {
            this._clickCounts = ImmutableMultiset.of();
        }
    }

    public int getX() {
        return this._x;
    }

    public int getY() {
        return this._y;
    }

    public int getDx() {
        return this._dx;
    }

    public int getDy() {
        return this._dy;
    }

    public int getDwheel() {
        return this._dwheel;
    }

    public boolean hasButtonState(ButtonState state) {
        return this._buttonStates.containsValue((Object)state);
    }

    public boolean hasButtonState(MouseButton button) {
        return this._buttonStates.containsKey((Object)button);
    }

    public EnumMap<MouseButton, ButtonState> getButtonStates() {
        return this.getButtonStates(null);
    }

    public EnumMap<MouseButton, ButtonState> getButtonStates(EnumMap<MouseButton, ButtonState> store) {
        EnumMap<MouseButton, ButtonState> rVal = store;
        if (store == null) {
            rVal = new EnumMap(MouseButton.class);
        }
        rVal.clear();
        rVal.putAll((Map<MouseButton, ButtonState>)this._buttonStates);
        return rVal;
    }

    public ButtonState getButtonState(MouseButton button) {
        if (this._buttonStates.containsKey((Object)button)) {
            return (ButtonState)((Object)this._buttonStates.get((Object)button));
        }
        return ButtonState.UP;
    }

    public EnumSet<MouseButton> getButtonsReleasedSince(MouseState previous) {
        EnumSet<MouseButton> result = EnumSet.noneOf(MouseButton.class);
        for (MouseButton button : MouseButton.values()) {
            if (previous.getButtonState(button) != ButtonState.DOWN || this.getButtonState(button) == ButtonState.DOWN) continue;
            result.add(button);
        }
        return result;
    }

    public EnumSet<MouseButton> getButtonsPressedSince(MouseState previous) {
        EnumSet<MouseButton> result = EnumSet.noneOf(MouseButton.class);
        for (MouseButton button : MouseButton.values()) {
            if (this.getButtonState(button) != ButtonState.DOWN || previous.getButtonState(button) == ButtonState.DOWN) continue;
            result.add(button);
        }
        return result;
    }

    public Multiset<MouseButton> getClickCounts() {
        if (this._clickCounts.isEmpty()) {
            return EnumMultiset.create(MouseButton.class);
        }
        return EnumMultiset.create(this._clickCounts);
    }

    public Multiset<MouseButton> getClickCounts(EnumMultiset<MouseButton> store) {
        EnumMultiset<MouseButton> rVal = store;
        if (store == null) {
            if (this._clickCounts.isEmpty()) {
                return EnumMultiset.create(MouseButton.class);
            }
            return EnumMultiset.create(this._clickCounts);
        }
        rVal.clear();
        rVal.addAll(this._clickCounts);
        return rVal;
    }

    public int getClickCount(MouseButton button) {
        return this._clickCounts.count((Object)button);
    }

    public EnumSet<MouseButton> getButtonsClicked() {
        EnumSet<MouseButton> result = EnumSet.noneOf(MouseButton.class);
        for (MouseButton button : MouseButton.values()) {
            if (this.getClickCount(button) == 0) continue;
            result.add(button);
        }
        return result;
    }

    public String toString() {
        return "MouseState{x=" + this._x + ", y=" + this._y + ", dx=" + this._dx + ", dy=" + this._dy + ", dwheel=" + this._dwheel + ", buttonStates=" + this._buttonStates.toString() + ", clickCounts=" + this._clickCounts.toString() + '}';
    }
}

