/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input;

import com.ardor3d.input.ControllerEvent;
import com.ardor3d.input.ControllerState;
import com.ardor3d.input.ControllerWrapper;
import com.ardor3d.input.FocusWrapper;
import com.ardor3d.input.InputState;
import com.ardor3d.input.Key;
import com.ardor3d.input.KeyEvent;
import com.ardor3d.input.KeyState;
import com.ardor3d.input.KeyboardState;
import com.ardor3d.input.KeyboardWrapper;
import com.ardor3d.input.MouseState;
import com.ardor3d.input.MouseWrapper;
import com.ardor3d.input.logical.DummyControllerWrapper;
import com.ardor3d.input.logical.DummyFocusWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.PeekingIterator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class PhysicalLayer {
    private static final Logger logger = Logger.getLogger(PhysicalLayer.class.getName());
    private final BlockingQueue<InputState> _stateQueue;
    private final KeyboardWrapper _keyboardWrapper;
    private final MouseWrapper _mouseWrapper;
    private final FocusWrapper _focusWrapper;
    private final ControllerWrapper _controllerWrapper;
    private KeyboardState _currentKeyboardState;
    private MouseState _currentMouseState;
    private ControllerState _currentControllerState;
    private boolean _inited = false;
    private static final long MAX_INPUT_POLL_TIME = TimeUnit.SECONDS.toNanos(2L);
    private static final List<InputState> EMPTY_LIST = ImmutableList.of();

    public PhysicalLayer(KeyboardWrapper keyboardWrapper, MouseWrapper mouseWrapper) {
        this(keyboardWrapper, mouseWrapper, DummyControllerWrapper.INSTANCE, DummyFocusWrapper.INSTANCE);
    }

    public PhysicalLayer(KeyboardWrapper keyboardWrapper, MouseWrapper mouseWrapper, FocusWrapper focusWrapper) {
        this(keyboardWrapper, mouseWrapper, DummyControllerWrapper.INSTANCE, focusWrapper);
    }

    public PhysicalLayer(KeyboardWrapper keyboardWrapper, MouseWrapper mouseWrapper, ControllerWrapper controllerWrapper) {
        this(keyboardWrapper, mouseWrapper, controllerWrapper, DummyFocusWrapper.INSTANCE);
    }

    public PhysicalLayer(KeyboardWrapper keyboardWrapper, MouseWrapper mouseWrapper, ControllerWrapper controllerWrapper, FocusWrapper focusWrapper) {
        this._keyboardWrapper = keyboardWrapper;
        this._mouseWrapper = mouseWrapper;
        this._focusWrapper = focusWrapper;
        this._controllerWrapper = controllerWrapper;
        this._stateQueue = new LinkedBlockingQueue<InputState>();
        this._currentKeyboardState = KeyboardState.NOTHING;
        this._currentMouseState = MouseState.NOTHING;
        this._currentControllerState = ControllerState.NOTHING;
    }

    public void readState() {
        block4: {
            if (!this._inited) {
                this.init();
            }
            KeyboardState oldKeyState = this._currentKeyboardState;
            if (this._currentMouseState.getDwheel() != 0 || this._currentMouseState.getDx() != 0 || this._currentMouseState.getDy() != 0) {
                this._currentMouseState = new MouseState(this._currentMouseState.getX(), this._currentMouseState.getY(), 0, 0, 0, this._currentMouseState.getButtonStates(), this._currentMouseState.getClickCounts());
            }
            MouseState oldMouseState = this._currentMouseState;
            ControllerState oldControllerState = this._currentControllerState;
            long loopExitTime = System.nanoTime() + MAX_INPUT_POLL_TIME;
            do {
                this.readKeyboardState();
                this.readMouseState();
                this.readControllerState();
                if (oldKeyState.equals(this._currentKeyboardState) && oldMouseState.equals(this._currentMouseState) && oldControllerState.equals(this._currentControllerState)) break block4;
                this._stateQueue.add(new InputState(this._currentKeyboardState, this._currentMouseState, this._currentControllerState));
                oldKeyState = this._currentKeyboardState;
                oldMouseState = this._currentMouseState;
                oldControllerState = this._currentControllerState;
            } while (System.nanoTime() <= loopExitTime);
            logger.severe("Spent too long collecting input data, this is probably an input system bug");
        }
        if (this._focusWrapper.getAndClearFocusLost()) {
            this.lostFocus();
        }
    }

    private void readControllerState() {
        PeekingIterator<ControllerEvent> eventIterator = this._controllerWrapper.getEvents();
        if (eventIterator.hasNext()) {
            this._currentControllerState = new ControllerState(this._currentControllerState);
            while (eventIterator.hasNext()) {
                ControllerEvent event = (ControllerEvent)eventIterator.next();
                this._currentControllerState.addEvent(event);
            }
        }
    }

    private void readMouseState() {
        PeekingIterator<MouseState> eventIterator = this._mouseWrapper.getEvents();
        if (eventIterator.hasNext()) {
            this._currentMouseState = (MouseState)eventIterator.next();
        }
    }

    private void readKeyboardState() {
        EnumSet<Key> keysDown;
        PeekingIterator<KeyEvent> eventIterator = this._keyboardWrapper.getEvents();
        if (!eventIterator.hasNext()) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)eventIterator.next();
        EnumSet<Key> enumSet = keysDown = this._currentKeyboardState.getKeysDown().isEmpty() ? EnumSet.noneOf(Key.class) : EnumSet.copyOf(this._currentKeyboardState.getKeysDown());
        if (keyEvent.getState() == KeyState.DOWN) {
            keysDown.add(keyEvent.getKey());
        } else {
            keysDown.remove((Object)keyEvent.getKey());
        }
        this._currentKeyboardState = new KeyboardState(keysDown, keyEvent);
    }

    public List<InputState> drainAvailableStates() {
        if (this._stateQueue.isEmpty()) {
            return EMPTY_LIST;
        }
        LinkedList<InputState> result = new LinkedList<InputState>();
        this._stateQueue.drainTo(result);
        return result;
    }

    private void lostFocus() {
        this._stateQueue.add(InputState.LOST_FOCUS);
        this._currentKeyboardState = KeyboardState.NOTHING;
        this._currentMouseState = MouseState.NOTHING;
        this._currentControllerState = ControllerState.NOTHING;
    }

    private void init() {
        this._inited = true;
        this._keyboardWrapper.init();
        this._mouseWrapper.init();
        this._focusWrapper.init();
        this._controllerWrapper.init();
    }

    public ControllerWrapper getControllerWrapper() {
        return this._controllerWrapper;
    }

    public KeyboardWrapper getKeyboardWrapper() {
        return this._keyboardWrapper;
    }

    public MouseWrapper getMouseWrapper() {
        return this._mouseWrapper;
    }
}

