/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.control;

import com.ardor3d.framework.Canvas;
import com.ardor3d.input.Key;
import com.ardor3d.input.KeyboardState;
import com.ardor3d.input.MouseState;
import com.ardor3d.input.logical.InputTrigger;
import com.ardor3d.input.logical.LogicalLayer;
import com.ardor3d.input.logical.TriggerAction;
import com.ardor3d.input.logical.TriggerConditions;
import com.ardor3d.input.logical.TwoInputStates;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Matrix3;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class FirstPersonControl {
    protected final Vector3 _upAxis = new Vector3();
    protected double _mouseRotateSpeed = 0.005;
    protected double _moveSpeed = 50.0;
    protected double _keyRotateSpeed = 2.25;
    protected final Matrix3 _workerMatrix = new Matrix3();
    protected final Vector3 _workerStoreA = new Vector3();
    protected InputTrigger _mouseTrigger;
    protected InputTrigger _keyTrigger;
    protected boolean _clampVerticalAngle = false;
    protected double _minVerticalAngle = -1.0471975511965976;
    protected double _maxVerticalAngle = 1.0471975511965976;

    public FirstPersonControl(ReadOnlyVector3 upAxis) {
        this._upAxis.set(upAxis);
    }

    public ReadOnlyVector3 getUpAxis() {
        return this._upAxis;
    }

    public void setUpAxis(ReadOnlyVector3 upAxis) {
        this._upAxis.set(upAxis);
    }

    public double getMouseRotateSpeed() {
        return this._mouseRotateSpeed;
    }

    public void setMouseRotateSpeed(double speed) {
        this._mouseRotateSpeed = speed;
    }

    public double getMoveSpeed() {
        return this._moveSpeed;
    }

    public void setMoveSpeed(double speed) {
        this._moveSpeed = speed;
    }

    public double getKeyRotateSpeed() {
        return this._keyRotateSpeed;
    }

    public void setKeyRotateSpeed(double speed) {
        this._keyRotateSpeed = speed;
    }

    protected void move(Camera camera, KeyboardState kb, double tpf) {
        int moveFB = 0;
        int strafeLR = 0;
        if (kb.isDown(Key.W)) {
            ++moveFB;
        }
        if (kb.isDown(Key.S)) {
            --moveFB;
        }
        if (kb.isDown(Key.A)) {
            ++strafeLR;
        }
        if (kb.isDown(Key.D)) {
            --strafeLR;
        }
        if (moveFB != 0 || strafeLR != 0) {
            Vector3 loc = this._workerStoreA.zero();
            if (moveFB == 1) {
                loc.addLocal(camera.getDirection());
            } else if (moveFB == -1) {
                loc.subtractLocal(camera.getDirection());
            }
            if (strafeLR == 1) {
                loc.addLocal(camera.getLeft());
            } else if (strafeLR == -1) {
                loc.subtractLocal(camera.getLeft());
            }
            loc.normalizeLocal().multiplyLocal(this._moveSpeed * tpf).addLocal(camera.getLocation());
            camera.setLocation((ReadOnlyVector3)loc);
        }
        int rotX = 0;
        int rotY = 0;
        if (kb.isDown(Key.UP)) {
            --rotY;
        }
        if (kb.isDown(Key.DOWN)) {
            ++rotY;
        }
        if (kb.isDown(Key.LEFT)) {
            ++rotX;
        }
        if (kb.isDown(Key.RIGHT)) {
            --rotX;
        }
        if (rotX != 0 || rotY != 0) {
            this.rotate(camera, (double)rotX * (this._keyRotateSpeed / this._mouseRotateSpeed) * tpf, (double)rotY * (this._keyRotateSpeed / this._mouseRotateSpeed) * tpf);
        }
    }

    protected void rotate(Camera camera, double dx, double dy) {
        if (dx != 0.0) {
            this.applyDx(dx, camera);
        }
        if (dy != 0.0) {
            this.applyDY(dy, camera);
        }
        if (dx != 0.0 || dy != 0.0) {
            camera.normalize();
        }
    }

    private void applyDx(double dx, Camera camera) {
        this._workerMatrix.fromAngleNormalAxis(this._mouseRotateSpeed * dx, (ReadOnlyVector3)this._upAxis);
        this._workerMatrix.applyPost(camera.getLeft(), this._workerStoreA);
        camera.setLeft((ReadOnlyVector3)this._workerStoreA);
        this._workerMatrix.applyPost(camera.getDirection(), this._workerStoreA);
        camera.setDirection((ReadOnlyVector3)this._workerStoreA);
        this._workerMatrix.applyPost(camera.getUp(), this._workerStoreA);
        camera.setUp((ReadOnlyVector3)this._workerStoreA);
    }

    private void applyDY(double dy, Camera camera) {
        double angleV;
        this._workerMatrix.fromAngleNormalAxis(this._mouseRotateSpeed * dy, camera.getLeft());
        this._workerMatrix.applyPost(camera.getDirection(), this._workerStoreA);
        camera.setDirection((ReadOnlyVector3)this._workerStoreA);
        if (this.isClampVerticalAngle() && ((angleV = 1.5707963267948966 - this._workerStoreA.smallestAngleBetween((ReadOnlyVector3)this._upAxis)) > this.getMaxVerticalAngle() || angleV < this.getMinVerticalAngle())) {
            double newAngle = MathUtils.clamp((double)angleV, (double)this.getMinVerticalAngle(), (double)this.getMaxVerticalAngle());
            this._workerMatrix.fromAngleNormalAxis(-(newAngle - angleV), camera.getLeft());
            this._workerMatrix.applyPost(camera.getDirection(), this._workerStoreA);
            camera.setDirection((ReadOnlyVector3)this._workerStoreA);
            camera.getDirection().cross(camera.getLeft(), this._workerStoreA);
            camera.setUp((ReadOnlyVector3)this._workerStoreA);
            return;
        }
        this._workerMatrix.applyPost(camera.getUp(), this._workerStoreA);
        camera.setUp((ReadOnlyVector3)this._workerStoreA);
    }

    public static FirstPersonControl setupTriggers(LogicalLayer layer, ReadOnlyVector3 upAxis, boolean dragOnly) {
        FirstPersonControl control = new FirstPersonControl(upAxis);
        control.setupKeyboardTriggers(layer);
        control.setupMouseTriggers(layer, dragOnly);
        return control;
    }

    public static void removeTriggers(LogicalLayer layer, FirstPersonControl control) {
        if (control._mouseTrigger != null) {
            layer.deregisterTrigger(control._mouseTrigger);
        }
        if (control._keyTrigger != null) {
            layer.deregisterTrigger(control._keyTrigger);
        }
    }

    public void setupMouseTriggers(LogicalLayer layer, boolean dragOnly) {
        Predicate someMouseDown = Predicates.or((Predicate)TriggerConditions.leftButtonDown(), (Predicate)Predicates.or((Predicate)TriggerConditions.rightButtonDown(), (Predicate)TriggerConditions.middleButtonDown()));
        Predicate dragged = Predicates.and((Predicate)TriggerConditions.mouseMoved(), (Predicate)someMouseDown);
        TriggerAction dragAction = new TriggerAction(){
            private boolean firstPing = true;

            @Override
            public void perform(Canvas source, TwoInputStates inputStates, double tpf) {
                MouseState mouse = inputStates.getCurrent().getMouseState();
                if (mouse.getDx() != 0 || mouse.getDy() != 0) {
                    if (!this.firstPing) {
                        FirstPersonControl.this.rotate(source.getCanvasRenderer().getCamera(), -mouse.getDx(), -mouse.getDy());
                    } else {
                        this.firstPing = false;
                    }
                }
            }
        };
        this._mouseTrigger = new InputTrigger((Predicate<TwoInputStates>)(dragOnly ? dragged : TriggerConditions.mouseMoved()), dragAction);
        layer.registerTrigger(this._mouseTrigger);
    }

    public Predicate<TwoInputStates> setupKeyboardTriggers(LogicalLayer layer) {
        Predicate<TwoInputStates> keysHeld = new Predicate<TwoInputStates>(){
            Key[] keys = new Key[]{Key.W, Key.A, Key.S, Key.D, Key.LEFT, Key.RIGHT, Key.UP, Key.DOWN};

            public boolean apply(TwoInputStates states) {
                for (Key k : this.keys) {
                    if (states.getCurrent() == null || !states.getCurrent().getKeyboardState().isDown(k)) continue;
                    return true;
                }
                return false;
            }
        };
        TriggerAction moveAction = new TriggerAction(){

            @Override
            public void perform(Canvas source, TwoInputStates inputStates, double tpf) {
                FirstPersonControl.this.move(source.getCanvasRenderer().getCamera(), inputStates.getCurrent().getKeyboardState(), tpf);
            }
        };
        this._keyTrigger = new InputTrigger(keysHeld, moveAction);
        layer.registerTrigger(this._keyTrigger);
        return keysHeld;
    }

    public InputTrigger getKeyTrigger() {
        return this._keyTrigger;
    }

    public InputTrigger getMouseTrigger() {
        return this._mouseTrigger;
    }

    public boolean isClampVerticalAngle() {
        return this._clampVerticalAngle;
    }

    public void setClampVerticalAngle(boolean clampVerticalAngle) {
        this._clampVerticalAngle = clampVerticalAngle;
    }

    public double getMinVerticalAngle() {
        return this._minVerticalAngle;
    }

    public void setMinVerticalAngle(double minVerticalAngle) {
        this._minVerticalAngle = minVerticalAngle;
    }

    public double getMaxVerticalAngle() {
        return this._maxVerticalAngle;
    }

    public void setMaxVerticalAngle(double maxVerticalAngle) {
        this._maxVerticalAngle = maxVerticalAngle;
    }
}

