/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.control;

import com.ardor3d.framework.Canvas;
import com.ardor3d.input.MouseState;
import com.ardor3d.input.logical.InputTrigger;
import com.ardor3d.input.logical.LogicalLayer;
import com.ardor3d.input.logical.MouseWheelMovedCondition;
import com.ardor3d.input.logical.TriggerAction;
import com.ardor3d.input.logical.TriggerConditions;
import com.ardor3d.input.logical.TwoInputStates;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.scenegraph.Spatial;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;

public class OrbitCamControl {
    public static final double ABSOLUTE_MAXASCENT = 1.5699236621688994;
    protected Camera _camera;
    protected Vector3 _worldUpVec = new Vector3(Vector3.UNIT_Y);
    protected Vector3 _sphereCoords = new Vector3();
    protected Vector3 _camPosition = new Vector3();
    protected Vector3 _lookAtPoint = new Vector3();
    protected Spatial _lookAtSpatial = null;
    protected TargetType _targetType;
    protected boolean _invertedX = false;
    protected boolean _invertedY = false;
    protected boolean _invertedWheel = true;
    protected double _zoomSpeed = 0.01;
    protected double _baseDistance = 15.0;
    protected double _minZoomDistance = 1.0;
    protected double _maxZoomDistance = 100.0;
    protected double _minAscent = -1.5699236621688994;
    protected double _maxAscent = 1.5699236621688994;
    protected double _xSpeed = 0.01;
    protected double _ySpeed = 0.01;
    protected boolean _dirty = true;
    protected InputTrigger _mouseTrigger;

    public OrbitCamControl(Camera cam, ReadOnlyVector3 target) {
        this._camera = cam;
        this._targetType = TargetType.Point;
        this._lookAtPoint.set(target);
    }

    public OrbitCamControl(Camera cam, Spatial target) {
        this._camera = cam;
        this._targetType = TargetType.Spatial;
        this._lookAtSpatial = target;
    }

    public Camera getCamera() {
        return this._camera;
    }

    public void setCamera(Camera camera) {
        this._camera = camera;
    }

    public ReadOnlyVector3 getWorldUpVec() {
        return this._worldUpVec;
    }

    public void setWorldUpVec(ReadOnlyVector3 worldUpVec) {
        this._worldUpVec.set(worldUpVec);
        this._dirty = true;
    }

    public void setInvertedWheel(boolean invertedWheel) {
        this._invertedWheel = invertedWheel;
    }

    public boolean isInvertedWheel() {
        return this._invertedWheel;
    }

    public void setInvertedX(boolean invertedX) {
        this._invertedX = invertedX;
    }

    public boolean isInvertedX() {
        return this._invertedX;
    }

    public void setInvertedY(boolean invertedY) {
        this._invertedY = invertedY;
    }

    public boolean isInvertedY() {
        return this._invertedY;
    }

    public Vector3 getLookAtPoint() {
        return this._lookAtPoint;
    }

    public void setLookAtPoint(Vector3 point) {
        this._dirty = !point.equals((Object)this._lookAtPoint);
        this._lookAtPoint = point;
        this._targetType = TargetType.Point;
    }

    public Spatial getLookAtSpatial() {
        return this._lookAtSpatial;
    }

    public void setLookAtSpatial(Spatial spatial) {
        this._dirty = spatial != this._lookAtSpatial;
        this._lookAtSpatial = spatial;
        this._targetType = TargetType.Spatial;
    }

    public TargetType getTargetType() {
        return this._targetType;
    }

    public double getZoomSpeed() {
        return this._zoomSpeed;
    }

    public void setZoomSpeed(double zoomSpeed) {
        this._zoomSpeed = zoomSpeed;
    }

    public double getBaseDistance() {
        return this._baseDistance;
    }

    public void setBaseDistance(double baseDistance) {
        this._baseDistance = baseDistance;
        this.zoom(0.0);
    }

    public double getMaxAscent() {
        return this._maxAscent;
    }

    public void setMaxAscent(double maxAscent) {
        this._maxAscent = Math.min(maxAscent, 1.5699236621688994);
        this.move(0.0, 0.0);
    }

    public double getMinAscent() {
        return this._minAscent;
    }

    public void setMinAscent(double minAscent) {
        this._minAscent = Math.max(minAscent, -1.5699236621688994);
        this.move(0.0, 0.0);
    }

    public double getMaxZoomDistance() {
        return this._maxZoomDistance;
    }

    public void setMaxZoomDistance(double maxZoomDistance) {
        this._maxZoomDistance = maxZoomDistance;
        this.zoom(0.0);
    }

    public double getMinZoomDistance() {
        return this._minZoomDistance;
    }

    public void setMinZoomDistance(double minZoomDistance) {
        this._minZoomDistance = minZoomDistance;
        this.zoom(0.0);
    }

    public double getXSpeed() {
        return this._xSpeed;
    }

    public void setXSpeed(double speed) {
        this._xSpeed = speed;
    }

    public double getYSpeed() {
        return this._ySpeed;
    }

    public void setYSpeed(double speed) {
        this._ySpeed = speed;
    }

    public void setSphereCoords(ReadOnlyVector3 sphereCoords) {
        this._sphereCoords.set(sphereCoords);
        this.makeDirty();
    }

    public void setSphereCoords(double x, double y, double z) {
        this._sphereCoords.set(x, y, z);
        this.makeDirty();
    }

    protected void updateTargetPos() {
        if (this._targetType == TargetType.Spatial) {
            double x = this._lookAtPoint.getX();
            double y = this._lookAtPoint.getY();
            double z = this._lookAtPoint.getZ();
            this._lookAtSpatial.getWorldTransform().applyForward(Vector3.ZERO, this._lookAtPoint);
            if (x != this._lookAtPoint.getX() || y != this._lookAtPoint.getY() || z != this._lookAtPoint.getZ()) {
                this.makeDirty();
            }
        }
    }

    public void makeDirty() {
        this._dirty = true;
    }

    public void zoom(double percent) {
        double amount = (double)(this._invertedWheel ? -1 : 1) * percent * this._baseDistance;
        this._sphereCoords.setX(MathUtils.clamp((double)(this._sphereCoords.getX() + amount), (double)this._minZoomDistance, (double)this._maxZoomDistance));
        this.makeDirty();
    }

    public void move(double xDif, double yDif) {
        double azimuthAccel = this._invertedX ? -xDif : xDif;
        double thetaAccel = this._invertedY ? -yDif : yDif;
        this._sphereCoords.setY(MathUtils.moduloPositive((double)(this._sphereCoords.getY() - azimuthAccel), (double)(Math.PI * 2)));
        this._sphereCoords.setZ(MathUtils.clamp((double)(this._sphereCoords.getZ() + thetaAccel), (double)this._minAscent, (double)this._maxAscent));
        this.makeDirty();
    }

    public void update(double time) {
        this.updateTargetPos();
        if (!this._dirty) {
            return;
        }
        if (this._worldUpVec.getY() == 1.0) {
            MathUtils.sphericalToCartesian((ReadOnlyVector3)this._sphereCoords, (Vector3)this._camPosition);
        } else if (this._worldUpVec.getZ() == 1.0) {
            MathUtils.sphericalToCartesianZ((ReadOnlyVector3)this._sphereCoords, (Vector3)this._camPosition);
        }
        this._camera.setLocation((ReadOnlyVector3)this._camPosition.addLocal((ReadOnlyVector3)this._lookAtPoint));
        this._camera.lookAt((ReadOnlyVector3)this._lookAtPoint, (ReadOnlyVector3)this._worldUpVec);
        this._dirty = false;
    }

    public void setupMouseTriggers(LogicalLayer layer, boolean dragOnly) {
        Predicate someMouseDown = Predicates.or((Predicate)TriggerConditions.leftButtonDown(), (Predicate)Predicates.or((Predicate)TriggerConditions.rightButtonDown(), (Predicate)TriggerConditions.middleButtonDown()));
        MouseWheelMovedCondition scrollWheelMoved = new MouseWheelMovedCondition();
        Predicate dragged = Predicates.and((Predicate)TriggerConditions.mouseMoved(), (Predicate)someMouseDown);
        TriggerAction mouseAction = new TriggerAction(){
            private boolean firstPing = true;

            @Override
            public void perform(Canvas source, TwoInputStates inputStates, double tpf) {
                MouseState mouse = inputStates.getCurrent().getMouseState();
                if (mouse.getDx() != 0 || mouse.getDy() != 0) {
                    if (!this.firstPing) {
                        OrbitCamControl.this.move(OrbitCamControl.this._xSpeed * (double)mouse.getDx(), OrbitCamControl.this._ySpeed * (double)mouse.getDy());
                    } else {
                        this.firstPing = false;
                    }
                }
                if (mouse.getDwheel() != 0) {
                    OrbitCamControl.this.zoom(OrbitCamControl.this._zoomSpeed * (double)mouse.getDwheel());
                }
            }
        };
        Predicate predicate = Predicates.or((Predicate)scrollWheelMoved, (Predicate)(dragOnly ? dragged : TriggerConditions.mouseMoved()));
        this._mouseTrigger = new InputTrigger((Predicate<TwoInputStates>)predicate, mouseAction);
        layer.registerTrigger(this._mouseTrigger);
    }

    public static enum TargetType {
        Point,
        Spatial;

    }
}

