/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;
import java.util.Map;

public final class ControllerComponentActiveCondition
implements Predicate<TwoInputStates> {
    private final String controllerName;
    private final String[] componentNames;

    public ControllerComponentActiveCondition(String controller, String ... components) {
        this.controllerName = controller;
        this.componentNames = components;
    }

    public boolean apply(TwoInputStates states) {
        Map<String, Float> currentStates = states.getCurrent().getControllerState().getControllerComponentValues(this.controllerName);
        Map<String, Float> previousStates = states.getPrevious().getControllerState().getControllerComponentValues(this.controllerName);
        if (currentStates == null) {
            return false;
        }
        for (String component : this.componentNames) {
            Float prev;
            Float curr = currentStates.get(component);
            if (curr == null) continue;
            if (curr.floatValue() != 0.0f) {
                return true;
            }
            if (previousStates == null || (prev = previousStates.get(component)) == null || curr.floatValue() == prev.floatValue()) continue;
            return true;
        }
        return false;
    }
}

