/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ControllerEvent;
import com.ardor3d.input.ControllerState;
import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;
import java.util.List;

public final class ControllerComponentCondition
implements Predicate<TwoInputStates> {
    private int controllerIndex = -1;
    private int componentIndex = -1;
    private String controllerName = null;
    private String componentName = null;

    public ControllerComponentCondition(int controller, int component) {
        this.controllerIndex = controller;
        this.componentIndex = component;
    }

    public ControllerComponentCondition(String controller, String component) {
        this.controllerName = controller;
        this.componentName = component;
    }

    public boolean apply(TwoInputStates states) {
        boolean apply = false;
        ControllerState currentState = states.getCurrent().getControllerState();
        ControllerState previousState = states.getPrevious().getControllerState();
        if (!previousState.equals(currentState)) {
            if (this.controllerName == null) {
                this.controllerName = currentState.getControllerNames().get(this.controllerIndex);
            }
            if (this.componentName == null) {
                this.componentName = currentState.getControllerComponentNames(this.controllerName).get(this.componentIndex);
            }
            List<ControllerEvent> events = currentState.getEvents();
            for (ControllerEvent event : events) {
                if (!event.getControllerName().equals(this.controllerName) || !event.getComponentName().equals(this.componentName)) continue;
                apply = true;
            }
        }
        return apply;
    }
}

