/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ControllerEvent;
import com.ardor3d.input.ControllerState;
import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;
import java.util.List;

public final class ControllerCondition
implements Predicate<TwoInputStates> {
    private int controllerIndex = -1;
    private String controllerName = null;

    public ControllerCondition(int controller) {
        this.controllerIndex = controller;
    }

    public ControllerCondition(String controller) {
        this.controllerName = controller;
    }

    public boolean apply(TwoInputStates states) {
        boolean apply = false;
        ControllerState currentState = states.getCurrent().getControllerState();
        ControllerState previousState = states.getPrevious().getControllerState();
        if (!previousState.equals(currentState)) {
            if (this.controllerName == null) {
                this.controllerName = currentState.getControllerNames().get(this.controllerIndex);
            }
            List<ControllerEvent> events = currentState.getEvents();
            for (ControllerEvent event : events) {
                if (!event.getControllerName().equals(this.controllerName)) continue;
                apply = true;
            }
        }
        return apply;
    }
}

