/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.annotation.MainThread;
import com.ardor3d.framework.Canvas;
import com.ardor3d.input.InputState;
import com.ardor3d.input.PhysicalLayer;
import com.ardor3d.input.logical.BasicTriggersApplier;
import com.ardor3d.input.logical.InputTrigger;
import com.ardor3d.input.logical.LogicalTriggersApplier;
import com.ardor3d.input.logical.TwoInputStates;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class LogicalLayer {
    private final Set<InputSource> _inputs = new CopyOnWriteArraySet<InputSource>();
    private final Set<InputTrigger> _triggers = new CopyOnWriteArraySet<InputTrigger>();
    private LogicalTriggersApplier _applier = new BasicTriggersApplier();

    public void registerInput(Canvas source, PhysicalLayer physicalLayer) {
        this._inputs.add(new InputSource(source, physicalLayer));
    }

    public void registerTrigger(InputTrigger inputTrigger) {
        this._triggers.add(inputTrigger);
    }

    public void deregisterTrigger(InputTrigger inputTrigger) {
        this._triggers.remove(inputTrigger);
    }

    @MainThread
    public synchronized void checkTriggers(double tpf) {
        for (InputSource is : this._inputs) {
            is.physicalLayer.readState();
            List<InputState> newStates = is.physicalLayer.drainAvailableStates();
            if (newStates.isEmpty()) {
                this._applier.checkAndPerformTriggers(this._triggers, is.source, new TwoInputStates(is.lastState, is.lastState), tpf);
                continue;
            }
            double time = newStates.size() > 1 ? tpf / (double)newStates.size() : tpf;
            for (InputState inputState : newStates) {
                if (inputState != InputState.LOST_FOCUS) {
                    this._applier.checkAndPerformTriggers(this._triggers, is.source, new TwoInputStates(is.lastState, inputState), time);
                }
                is.lastState = inputState;
            }
        }
    }

    public void setApplier(LogicalTriggersApplier applier) {
        this._applier = applier;
    }

    public LogicalTriggersApplier getApplier() {
        return this._applier;
    }

    public Set<InputTrigger> getTriggers() {
        return this._triggers;
    }

    public InputTrigger findTriggerById(String id) {
        for (InputTrigger trigger : this._triggers) {
            if (!id.equals(trigger.getId())) continue;
            return trigger;
        }
        return null;
    }

    private static class InputSource {
        private final Canvas source;
        private final PhysicalLayer physicalLayer;
        private InputState lastState;

        public InputSource(Canvas source, PhysicalLayer physicalLayer) {
            this.source = source;
            this.physicalLayer = physicalLayer;
            this.lastState = InputState.EMPTY;
        }
    }
}

