/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ButtonState;
import com.ardor3d.input.InputState;
import com.ardor3d.input.MouseButton;
import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;
import java.util.EnumMap;

public final class MouseButtonCondition
implements Predicate<TwoInputStates> {
    private final EnumMap<MouseButton, ButtonState> _states = new EnumMap(MouseButton.class);

    public MouseButtonCondition(EnumMap<MouseButton, ButtonState> states) {
        this._states.putAll(states);
    }

    public MouseButtonCondition(ButtonState left, ButtonState right, ButtonState middle) {
        this(left, right, middle, ButtonState.UNDEFINED, ButtonState.UNDEFINED, ButtonState.UNDEFINED, ButtonState.UNDEFINED, ButtonState.UNDEFINED, ButtonState.UNDEFINED);
    }

    public MouseButtonCondition(ButtonState left, ButtonState right, ButtonState middle, ButtonState four, ButtonState five, ButtonState six, ButtonState seven, ButtonState eight, ButtonState nine) {
        if (left != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.LEFT, left);
        }
        if (right != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.RIGHT, right);
        }
        if (middle != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.MIDDLE, middle);
        }
        if (four != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.FOUR, four);
        }
        if (five != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.FIVE, five);
        }
        if (six != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.SIX, six);
        }
        if (seven != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.SEVEN, seven);
        }
        if (eight != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.EIGHT, eight);
        }
        if (nine != ButtonState.UNDEFINED) {
            this._states.put(MouseButton.NINE, nine);
        }
    }

    public boolean apply(TwoInputStates states) {
        InputState currentState = states.getCurrent();
        if (currentState == null) {
            return false;
        }
        for (MouseButton button : this._states.keySet()) {
            ButtonState required = this._states.get((Object)button);
            if (required == ButtonState.UNDEFINED || currentState.getMouseState().getButtonState(button) == required) continue;
            return false;
        }
        return true;
    }
}

