/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ButtonState;
import com.ardor3d.input.InputState;
import com.ardor3d.input.MouseButton;
import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;

public final class MouseButtonPressedCondition
implements Predicate<TwoInputStates> {
    private final MouseButton _button;

    public MouseButtonPressedCondition(MouseButton button) {
        if (button == null) {
            throw new NullPointerException();
        }
        this._button = button;
    }

    public boolean apply(TwoInputStates states) {
        InputState currentState = states.getCurrent();
        InputState previousState = states.getPrevious();
        if (currentState == null || previousState == null || !currentState.getMouseState().hasButtonState(ButtonState.DOWN)) {
            return false;
        }
        return currentState.getMouseState().getButtonsPressedSince(previousState.getMouseState()).contains((Object)this._button);
    }
}

