/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ButtonState;
import com.ardor3d.input.InputState;
import com.ardor3d.input.MouseButton;
import com.ardor3d.input.logical.TwoInputStates;
import com.google.common.base.Predicate;

public final class MouseButtonReleasedCondition
implements Predicate<TwoInputStates> {
    private final MouseButton _button;

    public MouseButtonReleasedCondition(MouseButton button) {
        if (button == null) {
            throw new NullPointerException();
        }
        this._button = button;
    }

    public boolean apply(TwoInputStates states) {
        InputState currentState = states.getCurrent();
        InputState previousState = states.getPrevious();
        if (currentState == null || previousState == null || !previousState.getMouseState().hasButtonState(ButtonState.DOWN)) {
            return false;
        }
        return currentState.getMouseState().getButtonsReleasedSince(previousState.getMouseState()).contains((Object)this._button);
    }
}

