/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.input.logical;

import com.ardor3d.input.ButtonState;
import com.ardor3d.input.MouseButton;
import com.ardor3d.input.logical.MouseButtonCondition;
import com.ardor3d.input.logical.MouseMovedCondition;
import com.ardor3d.input.logical.TwoInputStates;
import com.ardor3d.util.Timer;
import com.google.common.base.Predicate;
import java.util.EnumMap;

public final class TriggerConditions {
    private static final MouseMovedCondition MOUSE_MOVED_CONDITION = new MouseMovedCondition();
    private static final MouseButtonCondition LEFT_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.LEFT, ButtonState.DOWN);
    private static final MouseButtonCondition RIGHT_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.RIGHT, ButtonState.DOWN);
    private static final MouseButtonCondition MIDDLE_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.MIDDLE, ButtonState.DOWN);
    private static final MouseButtonCondition FOUR_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.FOUR, ButtonState.DOWN);
    private static final MouseButtonCondition FIVE_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.FIVE, ButtonState.DOWN);
    private static final MouseButtonCondition SIX_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.SIX, ButtonState.DOWN);
    private static final MouseButtonCondition SEVEN_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.SEVEN, ButtonState.DOWN);
    private static final MouseButtonCondition EIGHT_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.EIGHT, ButtonState.DOWN);
    private static final MouseButtonCondition NINE_DOWN_CONDITION = TriggerConditions.makeCondition(MouseButton.NINE, ButtonState.DOWN);
    private static final Predicate<TwoInputStates> ALWAYS_TRUE = new Predicate<TwoInputStates>(){

        public boolean apply(TwoInputStates arg0) {
            return true;
        }
    };
    private static final Predicate<TwoInputStates> ALWAYS_FALSE = new Predicate<TwoInputStates>(){

        public boolean apply(TwoInputStates arg0) {
            return true;
        }
    };

    private static MouseButtonCondition makeCondition(MouseButton button, ButtonState state) {
        EnumMap<MouseButton, ButtonState> map = new EnumMap<MouseButton, ButtonState>(MouseButton.class);
        for (MouseButton b : MouseButton.values()) {
            map.put(b, button != b ? ButtonState.UNDEFINED : state);
        }
        return new MouseButtonCondition(map);
    }

    private TriggerConditions() {
    }

    public static MouseMovedCondition mouseMoved() {
        return MOUSE_MOVED_CONDITION;
    }

    public static MouseButtonCondition leftButtonDown() {
        return LEFT_DOWN_CONDITION;
    }

    public static MouseButtonCondition rightButtonDown() {
        return RIGHT_DOWN_CONDITION;
    }

    public static MouseButtonCondition middleButtonDown() {
        return MIDDLE_DOWN_CONDITION;
    }

    public static MouseButtonCondition fourButtonDown() {
        return FOUR_DOWN_CONDITION;
    }

    public static MouseButtonCondition fiveButtonDown() {
        return FIVE_DOWN_CONDITION;
    }

    public static MouseButtonCondition sixButtonDown() {
        return SIX_DOWN_CONDITION;
    }

    public static MouseButtonCondition sevenButtonDown() {
        return SEVEN_DOWN_CONDITION;
    }

    public static MouseButtonCondition eightButtonDown() {
        return EIGHT_DOWN_CONDITION;
    }

    public static MouseButtonCondition nineButtonDown() {
        return NINE_DOWN_CONDITION;
    }

    public static Predicate<TwoInputStates> alwaysTrue() {
        return ALWAYS_TRUE;
    }

    public static Predicate<TwoInputStates> alwaysFalse() {
        return ALWAYS_FALSE;
    }

    public static Predicate<TwoInputStates> passedThrottle(final double throttleTime, final Timer timer) {
        return new Predicate<TwoInputStates>(){
            private double lastPass = 0.0;

            public boolean apply(TwoInputStates arg0) {
                double now = timer.getTimeInSeconds();
                if (now - this.lastPass >= throttleTime) {
                    this.lastPass = now;
                    return true;
                }
                return false;
            }
        };
    }
}

