/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.intersection;

import com.ardor3d.intersection.PrimitiveKey;
import com.ardor3d.math.Vector3;
import com.ardor3d.util.Ardor3dException;
import java.util.Arrays;
import java.util.List;

public class IntersectionRecord {
    private final Intersection[] _intersections;
    private boolean _isSorted = true;

    public IntersectionRecord(double[] distances, Vector3[] points) {
        this(distances, points, null);
    }

    public IntersectionRecord(double[] distances, Vector3[] points, List<PrimitiveKey> primitives) {
        this(distances, points, null, primitives);
    }

    public IntersectionRecord(double[] distances, Vector3[] points, Vector3[] normals, List<PrimitiveKey> primitives) {
        if (distances.length != points.length || primitives != null && points.length != primitives.size() || normals != null && points.length != normals.length) {
            throw new Ardor3dException("All arguments must have an equal number of elements.");
        }
        this._isSorted = distances.length < 2;
        this._intersections = new Intersection[distances.length];
        for (int i = 0; i < distances.length; ++i) {
            this._intersections[i] = new Intersection(distances[i], points[i], normals != null ? normals[i] : null, primitives != null ? primitives.get(i) : null);
        }
    }

    public void sortIntersections() {
        if (!this._isSorted) {
            Arrays.sort(this._intersections);
            this._isSorted = true;
        }
    }

    public int getNumberOfIntersections() {
        return this._intersections.length;
    }

    public Vector3 getIntersectionPoint(int index) {
        return this._intersections[index]._point;
    }

    public Vector3 getIntersectionNormal(int index) {
        return this._intersections[index]._normal;
    }

    public double getIntersectionDistance(int index) {
        return this._intersections[index]._distance;
    }

    public PrimitiveKey getIntersectionPrimitive(int index) {
        return this._intersections[index]._primitiveKey;
    }

    public double getClosestDistance() {
        int i = this.getClosestIntersection();
        return i != -1 ? this._intersections[i]._distance : -1.0;
    }

    public double getFurthestDistance() {
        int i = this.getFurthestIntersection();
        return i != -1 ? this._intersections[i]._distance : -1.0;
    }

    public int getClosestIntersection() {
        int index = -1;
        if (this._isSorted) {
            index = this._intersections.length > 0 ? 0 : -1;
        } else {
            double min = Double.MAX_VALUE;
            int i = this._intersections.length;
            while (--i >= 0) {
                double val = this._intersections[i]._distance;
                if (!(val < min)) continue;
                min = val;
                index = i;
            }
        }
        return index;
    }

    public int getFurthestIntersection() {
        int index = -1;
        if (this._isSorted) {
            index = this._intersections.length > 0 ? this._intersections.length - 1 : -1;
        } else {
            double max = -1.7976931348623157E308;
            int i = this._intersections.length;
            while (--i >= 0) {
                double val = this._intersections[i]._distance;
                if (!(val > max)) continue;
                max = val;
                index = i;
            }
        }
        return index;
    }

    private static final class Intersection
    implements Comparable<Intersection> {
        private final double _distance;
        private final Vector3 _point;
        private final Vector3 _normal;
        private final PrimitiveKey _primitiveKey;

        private Intersection(double distance, Vector3 point, Vector3 normal, PrimitiveKey primitiveKey) {
            this._distance = distance;
            this._point = point;
            this._normal = normal;
            this._primitiveKey = primitiveKey;
        }

        @Override
        public int compareTo(Intersection other) {
            return this._distance == other._distance ? 0 : (this._distance < other._distance ? -1 : 1);
        }
    }
}

