/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.intersection;

import com.ardor3d.intersection.PickData;
import com.ardor3d.intersection.Pickable;
import com.ardor3d.math.Ray3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class PickResults {
    private final List<PickData> _nodeList = new ArrayList<PickData>();
    private boolean _checkDistance;
    private DistanceComparator _distanceCompare;
    private boolean modified = false;

    public void addPickData(PickData data) {
        this._nodeList.add(data);
        this.modified = true;
    }

    public int getNumber() {
        return this._nodeList.size();
    }

    public PickData getPickData(int i) {
        if (this.modified) {
            if (this._checkDistance) {
                Collections.sort(this._nodeList, this._distanceCompare);
            }
            this.modified = false;
        }
        return this._nodeList.get(i);
    }

    public void clear() {
        this._nodeList.clear();
    }

    public abstract void addPick(Ray3 var1, Pickable var2);

    public void processPick() {
    }

    public boolean willCheckDistance() {
        return this._checkDistance;
    }

    public void setCheckDistance(boolean checkDistance) {
        this._checkDistance = checkDistance;
        if (checkDistance) {
            this._distanceCompare = new DistanceComparator();
        }
    }

    public PickData findFirstIntersectingPickData() {
        int i = 0;
        while (this.getNumber() > 0 && this.getPickData(i).getIntersectionRecord().getNumberOfIntersections() == 0 && ++i < this.getNumber()) {
        }
        return this.getNumber() > i ? this.getPickData(i) : null;
    }

    private static class DistanceComparator
    implements Comparator<PickData> {
        private DistanceComparator() {
        }

        @Override
        public int compare(PickData o1, PickData o2) {
            if (o1.getIntersectionRecord().getClosestDistance() == o2.getIntersectionRecord().getClosestDistance()) {
                return 0;
            }
            if (o1.getIntersectionRecord().getClosestDistance() < o2.getIntersectionRecord().getClosestDistance()) {
                return -1;
            }
            return 1;
        }
    }
}

