/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.intersection;

import com.ardor3d.bounding.CollisionTree;
import com.ardor3d.bounding.CollisionTreeManager;
import com.ardor3d.intersection.CollisionResults;
import com.ardor3d.intersection.PickResults;
import com.ardor3d.intersection.Pickable;
import com.ardor3d.intersection.PrimitiveKey;
import com.ardor3d.math.Ray3;
import com.ardor3d.math.type.ReadOnlyRay3;
import com.ardor3d.math.type.ReadOnlyTransform;
import com.ardor3d.scenegraph.Mesh;
import com.ardor3d.scenegraph.Node;
import com.ardor3d.scenegraph.Spatial;
import com.ardor3d.scenegraph.hint.CullHint;
import com.ardor3d.scenegraph.hint.PickingHint;
import java.util.List;

public abstract class PickingUtil {
    public static void findPick(Spatial spatial, Ray3 ray, PickResults results) {
        PickingUtil.findPick(spatial, ray, results, true);
    }

    public static void findPick(Spatial spatial, Ray3 ray, PickResults results, boolean ignoreCulled) {
        if (spatial == null || !spatial.getSceneHints().isPickingHintEnabled(PickingHint.Pickable) || ignoreCulled && spatial.getSceneHints().getCullHint() == CullHint.Always || spatial.getWorldBound() == null || !spatial.getWorldBound().intersects((ReadOnlyRay3)ray)) {
            return;
        }
        if (spatial instanceof Pickable) {
            results.addPick(ray, (Pickable)((Object)spatial));
        } else if (spatial instanceof Node) {
            Node node = (Node)spatial;
            for (int i = node.getNumberOfChildren() - 1; i >= 0; --i) {
                PickingUtil.findPick(node.getChild(i), ray, results, ignoreCulled);
            }
        }
    }

    public static void findCollisions(Spatial spatial, Spatial scene, CollisionResults results) {
        Mesh mesh;
        if (spatial == scene || spatial.getWorldBound() == null || !spatial.getSceneHints().isPickingHintEnabled(PickingHint.Collidable) || !scene.getSceneHints().isPickingHintEnabled(PickingHint.Collidable)) {
            return;
        }
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            if (node.getWorldBound().intersects(scene.getWorldBound())) {
                for (int i = 0; i < node.getNumberOfChildren(); ++i) {
                    PickingUtil.findCollisions(node.getChild(i), scene, results);
                }
            }
        } else if (spatial instanceof Mesh && (mesh = (Mesh)spatial).getWorldBound().intersects(scene.getWorldBound())) {
            if (scene instanceof Node) {
                Node parent = (Node)scene;
                for (int i = 0; i < parent.getNumberOfChildren(); ++i) {
                    PickingUtil.findCollisions(mesh, parent.getChild(i), results);
                }
            } else {
                results.addCollision(mesh, (Mesh)scene);
            }
        }
    }

    public static boolean hasPrimitiveCollision(Mesh testMesh, Mesh toCheck) {
        if (!testMesh.getSceneHints().isPickingHintEnabled(PickingHint.Collidable) || !toCheck.getSceneHints().isPickingHintEnabled(PickingHint.Collidable)) {
            return false;
        }
        CollisionTree thisCT = CollisionTreeManager.getInstance().getCollisionTree(testMesh);
        CollisionTree checkCT = CollisionTreeManager.getInstance().getCollisionTree(toCheck);
        if (thisCT == null || checkCT == null) {
            return false;
        }
        ReadOnlyTransform worldTransform = testMesh.getWorldTransform();
        thisCT.getBounds().transform(worldTransform, thisCT.getWorldBounds());
        return thisCT.intersect(checkCT);
    }

    public static void findPrimitiveCollision(Mesh testMesh, Mesh toCheck, List<PrimitiveKey> testIndex, List<PrimitiveKey> otherIndex) {
        if (!testMesh.getSceneHints().isPickingHintEnabled(PickingHint.Collidable) || !toCheck.getSceneHints().isPickingHintEnabled(PickingHint.Collidable)) {
            return;
        }
        CollisionTree myTree = CollisionTreeManager.getInstance().getCollisionTree(testMesh);
        CollisionTree otherTree = CollisionTreeManager.getInstance().getCollisionTree(toCheck);
        if (myTree == null || otherTree == null) {
            return;
        }
        myTree.getBounds().transform(testMesh.getWorldTransform(), myTree.getWorldBounds());
        myTree.intersect(otherTree, testIndex, otherIndex);
    }

    public static boolean hasCollision(Spatial spatial, Spatial scene, boolean checkPrimitives) {
        if (spatial == scene || spatial.getWorldBound() == null || !spatial.getSceneHints().isPickingHintEnabled(PickingHint.Collidable) || !scene.getSceneHints().isPickingHintEnabled(PickingHint.Collidable)) {
            return false;
        }
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            if (node.getWorldBound().intersects(scene.getWorldBound())) {
                if (node.getNumberOfChildren() == 0 && !checkPrimitives) {
                    return true;
                }
                for (int i = 0; i < node.getNumberOfChildren(); ++i) {
                    if (!PickingUtil.hasCollision(node.getChild(i), scene, checkPrimitives)) continue;
                    return true;
                }
            }
        } else if (spatial instanceof Mesh) {
            Mesh mesh = (Mesh)spatial;
            if (mesh.getWorldBound().intersects(scene.getWorldBound())) {
                if (scene instanceof Node) {
                    Node parent = (Node)scene;
                    for (int i = 0; i < parent.getNumberOfChildren(); ++i) {
                        if (!PickingUtil.hasCollision(mesh, parent.getChild(i), checkPrimitives)) continue;
                        return true;
                    }
                    return false;
                }
                if (!checkPrimitives) {
                    return true;
                }
                return PickingUtil.hasPrimitiveCollision(mesh, (Mesh)scene);
            }
            return false;
        }
        return false;
    }
}

