/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.intersection;

import com.ardor3d.intersection.IntersectionRecord;
import com.ardor3d.intersection.PickResults;
import com.ardor3d.intersection.Pickable;
import com.ardor3d.intersection.PrimitivePickData;
import com.ardor3d.math.Ray3;

public class PrimitivePickResults
extends PickResults {
    protected float _maxPickableDistance = Float.MAX_VALUE;

    @Override
    public void addPick(Ray3 ray, Pickable pickable) {
        IntersectionRecord record = pickable.intersectsWorldBoundsWhere(ray);
        if (record != null && record.getClosestDistance() > (double)this._maxPickableDistance) {
            return;
        }
        PrimitivePickData data = new PrimitivePickData(ray, pickable);
        if (data.getIntersectionRecord() != null && data.getIntersectionRecord().getNumberOfIntersections() > 0) {
            this.addPickData(data);
        }
    }

    public float getMaxPickableDistance() {
        return this._maxPickableDistance;
    }

    public void setMaxPickableDistance(float distance) {
        this._maxPickableDistance = distance;
    }
}

