/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.intersection;

import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyVector3;

public class TriangleTriangleIntersect {
    public static final double EPSILON = 1.0E-12;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean intersectTriTri(Vector3 v0, Vector3 v1, Vector3 v2, Vector3 u0, Vector3 u1, Vector3 u2) {
        Vector3 e1 = Vector3.fetchTempInstance();
        Vector3 e2 = Vector3.fetchTempInstance();
        Vector3 n1 = Vector3.fetchTempInstance();
        Vector3 n2 = Vector3.fetchTempInstance();
        Vector3 d = Vector3.fetchTempInstance();
        try {
            Vector2 y0y1;
            double up2;
            double up1;
            double up0;
            double vp2;
            double vp1;
            double vp0;
            double[] isect1 = new double[2];
            double[] isect2 = new double[2];
            v1.subtract((ReadOnlyVector3)v0, e1);
            v2.subtract((ReadOnlyVector3)v0, e2);
            e1.cross((ReadOnlyVector3)e2, n1);
            double d1 = -n1.dot((ReadOnlyVector3)v0);
            double du0 = n1.dot((ReadOnlyVector3)u0) + d1;
            double du1 = n1.dot((ReadOnlyVector3)u1) + d1;
            double du2 = n1.dot((ReadOnlyVector3)u2) + d1;
            if (Math.abs(du0) < 1.0E-12) {
                du0 = 0.0;
            }
            if (Math.abs(du1) < 1.0E-12) {
                du1 = 0.0;
            }
            if (Math.abs(du2) < 1.0E-12) {
                du2 = 0.0;
            }
            double du0du1 = du0 * du1;
            double du0du2 = du0 * du2;
            if (du0du1 > 0.0 && du0du2 > 0.0) {
                boolean bl = false;
                return bl;
            }
            u1.subtract((ReadOnlyVector3)u0, e1);
            u2.subtract((ReadOnlyVector3)u0, e2);
            e1.cross((ReadOnlyVector3)e2, n2);
            double d2 = -n2.dot((ReadOnlyVector3)u0);
            double dv0 = n2.dot((ReadOnlyVector3)v0) + d2;
            double dv1 = n2.dot((ReadOnlyVector3)v1) + d2;
            double dv2 = n2.dot((ReadOnlyVector3)v2) + d2;
            if (Math.abs(dv0) < 1.0E-12) {
                dv0 = 0.0;
            }
            if (Math.abs(dv1) < 1.0E-12) {
                dv1 = 0.0;
            }
            if (Math.abs(dv2) < 1.0E-12) {
                dv2 = 0.0;
            }
            double dv0dv1 = dv0 * dv1;
            double dv0dv2 = dv0 * dv2;
            if (dv0dv1 > 0.0 && dv0dv2 > 0.0) {
                boolean bl = false;
                return bl;
            }
            n1.cross((ReadOnlyVector3)n2, d);
            double max = Math.abs(d.getX());
            boolean index = false;
            double bb = Math.abs(d.getY());
            double cc = Math.abs(d.getZ());
            if (bb > max) {
                max = bb;
                index = true;
            }
            if (cc > max) {
                vp0 = v0.getZ();
                vp1 = v1.getZ();
                vp2 = v2.getZ();
                up0 = u0.getZ();
                up1 = u1.getZ();
                up2 = u2.getZ();
            } else if (index) {
                vp0 = v0.getY();
                vp1 = v1.getY();
                vp2 = v2.getY();
                up0 = u0.getY();
                up1 = u1.getY();
                up2 = u2.getY();
            } else {
                vp0 = v0.getX();
                vp1 = v1.getX();
                vp2 = v2.getX();
                up0 = u0.getX();
                up1 = u1.getX();
                up2 = u2.getX();
            }
            Vector3 abc = Vector3.fetchTempInstance();
            Vector2 x0x1 = Vector2.fetchTempInstance();
            if (TriangleTriangleIntersect.newComputeIntervals(vp0, vp1, vp2, dv0, dv1, dv2, dv0dv1, dv0dv2, abc, x0x1)) {
                boolean bl = TriangleTriangleIntersect.coplanarTriTri(n1, v0, v1, v2, u0, u1, u2);
                return bl;
            }
            Vector3 def = Vector3.fetchTempInstance();
            if (TriangleTriangleIntersect.newComputeIntervals(up0, up1, up2, du0, du1, du2, du0du1, du0du2, def, y0y1 = Vector2.fetchTempInstance())) {
                boolean bl = TriangleTriangleIntersect.coplanarTriTri(n1, v0, v1, v2, u0, u1, u2);
                return bl;
            }
            double xx = x0x1.getX() * x0x1.getY();
            double yy = y0y1.getX() * y0y1.getY();
            double xxyy = xx * yy;
            double tmp = abc.getX() * xxyy;
            isect1[0] = tmp + abc.getY() * x0x1.getY() * yy;
            isect1[1] = tmp + abc.getZ() * x0x1.getX() * yy;
            tmp = def.getX() * xxyy;
            isect2[0] = tmp + def.getY() * xx * y0y1.getY();
            isect2[1] = tmp + def.getZ() * xx * y0y1.getX();
            Vector3.releaseTempInstance((Vector3)abc);
            Vector3.releaseTempInstance((Vector3)def);
            Vector2.releaseTempInstance((Vector2)x0x1);
            Vector2.releaseTempInstance((Vector2)y0y1);
            TriangleTriangleIntersect.sort(isect1);
            TriangleTriangleIntersect.sort(isect2);
            if (isect1[1] < isect2[0] || isect2[1] < isect1[0]) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Vector3.releaseTempInstance((Vector3)e1);
            Vector3.releaseTempInstance((Vector3)e2);
            Vector3.releaseTempInstance((Vector3)n1);
            Vector3.releaseTempInstance((Vector3)n2);
            Vector3.releaseTempInstance((Vector3)d);
        }
    }

    private static void sort(double[] f) {
        if (f[0] > f[1]) {
            double c = f[0];
            f[0] = f[1];
            f[1] = c;
        }
    }

    private static boolean newComputeIntervals(double vv0, double vv1, double vv2, double d0, double d1, double d2, double d0d1, double d0d2, Vector3 abc, Vector2 x0x1) {
        if (d0d1 > 0.0) {
            abc.setX(vv2);
            abc.setY((vv0 - vv2) * d2);
            abc.setZ((vv1 - vv2) * d2);
            x0x1.setX(d2 - d0);
            x0x1.setY(d2 - d1);
        } else if (d0d2 > 0.0) {
            abc.setX(vv1);
            abc.setY((vv0 - vv1) * d1);
            abc.setZ((vv2 - vv1) * d1);
            x0x1.setX(d1 - d0);
            x0x1.setY(d1 - d2);
        } else if (d1 * d2 > 0.0 || d0 != 0.0) {
            abc.setX(vv0);
            abc.setY((vv1 - vv0) * d0);
            abc.setZ((vv2 - vv0) * d0);
            x0x1.setX(d0 - d1);
            x0x1.setY(d0 - d2);
        } else if (d1 != 0.0) {
            abc.setX(vv1);
            abc.setY((vv0 - vv1) * d1);
            abc.setZ((vv2 - vv1) * d1);
            x0x1.setX(d1 - d0);
            x0x1.setY(d1 - d2);
        } else if (d2 != 0.0) {
            abc.setX(vv2);
            abc.setY((vv0 - vv2) * d2);
            abc.setZ((vv1 - vv2) * d2);
            x0x1.setX(d2 - d0);
            x0x1.setY(d2 - d1);
        } else {
            return true;
        }
        return false;
    }

    private static boolean coplanarTriTri(Vector3 n, Vector3 v0, Vector3 v1, Vector3 v2, Vector3 u0, Vector3 u1, Vector3 u2) {
        int i1;
        int i0;
        Vector3 a = new Vector3();
        a.setX(Math.abs(n.getX()));
        a.setY(Math.abs(n.getY()));
        a.setZ(Math.abs(n.getZ()));
        if (a.getX() > a.getY()) {
            if (a.getX() > a.getZ()) {
                i0 = 1;
                i1 = 2;
            } else {
                i0 = 0;
                i1 = 1;
            }
        } else if (a.getZ() > a.getY()) {
            i0 = 0;
            i1 = 1;
        } else {
            i0 = 0;
            i1 = 2;
        }
        double[] v0f = new double[3];
        v0.toArray(v0f);
        double[] v1f = new double[3];
        v1.toArray(v1f);
        double[] v2f = new double[3];
        v2.toArray(v2f);
        double[] u0f = new double[3];
        u0.toArray(u0f);
        double[] u1f = new double[3];
        u1.toArray(u1f);
        double[] u2f = new double[3];
        u2.toArray(u2f);
        if (TriangleTriangleIntersect.edgeAgainstTriEdges(v0f, v1f, u0f, u1f, u2f, i0, i1)) {
            return true;
        }
        if (TriangleTriangleIntersect.edgeAgainstTriEdges(v1f, v2f, u0f, u1f, u2f, i0, i1)) {
            return true;
        }
        if (TriangleTriangleIntersect.edgeAgainstTriEdges(v2f, v0f, u0f, u1f, u2f, i0, i1)) {
            return true;
        }
        TriangleTriangleIntersect.pointInTri(v0f, u0f, u1f, u2f, i0, i1);
        TriangleTriangleIntersect.pointInTri(u0f, v0f, v1f, v2f, i0, i1);
        return false;
    }

    private static boolean pointInTri(double[] V0, double[] U0, double[] U1, double[] U2, int i0, int i1) {
        double a = U1[i1] - U0[i1];
        double b = -(U1[i0] - U0[i0]);
        double c = -a * U0[i0] - b * U0[i1];
        double d0 = a * V0[i0] + b * V0[i1] + c;
        a = U2[i1] - U1[i1];
        b = -(U2[i0] - U1[i0]);
        c = -a * U1[i0] - b * U1[i1];
        double d1 = a * V0[i0] + b * V0[i1] + c;
        a = U0[i1] - U2[i1];
        b = -(U0[i0] - U2[i0]);
        c = -a * U2[i0] - b * U2[i1];
        double d2 = a * V0[i0] + b * V0[i1] + c;
        return d0 * d1 > 0.0 && d0 * d2 > 0.0;
    }

    private static boolean edgeAgainstTriEdges(double[] v0, double[] v1, double[] u0, double[] u1, double[] u2, int i0, int i1) {
        double aX = v1[i0] - v0[i0];
        double aY = v1[i1] - v0[i1];
        if (TriangleTriangleIntersect.edgeEdgeTest(v0, u0, u1, i0, i1, aX, aY)) {
            return true;
        }
        if (TriangleTriangleIntersect.edgeEdgeTest(v0, u1, u2, i0, i1, aX, aY)) {
            return true;
        }
        return TriangleTriangleIntersect.edgeEdgeTest(v0, u2, u0, i0, i1, aX, aY);
    }

    private static boolean edgeEdgeTest(double[] v0, double[] u0, double[] u1, int i0, int i1, double aX, double Ay) {
        double Bx = u0[i0] - u1[i0];
        double By = u0[i1] - u1[i1];
        double Cx = v0[i0] - u0[i0];
        double Cy = v0[i1] - u0[i1];
        double f = Ay * Bx - aX * By;
        double d = By * Cx - Bx * Cy;
        if (f > 0.0 && d >= 0.0 && d <= f || f < 0.0 && d <= 0.0 && d >= f) {
            double e = aX * Cy - Ay * Cx;
            if (f > 0.0 ? e >= 0.0 && e <= f : e <= 0.0 && e >= f) {
                return true;
            }
        }
        return false;
    }
}

