/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.light;

import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;
import java.io.Serializable;

public abstract class Light
implements Serializable,
Savable {
    private static final long serialVersionUID = 1L;
    public static final ReadOnlyColorRGBA DEFAULT_AMBIENT = new ColorRGBA(0.4f, 0.4f, 0.4f, 1.0f);
    public static final ReadOnlyColorRGBA DEFAULT_DIFFUSE = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    public static final ReadOnlyColorRGBA DEFAULT_SPECULAR = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    private final ColorRGBA _ambient = new ColorRGBA(DEFAULT_AMBIENT);
    private final ColorRGBA _diffuse = new ColorRGBA(DEFAULT_DIFFUSE);
    private final ColorRGBA _specular = new ColorRGBA(DEFAULT_SPECULAR);
    private boolean _attenuate;
    private float _constant = 1.0f;
    private float _linear;
    private float _quadratic;
    private int _lightMask = 0;
    private int _backLightMask = 0;
    private boolean _enabled;
    private String _name;
    protected boolean _shadowCaster;

    public abstract Type getType();

    public float getConstant() {
        return this._constant;
    }

    public void setConstant(float constant) {
        this._constant = constant;
    }

    public float getLinear() {
        return this._linear;
    }

    public void setLinear(float linear) {
        this._linear = linear;
    }

    public float getQuadratic() {
        return this._quadratic;
    }

    public void setQuadratic(float quadratic) {
        this._quadratic = quadratic;
    }

    public boolean isAttenuate() {
        return this._attenuate;
    }

    public void setAttenuate(boolean attenuate) {
        this._attenuate = attenuate;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean value) {
        this._enabled = value;
    }

    public ReadOnlyColorRGBA getSpecular() {
        return this._specular;
    }

    public void setSpecular(ReadOnlyColorRGBA specular) {
        this._specular.set(specular);
    }

    public ReadOnlyColorRGBA getDiffuse() {
        return this._diffuse;
    }

    public void setDiffuse(ReadOnlyColorRGBA diffuse) {
        this._diffuse.set(diffuse);
    }

    public ReadOnlyColorRGBA getAmbient() {
        return this._ambient;
    }

    public void setAmbient(ReadOnlyColorRGBA ambient) {
        this._ambient.set(ambient);
    }

    public int getLightMask() {
        return this._lightMask;
    }

    public void setLightMask(int lightMask) {
        this._lightMask = lightMask;
    }

    public void pushLightMask() {
        this._backLightMask = this._lightMask;
    }

    public void popLightMask() {
        this._lightMask = this._backLightMask;
    }

    public boolean isShadowCaster() {
        return this._shadowCaster;
    }

    public void setShadowCaster(boolean mayCastShadows) {
        this._shadowCaster = mayCastShadows;
    }

    public void copyFrom(Light light) {
        this._ambient.set((ReadOnlyColorRGBA)light._ambient);
        this._attenuate = light._attenuate;
        this._constant = light._constant;
        this._diffuse.set((ReadOnlyColorRGBA)light._diffuse);
        this._enabled = light._enabled;
        this._linear = light._linear;
        this._quadratic = light._quadratic;
        this._shadowCaster = light._shadowCaster;
        this._specular.set((ReadOnlyColorRGBA)light._specular);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Savable)this._ambient, "ambient", (Savable)new ColorRGBA(DEFAULT_AMBIENT));
        capsule.write((Savable)this._diffuse, "diffuse", (Savable)new ColorRGBA(DEFAULT_DIFFUSE));
        capsule.write((Savable)this._specular, "specular", (Savable)new ColorRGBA(DEFAULT_SPECULAR));
        capsule.write(this._attenuate, "attenuate", false);
        capsule.write(this._constant, "constant", 1.0f);
        capsule.write(this._linear, "linear", 0.0f);
        capsule.write(this._quadratic, "quadratic", 0.0f);
        capsule.write(this._lightMask, "lightMask", 0);
        capsule.write(this._backLightMask, "backLightMask", 0);
        capsule.write(this._enabled, "enabled", false);
        capsule.write(this._shadowCaster, "shadowCaster", false);
        capsule.write(this._name, "name", null);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._ambient.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("ambient", (Savable)new ColorRGBA(DEFAULT_AMBIENT))));
        this._diffuse.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("diffuse", (Savable)new ColorRGBA(DEFAULT_DIFFUSE))));
        this._specular.set((ReadOnlyColorRGBA)((ColorRGBA)capsule.readSavable("specular", (Savable)new ColorRGBA(DEFAULT_SPECULAR))));
        this._attenuate = capsule.readBoolean("attenuate", false);
        this._constant = capsule.readFloat("constant", 1.0f);
        this._linear = capsule.readFloat("linear", 0.0f);
        this._quadratic = capsule.readFloat("quadratic", 0.0f);
        this._lightMask = capsule.readInt("lightMask", 0);
        this._backLightMask = capsule.readInt("backLightMask", 0);
        this._enabled = capsule.readBoolean("enabled", false);
        this._shadowCaster = capsule.readBoolean("shadowCaster", false);
        this._name = capsule.readString("name", null);
    }

    public Class<? extends Light> getClassTag() {
        return this.getClass();
    }

    public static enum Type {
        Directional,
        Point,
        Spot;

    }
}

