/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.light;

import com.ardor3d.light.Light;
import com.ardor3d.light.PointLight;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.util.Ardor3dException;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import java.io.IOException;

public class SpotLight
extends PointLight {
    private static final long serialVersionUID = 1L;
    private float _angle;
    private float _exponent;
    private final Vector3 _direction = new Vector3(Vector3.UNIT_Z);

    public SpotLight() {
        this.setAmbient((ReadOnlyColorRGBA)new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
    }

    public ReadOnlyVector3 getDirection() {
        return this._direction;
    }

    public void setDirection(ReadOnlyVector3 direction) {
        this._direction.set(direction);
    }

    public float getAngle() {
        return this._angle;
    }

    public void setAngle(float angle) {
        if (angle < 0.0f || angle > 90.0f && angle != 180.0f) {
            throw new Ardor3dException("invalid angle.  Angle must be between 0 and 90, or 180");
        }
        this._angle = angle;
    }

    public float getExponent() {
        return this._exponent;
    }

    public void setExponent(float exponent) {
        if (exponent < 0.0f || exponent > 128.0f) {
            throw new Ardor3dException("invalid exponent.  Exponent must be between 0 and 128");
        }
        this._exponent = exponent;
    }

    @Override
    public Light.Type getType() {
        return Light.Type.Spot;
    }

    @Override
    public void write(OutputCapsule capsule) throws IOException {
        super.write(capsule);
        capsule.write((Savable)this._direction, "direction", (Savable)new Vector3(Vector3.UNIT_Z));
        capsule.write(this._angle, "angle", 0.0f);
        capsule.write(this._exponent, "exponent", 0.0f);
    }

    @Override
    public void read(InputCapsule capsule) throws IOException {
        super.read(capsule);
        this._direction.set((ReadOnlyVector3)((Vector3)capsule.readSavable("direction", (Savable)new Vector3(Vector3.UNIT_Z))));
        this._angle = capsule.readFloat("angle", 0.0f);
        this._exponent = capsule.readFloat("exponent", 0.0f);
    }
}

