/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.framework.Scene;
import com.ardor3d.image.Texture;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import java.nio.IntBuffer;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractFBOTextureRenderer
implements TextureRenderer {
    private static final Logger logger = Logger.getLogger(AbstractFBOTextureRenderer.class.getName());
    protected final EnumMap<RenderState.StateType, RenderState> _enforcedStates = new EnumMap(RenderState.StateType.class);
    protected final Camera _camera = new Camera(1, 1);
    protected final ColorRGBA _backgroundColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected int _active;
    protected int _fboID = 0;
    protected int _depthRBID = 0;
    protected int _msfboID = 0;
    protected int _msdepthRBID = 0;
    protected int _mscolorRBID = 0;
    protected int _width = 0;
    protected int _height = 0;
    protected int _samples = 0;
    protected int _depthBits = 0;
    protected IntBuffer _attachBuffer = null;
    protected boolean _usingDepthRB = false;
    protected final boolean _supportsDepthTexture;
    protected final boolean _supportsMultisample;
    protected boolean _neededClip;
    protected final Renderer _parentRenderer;
    private Camera _oldCamera;

    public AbstractFBOTextureRenderer(int width, int height, int depthBits, int samples, Renderer parentRenderer, ContextCapabilities caps) {
        this._parentRenderer = parentRenderer;
        this._samples = Math.min(samples, caps.getMaxFBOSamples());
        this._depthBits = depthBits;
        this._supportsDepthTexture = caps.isDepthTextureSupported();
        this._supportsMultisample = caps.getMaxFBOSamples() != 0;
        int w = width;
        int h = height;
        if (!caps.isNonPowerOfTwoTextureSupported()) {
            if (!MathUtils.isPowerOfTwo((int)w)) {
                int newWidth = 2;
                while ((newWidth <<= 1) < w) {
                }
                w = newWidth;
            }
            if (!MathUtils.isPowerOfTwo((int)h)) {
                int newHeight = 2;
                while ((newHeight <<= 1) < h) {
                }
                h = newHeight;
            }
        }
        logger.fine("Creating FBO sized: " + w + " x " + h);
        this._width = w;
        this._height = h;
        this._camera.resize(this._width, this._height);
        this._camera.setFrustum(1.0, 1000.0, -0.5, 0.5, 0.5, -0.5);
        Vector3 loc = new Vector3(0.0, 0.0, 0.0);
        Vector3 left = new Vector3(-1.0, 0.0, 0.0);
        Vector3 up = new Vector3(0.0, 1.0, 0.0);
        Vector3 dir = new Vector3(0.0, 0.0, -1.0);
        this._camera.setFrame((ReadOnlyVector3)loc, (ReadOnlyVector3)left, (ReadOnlyVector3)up, (ReadOnlyVector3)dir);
    }

    @Override
    public Camera getCamera() {
        return this._camera;
    }

    @Override
    public void setBackgroundColor(ReadOnlyColorRGBA c) {
        this._backgroundColor.set(c);
    }

    @Override
    public ReadOnlyColorRGBA getBackgroundColor() {
        return this._backgroundColor;
    }

    @Override
    public void render(Spatial toDraw, Texture tex, int clear) {
        try {
            ContextManager.getCurrentContext().pushFBOTextureRenderer(this);
            this.setupForSingleTexDraw(tex);
            if (this._samples > 0 && this._supportsMultisample) {
                this.setMSFBO();
            }
            this.switchCameraIn(clear);
            this.doDraw(toDraw);
            this.switchCameraOut();
            if (this._samples > 0 && this._supportsMultisample) {
                this.blitMSFBO();
            }
            this.takedownForSingleTexDraw(tex);
            ContextManager.getCurrentContext().popFBOTextureRenderer();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture, boolean)", "Exception", e);
        }
    }

    @Override
    public void render(Scene toDraw, Texture tex, int clear) {
        try {
            ContextManager.getCurrentContext().pushFBOTextureRenderer(this);
            this.setupForSingleTexDraw(tex);
            if (this._samples > 0 && this._supportsMultisample) {
                this.setMSFBO();
            }
            this.switchCameraIn(clear);
            this.doDraw(toDraw);
            this.switchCameraOut();
            if (this._samples > 0 && this._supportsMultisample) {
                this.blitMSFBO();
            }
            this.takedownForSingleTexDraw(tex);
            ContextManager.getCurrentContext().popFBOTextureRenderer();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(Spatial, Texture, boolean)", "Exception", e);
        }
    }

    @Override
    public void render(List<? extends Spatial> toDraw, Texture tex, int clear) {
        try {
            ContextManager.getCurrentContext().pushFBOTextureRenderer(this);
            this.setupForSingleTexDraw(tex);
            if (this._samples > 0 && this._supportsMultisample) {
                this.setMSFBO();
            }
            this.switchCameraIn(clear);
            this.doDraw(toDraw);
            this.switchCameraOut();
            if (this._samples > 0 && this._supportsMultisample) {
                this.blitMSFBO();
            }
            this.takedownForSingleTexDraw(tex);
            ContextManager.getCurrentContext().popFBOTextureRenderer();
        }
        catch (Exception e) {
            logger.logp(Level.SEVERE, this.getClass().toString(), "render(List<Spatial>, Texture, boolean)", "Exception", e);
        }
    }

    protected abstract void activate();

    protected abstract void setupForSingleTexDraw(Texture var1);

    protected abstract void takedownForSingleTexDraw(Texture var1);

    protected abstract void setMSFBO();

    protected abstract void blitMSFBO();

    protected abstract void deactivate();

    protected void switchCameraIn(int clear) {
        this._oldCamera = Camera.getCurrentCamera();
        this._parentRenderer.getQueue().pushBuckets();
        if (clear != 0) {
            this.clearBuffers(clear);
        }
        this.getCamera().update();
        this.getCamera().apply(this._parentRenderer);
    }

    protected abstract void clearBuffers(int var1);

    protected void switchCameraOut() {
        this._parentRenderer.flushFrame(false);
        this._oldCamera.update();
        this._oldCamera.apply(this._parentRenderer);
        this._parentRenderer.getQueue().popBuckets();
    }

    protected void doDraw(Spatial spat) {
        if (spat.getParent() != null) {
            spat.getParent().setLastFrustumIntersection(Camera.FrustumIntersect.Intersects);
        }
        spat.onDraw(this._parentRenderer);
    }

    protected void doDraw(List<? extends Spatial> toDraw) {
        int max = toDraw.size();
        for (int x = 0; x < max; ++x) {
            Spatial spat = toDraw.get(x);
            this.doDraw(spat);
        }
    }

    protected void doDraw(Scene toDraw) {
        toDraw.renderUnto(this._parentRenderer);
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    public Renderer getParentRenderer() {
        return this._parentRenderer;
    }

    @Override
    public void setMultipleTargets(boolean multi) {
    }

    @Override
    public void enforceState(RenderState state) {
        this._enforcedStates.put(state.getType(), state);
    }

    @Override
    public void enforceStates(EnumMap<RenderState.StateType, RenderState> states) {
        this._enforcedStates.putAll(states);
    }

    @Override
    public void clearEnforcedState(RenderState.StateType type) {
        this._enforcedStates.remove((Object)type);
    }

    @Override
    public void clearEnforcedStates() {
        this._enforcedStates.clear();
    }
}

