/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.framework.DisplaySettings;
import com.ardor3d.framework.Scene;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.MathUtils;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.TextureRenderer;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.scenegraph.Spatial;
import java.util.EnumMap;
import java.util.List;
import java.util.logging.Logger;

public abstract class AbstractPbufferTextureRenderer
implements TextureRenderer {
    private static final Logger logger = Logger.getLogger(AbstractPbufferTextureRenderer.class.getName());
    protected final EnumMap<RenderState.StateType, RenderState> _enforcedStates = new EnumMap(RenderState.StateType.class);
    protected final Camera _camera = new Camera(1, 1);
    protected final ColorRGBA _backgroundColor = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    protected boolean _bgColorDirty = true;
    protected boolean _useDirectRender = false;
    protected int _active;
    protected int _width = 0;
    protected int _height = 0;
    protected final Renderer _parentRenderer;
    protected final DisplaySettings _settings;
    protected RenderContext _oldContext;

    public AbstractPbufferTextureRenderer(DisplaySettings settings, Renderer parentRenderer, ContextCapabilities caps) {
        this._parentRenderer = parentRenderer;
        this._settings = settings;
        int width = settings.getWidth();
        int height = settings.getHeight();
        if (!caps.isNonPowerOfTwoTextureSupported()) {
            if (!MathUtils.isPowerOfTwo((int)width)) {
                int newWidth = 2;
                while ((newWidth <<= 1) < width) {
                }
                width = newWidth;
            }
            if (!MathUtils.isPowerOfTwo((int)height)) {
                int newHeight = 2;
                while ((newHeight <<= 1) < height) {
                }
                height = newHeight;
            }
        }
        this._width = width;
        this._height = height;
        logger.fine("Created Pbuffer sized: " + this._width + " x " + this._height);
        this._camera.resize(this._width, this._height);
        this._camera.setFrustum(1.0, 1000.0, -0.5, 0.5, 0.5, -0.5);
        Vector3 loc = new Vector3(0.0, 0.0, 0.0);
        Vector3 left = new Vector3(-1.0, 0.0, 0.0);
        Vector3 up = new Vector3(0.0, 1.0, 0.0);
        Vector3 dir = new Vector3(0.0, 0.0, -1.0);
        this._camera.setFrame((ReadOnlyVector3)loc, (ReadOnlyVector3)left, (ReadOnlyVector3)up, (ReadOnlyVector3)dir);
    }

    protected void switchCameraIn(int clear) {
        this._parentRenderer.getQueue().pushBuckets();
        if (clear != 0) {
            this.clearBuffers(clear);
        }
        this.getCamera().update();
        this.getCamera().apply(this._parentRenderer);
    }

    protected abstract void clearBuffers(int var1);

    protected void switchCameraOut() {
        this._parentRenderer.flushFrame(false);
        this._parentRenderer.getQueue().popBuckets();
    }

    protected void doDraw(Spatial spat) {
        if (spat.getParent() != null) {
            spat.getParent().setLastFrustumIntersection(Camera.FrustumIntersect.Intersects);
        }
        spat.onDraw(this._parentRenderer);
    }

    protected void doDraw(List<? extends Spatial> toDraw) {
        int max = toDraw.size();
        for (int x = 0; x < max; ++x) {
            Spatial spat = toDraw.get(x);
            this.doDraw(spat);
        }
    }

    protected void doDraw(Scene toDraw) {
        toDraw.renderUnto(this._parentRenderer);
    }

    @Override
    public Camera getCamera() {
        return this._camera;
    }

    @Override
    public void setBackgroundColor(ReadOnlyColorRGBA c) {
        this._backgroundColor.set(c);
        this._bgColorDirty = true;
    }

    @Override
    public ReadOnlyColorRGBA getBackgroundColor() {
        return this._backgroundColor;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public void enforceState(RenderState state) {
        this._enforcedStates.put(state.getType(), state);
    }

    @Override
    public void enforceStates(EnumMap<RenderState.StateType, RenderState> states) {
        this._enforcedStates.putAll(states);
    }

    @Override
    public void clearEnforcedState(RenderState.StateType type) {
        this._enforcedStates.remove((Object)type);
    }

    @Override
    public void clearEnforcedStates() {
        this._enforcedStates.clear();
    }
}

