/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.image.ImageDataFormat;
import com.ardor3d.image.PixelDataType;
import com.ardor3d.image.util.ImageUtils;
import com.ardor3d.math.ColorRGBA;
import com.ardor3d.math.type.ReadOnlyColorRGBA;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.IndexMode;
import com.ardor3d.renderer.RenderContext;
import com.ardor3d.renderer.RenderLogic;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.renderer.queue.RenderQueue;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.TextureState;
import com.ardor3d.renderer.state.record.RendererRecord;
import com.ardor3d.scenegraph.FloatBufferData;
import com.ardor3d.util.Constants;
import com.ardor3d.util.stat.StatCollector;
import com.ardor3d.util.stat.StatType;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.List;

public abstract class AbstractRenderer
implements Renderer {
    protected final ColorRGBA _backgroundColor = new ColorRGBA(ColorRGBA.BLACK);
    protected boolean _processingQueue;
    protected RenderQueue _queue = new RenderQueue();
    protected boolean _inOrthoMode;
    protected int _stencilClearValue;
    protected RenderLogic renderLogic;
    protected final EnumMap<RenderState.StateType, RenderState> defaultStateList = new EnumMap(RenderState.StateType.class);

    public AbstractRenderer() {
        for (RenderState.StateType type : RenderState.StateType.values()) {
            RenderState state = RenderState.createState(type);
            state.setEnabled(false);
            this.defaultStateList.put(type, state);
        }
    }

    @Override
    public boolean isInOrthoMode() {
        return this._inOrthoMode;
    }

    @Override
    public ReadOnlyColorRGBA getBackgroundColor() {
        return this._backgroundColor;
    }

    @Override
    public RenderQueue getQueue() {
        return this._queue;
    }

    @Override
    public boolean isProcessingQueue() {
        return this._processingQueue;
    }

    @Override
    public void applyState(RenderState.StateType type, RenderState state) {
        if (Constants.stats) {
            StatCollector.startStat(StatType.STAT_STATES_TIMER);
        }
        RenderState tempState = this.getProperRenderState(type, state);
        RenderContext context = ContextManager.getCurrentContext();
        if (!RenderState._quickCompare.contains((Object)type) || tempState.needsRefresh() || tempState != context.getCurrentState(type)) {
            this.doApplyState(tempState);
            tempState.setNeedsRefresh(false);
        }
        if (Constants.stats) {
            StatCollector.endStat(StatType.STAT_STATES_TIMER);
        }
    }

    protected abstract void doApplyState(RenderState var1);

    protected void addStats(IndexMode indexMode, int vertCount) {
        int primCount = IndexMode.getPrimitiveCount(indexMode, vertCount);
        switch (indexMode) {
            case Triangles: 
            case TriangleFan: 
            case TriangleStrip: {
                StatCollector.addStat(StatType.STAT_TRIANGLE_COUNT, primCount);
                break;
            }
            case Lines: 
            case LineLoop: 
            case LineStrip: {
                StatCollector.addStat(StatType.STAT_LINE_COUNT, primCount);
                break;
            }
            case Points: {
                StatCollector.addStat(StatType.STAT_POINT_COUNT, primCount);
                break;
            }
            case Quads: 
            case QuadStrip: {
                StatCollector.addStat(StatType.STAT_QUAD_COUNT, primCount);
            }
        }
    }

    protected int getTotalInterleavedSize(RenderContext context, FloatBufferData vertexCoords, FloatBufferData normalCoords, FloatBufferData colorCoords, List<FloatBufferData> textureCoords) {
        TextureState ts;
        ContextCapabilities caps = context.getCapabilities();
        int bufferSizeBytes = 0;
        if (normalCoords != null) {
            bufferSizeBytes += normalCoords.getBufferLimit() * 4;
        }
        if (colorCoords != null) {
            bufferSizeBytes += colorCoords.getBufferLimit() * 4;
        }
        if (textureCoords != null && (ts = (TextureState)context.getCurrentState(RenderState.StateType.Texture)) != null) {
            int max = caps.isMultitextureSupported() ? Math.min(caps.getNumberOfFragmentTexCoordUnits(), 32) : 1;
            for (int i = 0; i < max; ++i) {
                FloatBufferData textureBufferData;
                boolean exists;
                boolean bl = exists = i < textureCoords.size() && textureCoords.get(i) != null && i <= ts.getMaxTextureIndexUsed();
                if (!exists || (textureBufferData = textureCoords.get(i)) == null) continue;
                bufferSizeBytes += textureBufferData.getBufferLimit() * 4;
            }
        }
        if (vertexCoords != null) {
            bufferSizeBytes += vertexCoords.getBufferLimit() * 4;
        }
        return bufferSizeBytes;
    }

    public int getStencilClearValue() {
        return this._stencilClearValue;
    }

    public void setStencilClearValue(int stencilClearValue) {
        this._stencilClearValue = stencilClearValue;
    }

    @Override
    public boolean isClipTestEnabled() {
        RenderContext context = ContextManager.getCurrentContext();
        RendererRecord record = context.getRendererRecord();
        return record.isClippingTestEnabled();
    }

    @Override
    public RenderState getProperRenderState(RenderState.StateType type, RenderState current) {
        RenderState state;
        RenderContext context = ContextManager.getCurrentContext();
        RenderState renderState = state = context.hasEnforcedStates() ? context.getEnforcedState(type) : null;
        if (state == null) {
            if (current != null) {
                return current;
            }
            return this.defaultStateList.get((Object)type);
        }
        return state;
    }

    @Override
    public void setRenderLogic(RenderLogic renderLogic) {
        this.renderLogic = renderLogic;
    }

    @Override
    public void grabScreenContents(ByteBuffer store, ImageDataFormat format, int x, int y, int w, int h) {
        this.grabScreenContents(store, format, PixelDataType.UnsignedByte, x, y, w, h);
    }

    @Override
    public int getExpectedBufferSizeToGrabScreenContents(ImageDataFormat format, PixelDataType type, int w, int h) {
        int size = w * h * ImageUtils.getPixelByteSize(format, type);
        return size;
    }
}

