/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.bounding.BoundingVolume;
import com.ardor3d.math.Matrix4;
import com.ardor3d.math.Plane;
import com.ardor3d.math.Ray3;
import com.ardor3d.math.Vector2;
import com.ardor3d.math.Vector3;
import com.ardor3d.math.Vector4;
import com.ardor3d.math.type.ReadOnlyMatrix3;
import com.ardor3d.math.type.ReadOnlyMatrix4;
import com.ardor3d.math.type.ReadOnlyPlane;
import com.ardor3d.math.type.ReadOnlyVector2;
import com.ardor3d.math.type.ReadOnlyVector3;
import com.ardor3d.math.type.ReadOnlyVector4;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.Renderer;
import com.ardor3d.util.export.InputCapsule;
import com.ardor3d.util.export.OutputCapsule;
import com.ardor3d.util.export.Savable;
import com.ardor3d.util.geom.BufferUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.logging.Logger;

public class Camera
implements Savable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger _logger = Logger.getLogger(Camera.class.getName());
    public static final int LEFT_PLANE = 0;
    public static final int RIGHT_PLANE = 1;
    public static final int BOTTOM_PLANE = 2;
    public static final int TOP_PLANE = 3;
    public static final int FAR_PLANE = 4;
    public static final int NEAR_PLANE = 5;
    public static final int FRUSTUM_PLANES = 6;
    public static final int MAX_WORLD_PLANES = 32;
    protected final Vector3 _location = new Vector3();
    protected final Vector3 _left = new Vector3();
    protected final Vector3 _up = new Vector3();
    protected final Vector3 _direction = new Vector3();
    protected double _depthRangeNear;
    protected double _depthRangeFar;
    protected double _frustumNear;
    protected double _frustumFar;
    protected double _frustumLeft;
    protected double _frustumRight;
    protected double _frustumTop;
    protected double _frustumBottom;
    protected double _fovY = Double.NaN;
    protected double[] _coeffLeft;
    protected double[] _coeffRight;
    protected double[] _coeffBottom;
    protected double[] _coeffTop;
    protected int _planeQuantity;
    protected double _viewPortLeft;
    protected double _viewPortRight;
    protected double _viewPortTop;
    protected double _viewPortBottom;
    protected Plane[] _worldPlane;
    protected final FloatBuffer _matrixBuffer = BufferUtils.createFloatBuffer(16);
    protected final Vector3 _tempVector = new Vector3();
    private ProjectionMode _projectionMode = ProjectionMode.Perspective;
    private boolean _updateMVMatrix = true;
    private boolean _updatePMatrix = true;
    private boolean _updateMVPMatrix = true;
    private boolean _updateInverseMVPMatrix = true;
    protected final Matrix4 _modelView = new Matrix4();
    protected final Matrix4 _projection = new Matrix4();
    private final Matrix4 _modelViewProjection = new Matrix4();
    private final Matrix4 _modelViewProjectionInverse = new Matrix4();
    protected boolean _depthRangeDirty;
    protected boolean _frustumDirty;
    protected boolean _viewPortDirty;
    protected boolean _frameDirty;
    private int _planeState;
    protected int _width;
    protected int _height;

    public Camera() {
        this(100, 100);
    }

    public Camera(int width, int height) {
        this._width = width;
        this._height = height;
        this._location.set(0.0, 0.0, 0.0);
        this._left.set(-1.0, 0.0, 0.0);
        this._up.set(0.0, 1.0, 0.0);
        this._direction.set(0.0, 0.0, -1.0);
        this._depthRangeNear = 0.0;
        this._depthRangeFar = 1.0;
        this._depthRangeDirty = true;
        this._frustumNear = 1.0;
        this._frustumFar = 2.0;
        this._frustumLeft = -0.5;
        this._frustumRight = 0.5;
        this._frustumTop = 0.5;
        this._frustumBottom = -0.5;
        this._coeffLeft = new double[2];
        this._coeffRight = new double[2];
        this._coeffBottom = new double[2];
        this._coeffTop = new double[2];
        this._viewPortLeft = 0.0;
        this._viewPortRight = 1.0;
        this._viewPortTop = 1.0;
        this._viewPortBottom = 0.0;
        this._planeQuantity = 6;
        this._worldPlane = new Plane[32];
        for (int i = 0; i < 32; ++i) {
            this._worldPlane[i] = new Plane();
        }
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
        _logger.fine("Camera created. W: " + width + "  H: " + height);
    }

    public Camera(Camera source) {
        this._coeffLeft = new double[2];
        this._coeffRight = new double[2];
        this._coeffBottom = new double[2];
        this._coeffTop = new double[2];
        this._worldPlane = new Plane[32];
        for (int i = 0; i < 32; ++i) {
            this._worldPlane[i] = new Plane();
        }
        this.set(source);
        _logger.fine("Camera created. W: " + this.getWidth() + "  H: " + this.getHeight());
    }

    public void set(Camera source) {
        this._width = source.getWidth();
        this._height = source.getHeight();
        this._location.set(source.getLocation());
        this._left.set(source.getLeft());
        this._up.set(source.getUp());
        this._direction.set(source.getDirection());
        this._fovY = source.getFovY();
        this._depthRangeNear = source.getDepthRangeNear();
        this._depthRangeFar = source.getDepthRangeFar();
        this._depthRangeDirty = true;
        this._frustumNear = source.getFrustumNear();
        this._frustumFar = source.getFrustumFar();
        this._frustumLeft = source.getFrustumLeft();
        this._frustumRight = source.getFrustumRight();
        this._frustumTop = source.getFrustumTop();
        this._frustumBottom = source.getFrustumBottom();
        this._viewPortLeft = source.getViewPortLeft();
        this._viewPortRight = source.getViewPortRight();
        this._viewPortTop = source.getViewPortTop();
        this._viewPortBottom = source.getViewPortBottom();
        this._planeQuantity = 6;
        this._projectionMode = source.getProjectionMode();
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
    }

    public double getDepthRangeFar() {
        return this._depthRangeFar;
    }

    public void setDepthRangeFar(double depthRangeFar) {
        this._depthRangeFar = depthRangeFar;
        this._depthRangeDirty = true;
    }

    public double getDepthRangeNear() {
        return this._depthRangeNear;
    }

    public void setDepthRangeNear(double depthRangeNear) {
        this._depthRangeNear = depthRangeNear;
        this._depthRangeDirty = true;
    }

    public double getFrustumBottom() {
        return this._frustumBottom;
    }

    public void setFrustumBottom(double frustumBottom) {
        this._frustumBottom = frustumBottom;
        this.onFrustumChange();
    }

    public double getFrustumFar() {
        return this._frustumFar;
    }

    public void setFrustumFar(double frustumFar) {
        this._frustumFar = frustumFar;
        this.onFrustumChange();
    }

    public double getFrustumLeft() {
        return this._frustumLeft;
    }

    public void setFrustumLeft(double frustumLeft) {
        this._frustumLeft = frustumLeft;
        this.onFrustumChange();
    }

    public double getFrustumNear() {
        return this._frustumNear;
    }

    public void setFrustumNear(double frustumNear) {
        this._frustumNear = frustumNear;
        this.onFrustumChange();
    }

    public double getFrustumRight() {
        return this._frustumRight;
    }

    public void setFrustumRight(double frustumRight) {
        this._frustumRight = frustumRight;
        this.onFrustumChange();
    }

    public double getFrustumTop() {
        return this._frustumTop;
    }

    public void setFrustumTop(double frustumTop) {
        this._frustumTop = frustumTop;
        this.onFrustumChange();
    }

    public ReadOnlyVector3 getLocation() {
        return this._location;
    }

    public ReadOnlyVector3 getDirection() {
        return this._direction;
    }

    public ReadOnlyVector3 getLeft() {
        return this._left;
    }

    public ReadOnlyVector3 getUp() {
        return this._up;
    }

    public void setLocation(ReadOnlyVector3 location) {
        this._location.set(location);
        this.onFrameChange();
    }

    public void setLocation(double x, double y, double z) {
        this._location.set(x, y, z);
        this.onFrameChange();
    }

    public void setDirection(ReadOnlyVector3 direction) {
        this._direction.set(direction);
        this.onFrameChange();
    }

    public void setLeft(ReadOnlyVector3 left) {
        this._left.set(left);
        this.onFrameChange();
    }

    public void setUp(ReadOnlyVector3 up) {
        this._up.set(up);
        this.onFrameChange();
    }

    public void setAxes(ReadOnlyVector3 left, ReadOnlyVector3 up, ReadOnlyVector3 direction) {
        this._left.set(left);
        this._up.set(up);
        this._direction.set(direction);
        this.onFrameChange();
    }

    public void setAxes(ReadOnlyMatrix3 axes) {
        axes.getColumn(0, this._left);
        axes.getColumn(1, this._up);
        axes.getColumn(2, this._direction);
        this.onFrameChange();
    }

    public void normalize() {
        this._left.normalizeLocal();
        this._up.normalizeLocal();
        this._direction.normalizeLocal();
        this.onFrameChange();
    }

    public void setFrustum(double near, double far, double left, double right, double top, double bottom) {
        this._frustumNear = near;
        this._frustumFar = far;
        this._frustumLeft = left;
        this._frustumRight = right;
        this._frustumTop = top;
        this._frustumBottom = bottom;
        this.onFrustumChange();
    }

    public void setFrustum(Camera source) {
        this._frustumNear = source.getFrustumNear();
        this._frustumFar = source.getFrustumFar();
        this._frustumLeft = source.getFrustumLeft();
        this._frustumRight = source.getFrustumRight();
        this._frustumTop = source.getFrustumTop();
        this._frustumBottom = source.getFrustumBottom();
        this.onFrustumChange();
    }

    public void setFrustumPerspective(double fovY, double aspect, double near, double far) {
        if (Double.isNaN(aspect) || Double.isInfinite(aspect)) {
            _logger.warning("Invalid aspect given to setFrustumPerspective: " + aspect);
            return;
        }
        this._fovY = fovY;
        double h = Math.tan(this._fovY * (Math.PI / 180) * 0.5) * near;
        double w = h * aspect;
        this._frustumLeft = -w;
        this._frustumRight = w;
        this._frustumBottom = -h;
        this._frustumTop = h;
        this._frustumNear = near;
        this._frustumFar = far;
        this.onFrustumChange();
    }

    public double getFovY() {
        return this._fovY;
    }

    public void setFrame(ReadOnlyVector3 location, ReadOnlyVector3 left, ReadOnlyVector3 up, ReadOnlyVector3 direction) {
        this._left.set(left);
        this._up.set(up);
        this._direction.set(direction);
        this._location.set(location);
        this.onFrameChange();
    }

    public void setFrame(ReadOnlyVector3 location, ReadOnlyMatrix3 axes) {
        axes.getColumn(0, this._left);
        axes.getColumn(1, this._up);
        axes.getColumn(2, this._direction);
        this._location.set(location);
        this.onFrameChange();
    }

    public void setFrame(Camera source) {
        this._left.set(source.getLeft());
        this._up.set(source.getUp());
        this._direction.set(source.getDirection());
        this._location.set(source.getLocation());
        this.onFrameChange();
    }

    public void lookAt(ReadOnlyVector3 pos, ReadOnlyVector3 worldUpVector) {
        this.lookAt(pos.getX(), pos.getY(), pos.getZ(), worldUpVector);
    }

    public void lookAt(double x, double y, double z, ReadOnlyVector3 worldUpVector) {
        Vector3 newDirection = this._tempVector;
        newDirection.set(x, y, z).subtractLocal((ReadOnlyVector3)this._location).normalizeLocal();
        if (newDirection.equals((Object)this._direction)) {
            return;
        }
        this._direction.set((ReadOnlyVector3)newDirection);
        this._up.set(worldUpVector).normalizeLocal();
        if (this._up.equals((Object)Vector3.ZERO)) {
            this._up.set(Vector3.UNIT_Y);
        }
        this._left.set((ReadOnlyVector3)this._up).crossLocal((ReadOnlyVector3)this._direction).normalizeLocal();
        if (this._left.equals((Object)Vector3.ZERO)) {
            if (this._direction.getX() != 0.0) {
                this._left.set(this._direction.getY(), -this._direction.getX(), 0.0);
            } else {
                this._left.set(0.0, this._direction.getZ(), -this._direction.getY());
            }
        }
        this._up.set((ReadOnlyVector3)this._direction).crossLocal((ReadOnlyVector3)this._left).normalizeLocal();
        this.onFrameChange();
    }

    public void update() {
        this._depthRangeDirty = true;
        this.onFrustumChange();
        this.onViewPortChange();
        this.onFrameChange();
    }

    public int getPlaneState() {
        return this._planeState;
    }

    public void setPlaneState(int planeState) {
        this._planeState = planeState;
    }

    public double getViewPortLeft() {
        return this._viewPortLeft;
    }

    public void setViewPortLeft(double left) {
        this._viewPortLeft = left;
        this.onViewPortChange();
    }

    public double getViewPortRight() {
        return this._viewPortRight;
    }

    public void setViewPortRight(double right) {
        this._viewPortRight = right;
        this.onViewPortChange();
    }

    public double getViewPortTop() {
        return this._viewPortTop;
    }

    public void setViewPortTop(double top) {
        this._viewPortTop = top;
        this.onViewPortChange();
    }

    public double getViewPortBottom() {
        return this._viewPortBottom;
    }

    public void setViewPortBottom(double bottom) {
        this._viewPortBottom = bottom;
        this.onViewPortChange();
    }

    public void setViewPort(double left, double right, double bottom, double top) {
        this.setViewPortLeft(left);
        this.setViewPortRight(right);
        this.setViewPortBottom(bottom);
        this.setViewPortTop(top);
    }

    public FrustumIntersect contains(BoundingVolume bound) {
        if (bound == null) {
            return FrustumIntersect.Inside;
        }
        FrustumIntersect rVal = FrustumIntersect.Inside;
        block5: for (int planeCounter = 6; planeCounter >= 0; --planeCounter) {
            int planeId;
            int mask;
            if (planeCounter == bound.getCheckPlane() || (this._planeState & (mask = 1 << (planeId = planeCounter == 6 ? bound.getCheckPlane() : planeCounter))) != 0) continue;
            switch (bound.whichSide((ReadOnlyPlane)this._worldPlane[planeId])) {
                case Inside: {
                    bound.setCheckPlane(planeId);
                    return FrustumIntersect.Outside;
                }
                case Outside: {
                    this._planeState |= mask;
                    continue block5;
                }
                case Neither: {
                    rVal = FrustumIntersect.Intersects;
                }
            }
        }
        return rVal;
    }

    public void resize(int width, int height) {
        this._width = width;
        this._height = height;
        this.onViewPortChange();
    }

    public void onFrustumChange() {
        if (this.getProjectionMode() == ProjectionMode.Perspective) {
            double nearSquared = this._frustumNear * this._frustumNear;
            double leftSquared = this._frustumLeft * this._frustumLeft;
            double rightSquared = this._frustumRight * this._frustumRight;
            double bottomSquared = this._frustumBottom * this._frustumBottom;
            double topSquared = this._frustumTop * this._frustumTop;
            double inverseLength = 1.0 / Math.sqrt(nearSquared + leftSquared);
            this._coeffLeft[0] = this._frustumNear * inverseLength;
            this._coeffLeft[1] = -this._frustumLeft * inverseLength;
            inverseLength = 1.0 / Math.sqrt(nearSquared + rightSquared);
            this._coeffRight[0] = -this._frustumNear * inverseLength;
            this._coeffRight[1] = this._frustumRight * inverseLength;
            inverseLength = 1.0 / Math.sqrt(nearSquared + bottomSquared);
            this._coeffBottom[0] = this._frustumNear * inverseLength;
            this._coeffBottom[1] = -this._frustumBottom * inverseLength;
            inverseLength = 1.0 / Math.sqrt(nearSquared + topSquared);
            this._coeffTop[0] = -this._frustumNear * inverseLength;
            this._coeffTop[1] = this._frustumTop * inverseLength;
        } else if (this.getProjectionMode() == ProjectionMode.Parallel) {
            if (this._frustumRight > this._frustumLeft) {
                this._coeffLeft[0] = -1.0;
                this._coeffLeft[1] = 0.0;
                this._coeffRight[0] = 1.0;
                this._coeffRight[1] = 0.0;
            } else {
                this._coeffLeft[0] = 1.0;
                this._coeffLeft[1] = 0.0;
                this._coeffRight[0] = -1.0;
                this._coeffRight[1] = 0.0;
            }
            if (this._frustumTop > this._frustumBottom) {
                this._coeffBottom[0] = -1.0;
                this._coeffBottom[1] = 0.0;
                this._coeffTop[0] = 1.0;
                this._coeffTop[1] = 0.0;
            } else {
                this._coeffBottom[0] = 1.0;
                this._coeffBottom[1] = 0.0;
                this._coeffTop[0] = -1.0;
                this._coeffTop[1] = 0.0;
            }
        }
        this._updatePMatrix = true;
        this._updateMVPMatrix = true;
        this._updateInverseMVPMatrix = true;
        this._frustumDirty = true;
    }

    public void onFrameChange() {
        double dirDotLocation = this._direction.dot((ReadOnlyVector3)this._location);
        Vector3 planeNormal = Vector3.fetchTempInstance();
        planeNormal.setX(this._left.getX() * this._coeffLeft[0]);
        planeNormal.setY(this._left.getY() * this._coeffLeft[0]);
        planeNormal.setZ(this._left.getZ() * this._coeffLeft[0]);
        planeNormal.addLocal(this._direction.getX() * this._coeffLeft[1], this._direction.getY() * this._coeffLeft[1], this._direction.getZ() * this._coeffLeft[1]);
        this._worldPlane[0].setNormal((ReadOnlyVector3)planeNormal);
        this._worldPlane[0].setConstant(this._location.dot((ReadOnlyVector3)planeNormal));
        planeNormal.setX(this._left.getX() * this._coeffRight[0]);
        planeNormal.setY(this._left.getY() * this._coeffRight[0]);
        planeNormal.setZ(this._left.getZ() * this._coeffRight[0]);
        planeNormal.addLocal(this._direction.getX() * this._coeffRight[1], this._direction.getY() * this._coeffRight[1], this._direction.getZ() * this._coeffRight[1]);
        this._worldPlane[1].setNormal((ReadOnlyVector3)planeNormal);
        this._worldPlane[1].setConstant(this._location.dot((ReadOnlyVector3)planeNormal));
        planeNormal.setX(this._up.getX() * this._coeffBottom[0]);
        planeNormal.setY(this._up.getY() * this._coeffBottom[0]);
        planeNormal.setZ(this._up.getZ() * this._coeffBottom[0]);
        planeNormal.addLocal(this._direction.getX() * this._coeffBottom[1], this._direction.getY() * this._coeffBottom[1], this._direction.getZ() * this._coeffBottom[1]);
        this._worldPlane[2].setNormal((ReadOnlyVector3)planeNormal);
        this._worldPlane[2].setConstant(this._location.dot((ReadOnlyVector3)planeNormal));
        planeNormal.setX(this._up.getX() * this._coeffTop[0]);
        planeNormal.setY(this._up.getY() * this._coeffTop[0]);
        planeNormal.setZ(this._up.getZ() * this._coeffTop[0]);
        planeNormal.addLocal(this._direction.getX() * this._coeffTop[1], this._direction.getY() * this._coeffTop[1], this._direction.getZ() * this._coeffTop[1]);
        this._worldPlane[3].setNormal((ReadOnlyVector3)planeNormal);
        this._worldPlane[3].setConstant(this._location.dot((ReadOnlyVector3)planeNormal));
        if (this.getProjectionMode() == ProjectionMode.Parallel) {
            if (this._frustumRight > this._frustumLeft) {
                this._worldPlane[0].setConstant(this._worldPlane[0].getConstant() + this._frustumLeft);
                this._worldPlane[1].setConstant(this._worldPlane[1].getConstant() - this._frustumRight);
            } else {
                this._worldPlane[0].setConstant(this._worldPlane[0].getConstant() - this._frustumLeft);
                this._worldPlane[1].setConstant(this._worldPlane[1].getConstant() + this._frustumRight);
            }
            if (this._frustumBottom > this._frustumTop) {
                this._worldPlane[3].setConstant(this._worldPlane[3].getConstant() + this._frustumTop);
                this._worldPlane[2].setConstant(this._worldPlane[2].getConstant() - this._frustumBottom);
            } else {
                this._worldPlane[3].setConstant(this._worldPlane[3].getConstant() - this._frustumTop);
                this._worldPlane[2].setConstant(this._worldPlane[2].getConstant() + this._frustumBottom);
            }
        }
        planeNormal.set((ReadOnlyVector3)this._direction).negateLocal();
        this._worldPlane[4].setNormal((ReadOnlyVector3)planeNormal);
        this._worldPlane[4].setConstant(-(dirDotLocation + this._frustumFar));
        this._worldPlane[5].setNormal((ReadOnlyVector3)this._direction);
        this._worldPlane[5].setConstant(dirDotLocation + this._frustumNear);
        Vector3.releaseTempInstance((Vector3)planeNormal);
        this._updateMVMatrix = true;
        this._updateMVPMatrix = true;
        this._updateInverseMVPMatrix = true;
        this._frameDirty = true;
    }

    protected void updateProjectionMatrix() {
        if (this.getProjectionMode() == ProjectionMode.Parallel) {
            this._projection.setIdentity();
            this._projection.setM00(2.0 / (this._frustumRight - this._frustumLeft));
            this._projection.setM11(2.0 / (this._frustumTop - this._frustumBottom));
            this._projection.setM22(-2.0 / (this._frustumFar - this._frustumNear));
            this._projection.setM30(-(this._frustumRight + this._frustumLeft) / (this._frustumRight - this._frustumLeft));
            this._projection.setM31(-(this._frustumTop + this._frustumBottom) / (this._frustumTop - this._frustumBottom));
            this._projection.setM32(-(this._frustumFar + this._frustumNear) / (this._frustumFar - this._frustumNear));
        } else if (this.getProjectionMode() == ProjectionMode.Perspective) {
            this._projection.setIdentity();
            this._projection.setM00(2.0 * this._frustumNear / (this._frustumRight - this._frustumLeft));
            this._projection.setM11(2.0 * this._frustumNear / (this._frustumTop - this._frustumBottom));
            this._projection.setM20((this._frustumRight + this._frustumLeft) / (this._frustumRight - this._frustumLeft));
            this._projection.setM21((this._frustumTop + this._frustumBottom) / (this._frustumTop - this._frustumBottom));
            this._projection.setM22(-(this._frustumFar + this._frustumNear) / (this._frustumFar - this._frustumNear));
            this._projection.setM23(-1.0);
            this._projection.setM32(-(2.0 * this._frustumFar * this._frustumNear) / (this._frustumFar - this._frustumNear));
            this._projection.setM33(-0.0);
        }
        this._updatePMatrix = false;
    }

    public void setProjectionMatrix(ReadOnlyMatrix4 projection) {
        this._projection.set(projection);
        this._frustumDirty = true;
    }

    public ReadOnlyMatrix4 getProjectionMatrix() {
        this.checkProjection();
        return this._projection;
    }

    protected void updateModelViewMatrix() {
        this._modelView.setIdentity();
        this._modelView.setM00(-this._left.getX());
        this._modelView.setM10(-this._left.getY());
        this._modelView.setM20(-this._left.getZ());
        this._modelView.setM01(this._up.getX());
        this._modelView.setM11(this._up.getY());
        this._modelView.setM21(this._up.getZ());
        this._modelView.setM02(-this._direction.getX());
        this._modelView.setM12(-this._direction.getY());
        this._modelView.setM22(-this._direction.getZ());
        this._modelView.setM30(this._left.dot((ReadOnlyVector3)this._location));
        this._modelView.setM31(-this._up.dot((ReadOnlyVector3)this._location));
        this._modelView.setM32(this._direction.dot((ReadOnlyVector3)this._location));
    }

    public ReadOnlyMatrix4 getModelViewMatrix() {
        this.checkModelView();
        return this._modelView;
    }

    public ReadOnlyMatrix4 getModelViewProjectionMatrix() {
        this.checkModelViewProjection();
        return this._modelViewProjection;
    }

    public ReadOnlyMatrix4 getModelViewProjectionInverseMatrix() {
        this.checkInverseModelViewProjection();
        return this._modelViewProjectionInverse;
    }

    public Ray3 getPickRay(ReadOnlyVector2 screenPosition, boolean flipVertical, Ray3 store) {
        Ray3 result;
        Vector2 pos = Vector2.fetchTempInstance().set(screenPosition);
        if (flipVertical) {
            pos.setY((double)this.getHeight() - screenPosition.getY());
        }
        if ((result = store) == null) {
            result = new Ray3();
        }
        Vector3 origin = Vector3.fetchTempInstance();
        Vector3 direction = Vector3.fetchTempInstance();
        this.getWorldCoordinates((ReadOnlyVector2)pos, 0.0, origin);
        this.getWorldCoordinates((ReadOnlyVector2)pos, 0.3, direction).subtractLocal((ReadOnlyVector3)origin).normalizeLocal();
        result.setOrigin((ReadOnlyVector3)origin);
        result.setDirection((ReadOnlyVector3)direction);
        Vector2.releaseTempInstance((Vector2)pos);
        Vector3.releaseTempInstance((Vector3)origin);
        Vector3.releaseTempInstance((Vector3)direction);
        return result;
    }

    public Vector3 getWorldCoordinates(ReadOnlyVector2 screenPosition, double zDepth) {
        return this.getWorldCoordinates(screenPosition, zDepth, null);
    }

    public Vector3 getWorldCoordinates(ReadOnlyVector2 screenPosition, double zDepth, Vector3 store) {
        if (store == null) {
            store = new Vector3();
        }
        this.checkInverseModelViewProjection();
        Vector4 position = Vector4.fetchTempInstance();
        position.set((screenPosition.getX() / (double)this.getWidth() - this._viewPortLeft) / (this._viewPortRight - this._viewPortLeft) * 2.0 - 1.0, (screenPosition.getY() / (double)this.getHeight() - this._viewPortBottom) / (this._viewPortTop - this._viewPortBottom) * 2.0 - 1.0, zDepth * 2.0 - 1.0, 1.0);
        this._modelViewProjectionInverse.applyPre((ReadOnlyVector4)position, position);
        position.multiplyLocal(1.0 / position.getW());
        store.setX(position.getX());
        store.setY(position.getY());
        store.setZ(position.getZ());
        Vector4.releaseTempInstance((Vector4)position);
        return store;
    }

    public Vector3 getScreenCoordinates(ReadOnlyVector3 worldPos) {
        return this.getScreenCoordinates(worldPos, null);
    }

    public Vector3 getScreenCoordinates(ReadOnlyVector3 worldPosition, Vector3 store) {
        store = this.getNormalizedDeviceCoordinates(worldPosition, store);
        store.setX((store.getX() + 1.0) * (this._viewPortRight - this._viewPortLeft) / 2.0 * (double)this.getWidth());
        store.setY((store.getY() + 1.0) * (this._viewPortTop - this._viewPortBottom) / 2.0 * (double)this.getHeight());
        store.setZ((store.getZ() + 1.0) / 2.0);
        return store;
    }

    public Vector3 getFrustumCoordinates(ReadOnlyVector3 worldPos) {
        return this.getFrustumCoordinates(worldPos, null);
    }

    public Vector3 getFrustumCoordinates(ReadOnlyVector3 worldPosition, Vector3 store) {
        store = this.getNormalizedDeviceCoordinates(worldPosition, store);
        store.setX((store.getX() + 1.0) * (this._frustumRight - this._frustumLeft) / 2.0 + this._frustumLeft);
        store.setY((store.getY() + 1.0) * (this._frustumTop - this._frustumBottom) / 2.0 + this._frustumBottom);
        store.setZ((store.getZ() + 1.0) * (this._frustumFar - this._frustumNear) / 2.0 + this._frustumNear);
        return store;
    }

    public Vector3 getNormalizedDeviceCoordinates(ReadOnlyVector3 worldPos) {
        return this.getNormalizedDeviceCoordinates(worldPos, null);
    }

    public Vector3 getNormalizedDeviceCoordinates(ReadOnlyVector3 worldPosition, Vector3 store) {
        if (store == null) {
            store = new Vector3();
        }
        this.checkModelViewProjection();
        Vector4 position = Vector4.fetchTempInstance();
        position.set(worldPosition.getX(), worldPosition.getY(), worldPosition.getZ(), 1.0);
        this._modelViewProjection.applyPre((ReadOnlyVector4)position, position);
        position.multiplyLocal(1.0 / position.getW());
        store.setX(position.getX());
        store.setY(position.getY());
        store.setZ(position.getZ());
        Vector4.releaseTempInstance((Vector4)position);
        return store;
    }

    private void checkModelView() {
        if (this._updateMVMatrix) {
            this.updateModelViewMatrix();
            this._updateMVMatrix = false;
        }
    }

    private void checkProjection() {
        if (this._updatePMatrix) {
            this.updateProjectionMatrix();
            this._updatePMatrix = false;
        }
    }

    private void checkModelViewProjection() {
        if (this._updateMVPMatrix) {
            this._modelViewProjection.set(this.getModelViewMatrix()).multiplyLocal(this.getProjectionMatrix());
            this._updateMVPMatrix = false;
        }
    }

    private void checkInverseModelViewProjection() {
        if (this._updateInverseMVPMatrix) {
            this.checkModelViewProjection();
            this._modelViewProjection.invert(this._modelViewProjectionInverse);
            this._updateInverseMVPMatrix = false;
        }
    }

    public int getHeight() {
        return this._height;
    }

    public ProjectionMode getProjectionMode() {
        return this._projectionMode;
    }

    public void setProjectionMode(ProjectionMode projectionMode) {
        this._projectionMode = projectionMode;
    }

    public int getWidth() {
        return this._width;
    }

    public void apply(Renderer renderer) {
        ContextManager.getCurrentContext().setCurrentCamera(this);
        if (this._depthRangeDirty) {
            renderer.setDepthRange(this._depthRangeNear, this._depthRangeFar);
            this._depthRangeDirty = false;
        }
        if (this._frustumDirty) {
            this.applyProjectionMatrix(renderer);
            this._frustumDirty = false;
        }
        if (this._viewPortDirty) {
            this.applyViewport(renderer);
            this._viewPortDirty = false;
        }
        if (this._frameDirty) {
            this.applyModelViewMatrix(renderer);
            this._frameDirty = false;
        }
    }

    protected void onViewPortChange() {
        this._viewPortDirty = true;
    }

    protected void applyProjectionMatrix(Renderer renderer) {
        this._matrixBuffer.rewind();
        this.getProjectionMatrix().toFloatBuffer(this._matrixBuffer);
        this._matrixBuffer.rewind();
        renderer.setProjectionMatrix(this._matrixBuffer);
    }

    protected void applyViewport(Renderer renderer) {
        int x = (int)(this._viewPortLeft * (double)this._width);
        int y = (int)(this._viewPortBottom * (double)this._height);
        int w = (int)((this._viewPortRight - this._viewPortLeft) * (double)this._width);
        int h = (int)((this._viewPortTop - this._viewPortBottom) * (double)this._height);
        renderer.setViewport(x, y, w, h);
    }

    protected void applyModelViewMatrix(Renderer renderer) {
        this._matrixBuffer.rewind();
        this.getModelViewMatrix().toFloatBuffer(this._matrixBuffer);
        this._matrixBuffer.rewind();
        renderer.setModelViewMatrix(this._matrixBuffer);
    }

    public void write(OutputCapsule capsule) throws IOException {
        capsule.write((Savable)this._location, "location", (Savable)new Vector3(Vector3.ZERO));
        capsule.write((Savable)this._left, "left", (Savable)new Vector3(Vector3.UNIT_X));
        capsule.write((Savable)this._up, "up", (Savable)new Vector3(Vector3.UNIT_Y));
        capsule.write((Savable)this._direction, "direction", (Savable)new Vector3(Vector3.UNIT_Z));
        capsule.write(this._frustumNear, "frustumNear", 1.0);
        capsule.write(this._frustumFar, "frustumFar", 2.0);
        capsule.write(this._frustumLeft, "frustumLeft", -0.5);
        capsule.write(this._frustumRight, "frustumRight", 0.5);
        capsule.write(this._frustumTop, "frustumTop", 0.5);
        capsule.write(this._frustumBottom, "frustumBottom", -0.5);
        capsule.write(this._coeffLeft, "coeffLeft", new double[2]);
        capsule.write(this._coeffRight, "coeffRight", new double[2]);
        capsule.write(this._coeffBottom, "coeffBottom", new double[2]);
        capsule.write(this._coeffTop, "coeffTop", new double[2]);
        capsule.write(this._planeQuantity, "planeQuantity", 6);
        capsule.write(this._viewPortLeft, "viewPortLeft", 0.0);
        capsule.write(this._viewPortRight, "viewPortRight", 1.0);
        capsule.write(this._viewPortTop, "viewPortTop", 1.0);
        capsule.write(this._viewPortBottom, "viewPortBottom", 0.0);
        capsule.write(this._width, "width", 0);
        capsule.write(this._height, "height", 0);
        capsule.write(this._depthRangeNear, "depthRangeNear", 0.0);
        capsule.write(this._depthRangeFar, "depthRangeFar", 1.0);
    }

    public void read(InputCapsule capsule) throws IOException {
        this._location.set((ReadOnlyVector3)((Vector3)capsule.readSavable("location", (Savable)new Vector3(Vector3.ZERO))));
        this._left.set((ReadOnlyVector3)((Vector3)capsule.readSavable("left", (Savable)new Vector3(Vector3.UNIT_X))));
        this._up.set((ReadOnlyVector3)((Vector3)capsule.readSavable("up", (Savable)new Vector3(Vector3.UNIT_Y))));
        this._direction.set((ReadOnlyVector3)((Vector3)capsule.readSavable("direction", (Savable)new Vector3(Vector3.UNIT_Z))));
        this._frustumNear = capsule.readDouble("frustumNear", 1.0);
        this._frustumFar = capsule.readDouble("frustumFar", 2.0);
        this._frustumLeft = capsule.readDouble("frustumLeft", -0.5);
        this._frustumRight = capsule.readDouble("frustumRight", 0.5);
        this._frustumTop = capsule.readDouble("frustumTop", 0.5);
        this._frustumBottom = capsule.readDouble("frustumBottom", -0.5);
        this._coeffLeft = capsule.readDoubleArray("coeffLeft", new double[2]);
        this._coeffRight = capsule.readDoubleArray("coeffRight", new double[2]);
        this._coeffBottom = capsule.readDoubleArray("coeffBottom", new double[2]);
        this._coeffTop = capsule.readDoubleArray("coeffTop", new double[2]);
        this._planeQuantity = capsule.readInt("planeQuantity", 6);
        this._viewPortLeft = capsule.readDouble("viewPortLeft", 0.0);
        this._viewPortRight = capsule.readDouble("viewPortRight", 1.0);
        this._viewPortTop = capsule.readDouble("viewPortTop", 1.0);
        this._viewPortBottom = capsule.readDouble("viewPortBottom", 0.0);
        this._width = capsule.readInt("width", 0);
        this._height = capsule.readInt("height", 0);
        this._depthRangeNear = capsule.readDouble("depthRangeNear", 0.0);
        this._depthRangeFar = capsule.readDouble("depthRangeFar", 1.0);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._location.set((ReadOnlyVector3)((Vector3)in.readObject()));
        this._left.set((ReadOnlyVector3)((Vector3)in.readObject()));
        this._up.set((ReadOnlyVector3)((Vector3)in.readObject()));
        this._direction.set((ReadOnlyVector3)((Vector3)in.readObject()));
        this._frustumNear = in.readDouble();
        this._frustumFar = in.readDouble();
        this._frustumLeft = in.readDouble();
        this._frustumRight = in.readDouble();
        this._frustumTop = in.readDouble();
        this._frustumBottom = in.readDouble();
        this._coeffLeft = (double[])in.readObject();
        this._coeffRight = (double[])in.readObject();
        this._coeffBottom = (double[])in.readObject();
        this._coeffTop = (double[])in.readObject();
        this._planeQuantity = in.readInt();
        this._viewPortLeft = in.readDouble();
        this._viewPortRight = in.readDouble();
        this._viewPortTop = in.readDouble();
        this._viewPortBottom = in.readDouble();
        this._width = in.readInt();
        this._height = in.readInt();
        this._depthRangeNear = in.readDouble();
        this._depthRangeFar = in.readDouble();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._location);
        out.writeObject(this._left);
        out.writeObject(this._up);
        out.writeObject(this._direction);
        out.writeDouble(this._frustumNear);
        out.writeDouble(this._frustumFar);
        out.writeDouble(this._frustumLeft);
        out.writeDouble(this._frustumRight);
        out.writeDouble(this._frustumTop);
        out.writeDouble(this._frustumBottom);
        out.writeObject(this._coeffLeft);
        out.writeObject(this._coeffRight);
        out.writeObject(this._coeffBottom);
        out.writeObject(this._coeffTop);
        out.writeInt(this._planeQuantity);
        out.writeDouble(this._viewPortLeft);
        out.writeDouble(this._viewPortRight);
        out.writeDouble(this._viewPortTop);
        out.writeDouble(this._viewPortBottom);
        out.writeInt(this._width);
        out.writeInt(this._height);
        out.writeDouble(this._depthRangeNear);
        out.writeDouble(this._depthRangeFar);
    }

    public String toString() {
        return "com.ardor3d.renderer.Camera: loc - " + Arrays.toString(this.getLocation().toArray(null)) + " dir - " + Arrays.toString(this.getDirection().toArray(null)) + " up - " + Arrays.toString(this.getUp().toArray(null)) + " left - " + Arrays.toString(this.getLeft().toArray(null));
    }

    public Class<? extends Camera> getClassTag() {
        return this.getClass();
    }

    public static Camera getCurrentCamera() {
        if (ContextManager.getCurrentContext() == null) {
            return null;
        }
        return ContextManager.getCurrentContext().getCurrentCamera();
    }

    public boolean isFrameDirty() {
        return this._frameDirty;
    }

    public static enum ProjectionMode {
        Perspective,
        Parallel,
        Custom;

    }

    public static enum FrustumIntersect {
        Outside,
        Inside,
        Intersects;

    }
}

