/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.renderer.ContextCleanListener;
import com.ardor3d.renderer.RenderContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ContextManager {
    protected static RenderContext currentContext = null;
    private static List<ContextCleanListener> _cleanListeners = new ArrayList<ContextCleanListener>();
    protected static final Map<Object, RenderContext> contextStore = new WeakHashMap<Object, RenderContext>();

    public static RenderContext getCurrentContext() {
        return currentContext;
    }

    public static RenderContext switchContext(Object contextKey) {
        currentContext = contextStore.get(contextKey);
        if (currentContext == null) {
            throw new IllegalArgumentException("contextKey not found in context store.");
        }
        return currentContext;
    }

    public static void removeContext(Object contextKey) {
        contextStore.remove(contextKey);
    }

    public static void addContext(Object contextKey, RenderContext context) {
        contextStore.put(contextKey, context);
    }

    public static RenderContext getContextForKey(Object key) {
        return contextStore.get(key);
    }

    public static RenderContext getContextForRef(Object glref) {
        if (glref == null) {
            return null;
        }
        for (RenderContext context : contextStore.values()) {
            if (!glref.equals(context.getGlContextRep())) continue;
            return context;
        }
        return null;
    }

    public static void fireCleanContextEvent(RenderContext renderContext) {
        for (ContextCleanListener listener : _cleanListeners) {
            listener.cleanForContext(renderContext);
        }
    }

    public static void addContextCleanListener(ContextCleanListener listener) {
        _cleanListeners.add(listener);
    }
}

