/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

public enum IndexMode {
    Triangles(true),
    TriangleStrip(true),
    TriangleFan(true),
    Quads(true),
    QuadStrip(true),
    Lines(false),
    LineStrip(false),
    LineLoop(false),
    Points(false);

    private final boolean _hasPolygons;

    private IndexMode(boolean hasPolygons) {
        this._hasPolygons = hasPolygons;
    }

    public boolean hasPolygons() {
        return this._hasPolygons;
    }

    public int getVertexCount() {
        switch (this) {
            case Triangles: 
            case TriangleStrip: 
            case TriangleFan: {
                return 3;
            }
            case Quads: 
            case QuadStrip: {
                return 4;
            }
            case Lines: 
            case LineStrip: 
            case LineLoop: {
                return 2;
            }
            case Points: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + (Object)((Object)this));
    }

    public static int getPrimitiveCount(IndexMode indexMode, int size) {
        switch (indexMode) {
            case Triangles: {
                return size / 3;
            }
            case TriangleStrip: 
            case TriangleFan: {
                return size - 2;
            }
            case Quads: {
                return size / 4;
            }
            case QuadStrip: {
                return size / 2 - 1;
            }
            case Lines: {
                return size / 2;
            }
            case LineStrip: {
                return size - 1;
            }
            case LineLoop: {
                return size;
            }
            case Points: {
                return size;
            }
        }
        throw new IllegalArgumentException("unimplemented index mode: " + (Object)((Object)indexMode));
    }
}

