/*
 * Decompiled with CFR 0.152.
 */
package com.ardor3d.renderer;

import com.ardor3d.renderer.AbstractFBOTextureRenderer;
import com.ardor3d.renderer.Camera;
import com.ardor3d.renderer.ContextCapabilities;
import com.ardor3d.renderer.ContextManager;
import com.ardor3d.renderer.state.RenderState;
import com.ardor3d.renderer.state.record.LineRecord;
import com.ardor3d.renderer.state.record.RendererRecord;
import com.ardor3d.renderer.state.record.StateRecord;
import java.util.EnumMap;
import java.util.Map;
import java.util.Stack;

public class RenderContext {
    protected final EnumMap<RenderState.StateType, RenderState> _enforcedStates = new EnumMap(RenderState.StateType.class);
    protected final Stack<EnumMap<RenderState.StateType, RenderState>> _enforcedBackStack = new Stack();
    protected final Stack<AbstractFBOTextureRenderer> _textureRenderers = new Stack();
    protected final EnumMap<RenderState.StateType, RenderState> _currentStates = new EnumMap(RenderState.StateType.class);
    protected final EnumMap<RenderState.StateType, StateRecord> _stateRecords = new EnumMap(RenderState.StateType.class);
    protected final LineRecord _lineRecord = new LineRecord();
    protected final RendererRecord _rendererRecord = this.createRendererRecord();
    protected final Object _glContextRep;
    protected final ContextCapabilities _capabilities;
    protected final Object _contextKey;
    protected Camera _currentCamera = null;

    public RenderContext(Object key, ContextCapabilities caps) {
        this(key, caps, null);
    }

    public RenderContext(Object key, ContextCapabilities caps, RenderContext shared) {
        this._contextKey = key;
        this._capabilities = caps;
        this.setupRecords();
        this._glContextRep = shared == null ? new Object() : shared._glContextRep;
    }

    protected RendererRecord createRendererRecord() {
        RendererRecord rendererRecord = new RendererRecord();
        return rendererRecord;
    }

    protected void setupRecords() {
        for (RenderState.StateType type : RenderState.StateType.values()) {
            this._stateRecords.put(type, RenderState.createState(type).createStateRecord(this._capabilities));
        }
    }

    public void invalidateStates() {
        for (RenderState.StateType type : RenderState.StateType.values()) {
            this._stateRecords.get((Object)type).invalidate();
        }
        this._lineRecord.invalidate();
        this._rendererRecord.invalidate();
        this.clearCurrentStates();
    }

    public ContextCapabilities getCapabilities() {
        return this._capabilities;
    }

    public StateRecord getStateRecord(RenderState.StateType type) {
        return this._stateRecords.get((Object)type);
    }

    public LineRecord getLineRecord() {
        return this._lineRecord;
    }

    public RendererRecord getRendererRecord() {
        return this._rendererRecord;
    }

    public void enforceState(RenderState state) {
        this._enforcedStates.put(state.getType(), state);
    }

    public void enforceStates(EnumMap<RenderState.StateType, RenderState> states) {
        this._enforcedStates.putAll(states);
    }

    public void clearEnforcedState(RenderState.StateType type) {
        this._enforcedStates.remove((Object)type);
    }

    public void clearEnforcedStates() {
        this._enforcedStates.clear();
    }

    public void clearCurrentStates() {
        this._currentStates.clear();
    }

    public void clearCurrentState(RenderState.StateType type) {
        this._currentStates.remove((Object)type);
    }

    public boolean hasEnforcedStates() {
        return !this._enforcedStates.isEmpty();
    }

    public RenderState getEnforcedState(RenderState.StateType type) {
        return this._enforcedStates.get((Object)type);
    }

    public RenderState getCurrentState(RenderState.StateType type) {
        return this._currentStates.get((Object)type);
    }

    public Object getContextKey() {
        return this._contextKey;
    }

    public void setCurrentState(RenderState.StateType type, RenderState state) {
        this._currentStates.put(type, state);
    }

    public Camera getCurrentCamera() {
        return this._currentCamera;
    }

    public void setCurrentCamera(Camera cam) {
        this._currentCamera = cam;
    }

    public Object getGlContextRep() {
        return this._glContextRep;
    }

    public void pushEnforcedStates() {
        this._enforcedBackStack.push(new EnumMap<RenderState.StateType, RenderState>(this._enforcedStates));
    }

    public void popEnforcedStates() {
        this._enforcedStates.clear();
        this._enforcedStates.putAll((Map<RenderState.StateType, RenderState>)this._enforcedBackStack.pop());
    }

    public void pushFBOTextureRenderer(AbstractFBOTextureRenderer top) {
        if (this._textureRenderers.size() > 0) {
            this._textureRenderers.peek().deactivate();
        }
        this._textureRenderers.push(top);
        top.activate();
    }

    public void popFBOTextureRenderer() {
        AbstractFBOTextureRenderer top = this._textureRenderers.pop();
        top.deactivate();
        if (this._textureRenderers.size() > 0) {
            top = this._textureRenderers.peek();
            top.activate();
        }
    }

    public void contextLost() {
        ContextManager.fireCleanContextEvent(this);
        this.invalidateStates();
        if (this._currentCamera != null) {
            this._currentCamera.update();
        }
    }
}

